/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.swing;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.Validator;
import EDU.bmrb.validator.swing.ErrorTextArea;
import EDU.bmrb.validator.swing.MenuBar;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class Main
extends JFrame {
    public Main(MenuBar menu, ErrorTextArea err) {
        this.initComponents();
        this.setJMenuBar(menu);
        this.getContentPane().add((Component)err, "Center");
    }

    private void initComponents() {
        this.setTitle("Validator");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Main.this.exitForm(evt);
            }
        });
        this.pack();
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        ErrorList errs = new ErrorList();
        Config cfg = args.length > 0 ? new Config(args[0]) : new Config();
        Star_DB star = new Star_DB(cfg.getProperties());
        Validator v = new Validator(errs, cfg, star);
        Integer[] funcs = cfg.getSelectedFunctions();
        if (funcs != null) {
            for (int i = 0; i < funcs.length; ++i) {
                if (v.select(funcs[i])) continue;
                System.err.println("No such function: " + funcs[i]);
            }
        }
        ErrorTextArea eta = new ErrorTextArea(errs);
        MenuBar bar = new MenuBar(v, eta, true);
        Main m = new Main(bar, eta);
        m.setSize(new Dimension(300, 300));
        m.show();
    }
}

