/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.swing;

import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.Function;
import EDU.bmrb.validator.Validator;
import EDU.bmrb.validator.swing.ErrorTextArea;
import EDU.bmrb.validator.swing.StarFileFilter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class MenuBar
extends JMenuBar {
    public static final String KEY_DICT_LABEL = "Validator.action.dictionary.name";
    public static final String KEY_DICT_TIP = "Validator.action.dictionary.tip";
    public static final String KEY_DICT_ICON = "Validator.action.dictionary.icon";
    public static final String KEY_DICT_DIR = "Validator.dictdir";
    public static final String KEY_VALIDATE_LABEL = "Validator.action.run.name";
    public static final String KEY_VALIDATE_TIP = "Validator.action.run.tip";
    public static final String KEY_VALIDATE_ICON = "Validator.action.run.icon";
    public static final String KEY_EDIT_LABEL = "Validator.action.edit.name";
    public static final String KEY_EDIT_TIP = "Validator.action.edit.tip";
    public static final String KEY_EDIT_ICON = "Validator.action.edit.icon";
    public static final String KEY_ISF_LABEL = "Validator.action.isf.name";
    public static final String KEY_ISF_TIP = "Validator.action.isf.tip";
    public static final String KEY_ISF_ICON = "Validator.action.isf.icon";
    public static final String KEY_SEL_LABEL = "Validator.action.select.name";
    public static final String KEY_SEL_TIP = "Validator.action.select.tip";
    public static final String KEY_SEL_ICON = "Validator.action.select.icon";
    public static final String KEY_SELALL_LABEL = "Validator.action.selectall.name";
    public static final String KEY_SELALL_TIP = "Validator.action.selectall.tip";
    public static final String KEY_SELALL_ICON = "Validator.action.selectall.icon";
    public static final String KEY_SEL_POPUP = "Validator.popup.select.name";
    public static final String KEY_CLEAR_LABEL = "Validator.action.clear.name";
    public static final String KEY_CLEAR_TIP = "Validator.action.clear.tip";
    public static final String KEY_CLEAR_ICON = "Validator.action.clear.icon";
    private Validator fVal = null;
    private ErrorTextArea fErrorPane = null;
    private JPopupMenu fSelectPopup = null;
    private JMenuItem fSelectMenu = null;

    public MenuBar(Validator validator, ErrorTextArea errs, boolean standalone) {
        if (validator == null) {
            throw new NullPointerException("Parameter missing");
        }
        this.fVal = validator;
        this.fErrorPane = errs;
        String[] cats = this.fVal.listCategories();
        this.addSelectPopup();
        if (standalone) {
            this.addFileMenu();
            this.addRunMenu();
        }
        if (cats != null) {
            for (int i = 0; i < cats.length; ++i) {
                JMenu m = new JMenu();
                m.setText(cats[i]);
                String[] funcs = this.fVal.listFunctionsByCategory(cats[i]);
                if (funcs != null) {
                    for (int j = 0; j < funcs.length; ++j) {
                        JCheckBoxMenuItem item = new JCheckBoxMenuItem();
                        Function func = this.fVal.get(funcs[j]);
                        item.setText(func.getName());
                        item.setToolTipText(func.getDescription());
                        item.addItemListener(new ItemListener(){

                            public void itemStateChanged(ItemEvent evt) {
                                MenuBar.this.CheckBoxMenuItemStateChanged(evt);
                            }
                        });
                        item.setSelected(func.isSelected());
                        m.add(item);
                    }
                }
                this.add(m);
            }
        }
    }

    private void CheckBoxMenuItemStateChanged(ItemEvent evt) {
        JCheckBoxMenuItem item = (JCheckBoxMenuItem)evt.getSource();
        if (item.getState()) {
            this.fVal.select(item.getText());
        } else {
            this.fVal.deselect(item.getText());
        }
    }

    private void addSelectPopup() {
        JMenuItem i = null;
        this.fSelectPopup = new JPopupMenu();
        this.fSelectPopup.setLabel(this.fVal.getConfig().get(KEY_SEL_LABEL));
        String[] cats = this.fVal.listCategories();
        if (cats != null) {
            for (int j = 0; j < cats.length; ++j) {
                i = new JMenuItem();
                i.setText(cats[j]);
                i.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        MenuBar.this.PopupMenuItemActionPerformed(evt);
                    }
                });
                this.fSelectPopup.add(i);
            }
        }
    }

    private void PopupMenuItemActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.getMenuCount(); ++i) {
            JMenu m = this.getMenu(i);
            if (!m.getText().equals(evt.getActionCommand())) continue;
            for (int j = 0; j < m.getItemCount(); ++j) {
                if (!(m.getItem(j) instanceof JCheckBoxMenuItem)) continue;
                ((JCheckBoxMenuItem)m.getItem(j)).setSelected(true);
            }
            return;
        }
    }

    private void addFileMenu() {
        JMenu m = new JMenu();
        m.setText("File");
        JMenuItem i = new JMenuItem();
        i.setText("Open");
        i.setToolTipText("Select file for validation");
        i.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MenuBar.this.FileOpenMenuActionPerformed(evt);
            }
        });
        m.add(i);
        i = new JMenuItem();
        i.setText("Save Messages As");
        i.setToolTipText("Save validation error messages to a file");
        i.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MenuBar.this.FileSaveMessagesAsMenuActionPerformed(evt);
            }
        });
        m.add(i);
        i = new JMenuItem();
        i.setText("Save Entry As");
        i.setToolTipText("Save modified entry to a file");
        i.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MenuBar.this.FileSaveEntryAsMenuActionPerformed(evt);
            }
        });
        m.add(i);
        this.add(m);
    }

    private File chooseFile(String startdir, boolean starfile, boolean save) {
        JFileChooser fc = new JFileChooser();
        if (starfile) {
            fc.setFileFilter(new StarFileFilter());
        }
        try {
            fc.setCurrentDirectory(new File(startdir));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        fc.setBounds(30, 60, 500, 326);
        int rc = save ? fc.showSaveDialog(this) : fc.showOpenDialog(this);
        if (rc == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    private void FileOpenMenuActionPerformed(ActionEvent evt) {
        File infile = this.chooseFile(this.fVal.getConfig().get("Validator.workdir"), true, false);
        if (infile == null) {
            return;
        }
        try {
            this.fVal.setInputStream(new BufferedReader(new InputStreamReader(new FileInputStream(infile))));
            this.fVal.load();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private void FileSaveMessagesAsMenuActionPerformed(ActionEvent evt) {
        File f = this.chooseFile(this.fVal.getConfig().get("Validator.workdir"), false, true);
        if (f == null) {
            return;
        }
        try {
            this.fVal.getErrorList().printErrors(new FileWriter(f));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private void FileSaveEntryAsMenuActionPerformed(ActionEvent evt) {
        File f = this.chooseFile(this.fVal.getConfig().get("Validator.workdir"), true, true);
        if (f == null) {
            return;
        }
        try {
            this.fVal.unparse(new PrintWriter(new FileWriter(f)));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private void addRunMenu() {
        String icon = null;
        JMenu m = new JMenu();
        m.setText("Run");
        JMenuItem i = new JMenuItem();
        i = new JMenuItem();
        i.setText(this.fVal.getConfig().get(KEY_DICT_LABEL));
        i.setToolTipText(this.fVal.getConfig().get(KEY_DICT_TIP));
        icon = this.fVal.getConfig().get(KEY_DICT_ICON);
        if (icon != null) {
            i.setIcon(new ImageIcon(icon));
        }
        i.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MenuBar.this.RunMenuLoadDictionaryActionPerformed(evt);
            }
        });
        m.add(i);
        m.add(new JSeparator());
        i = new JMenuItem();
        i.setText(this.fVal.getConfig().get(KEY_VALIDATE_LABEL));
        i.setToolTipText(this.fVal.getConfig().get(KEY_VALIDATE_TIP));
        icon = this.fVal.getConfig().get(KEY_VALIDATE_ICON);
        if (icon != null) {
            i.setIcon(new ImageIcon(icon));
        }
        i.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MenuBar.this.RunMenuValidateActionPerformed(evt);
            }
        });
        m.add(i);
        i = new JMenuItem();
        i.setText(this.fVal.getConfig().get(KEY_EDIT_LABEL));
        i.setToolTipText(this.fVal.getConfig().get(KEY_EDIT_TIP));
        icon = this.fVal.getConfig().get(KEY_EDIT_ICON);
        if (icon != null) {
            i.setIcon(new ImageIcon(icon));
        }
        i.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MenuBar.this.RunMenuEditActionPerformed(evt);
            }
        });
        m.add(i);
        m.add(new JSeparator());
        i = new JMenuItem();
        i.setText(this.fVal.getConfig().get(KEY_ISF_LABEL));
        i.setToolTipText(this.fVal.getConfig().get(KEY_ISF_TIP));
        icon = this.fVal.getConfig().get(KEY_ISF_ICON);
        if (icon != null) {
            i.setIcon(new ImageIcon(icon));
        }
        i.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MenuBar.this.RunMenuISFActionPerformed(evt);
            }
        });
        m.add(i);
        m.add(new JSeparator());
        i = new JMenuItem();
        i.setText(this.fVal.getConfig().get(KEY_SELALL_LABEL));
        i.setToolTipText(this.fVal.getConfig().get(KEY_SELALL_TIP));
        icon = this.fVal.getConfig().get(KEY_SELALL_ICON);
        if (icon != null) {
            i.setIcon(new ImageIcon(icon));
        }
        i.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MenuBar.this.RunMenuSelectAllActionPerformed(evt);
            }
        });
        m.add(i);
        i = new JMenuItem();
        i.setText(this.fVal.getConfig().get(KEY_SEL_LABEL));
        i.setToolTipText(this.fVal.getConfig().get(KEY_SEL_TIP));
        icon = this.fVal.getConfig().get(KEY_SEL_ICON);
        if (icon != null) {
            i.setIcon(new ImageIcon(icon));
        }
        i.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MenuBar.this.RunMenuSelectActionPerformed(evt);
            }
        });
        m.add(i);
        this.fSelectMenu = i;
        i = new JMenuItem();
        i.setText(this.fVal.getConfig().get(KEY_CLEAR_LABEL));
        i.setToolTipText(this.fVal.getConfig().get(KEY_CLEAR_TIP));
        icon = this.fVal.getConfig().get(KEY_CLEAR_ICON);
        if (icon != null) {
            i.setIcon(new ImageIcon(icon));
        }
        i.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MenuBar.this.RunMenuClearActionPerformed(evt);
            }
        });
        m.add(i);
        this.add(m);
    }

    public void RunMenuLoadDictionaryActionPerformed(ActionEvent evt) {
        File f = this.chooseFile(this.fVal.getConfig().get(KEY_DICT_DIR), true, false);
        if (f == null) {
            return;
        }
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            this.fVal.loadDictionary(in);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void RunMenuValidateActionPerformed(ActionEvent evt) {
        ErrorList errs = this.fVal.getErrorList();
        errs.clear();
        if (!this.fVal.getStar().isConnected()) {
            this.fVal.getStar().connect(false);
        }
        this.fVal.validate(false);
        if (this.fErrorPane != null) {
            this.fErrorPane.showErrors();
        }
    }

    private void RunMenuEditActionPerformed(ActionEvent evt) {
        ErrorList errs = this.fVal.getErrorList();
        errs.clear();
        if (!this.fVal.getStar().isConnected()) {
            this.fVal.getStar().connect(false);
        }
        this.fVal.edit(false);
        if (this.fErrorPane != null) {
            this.fErrorPane.showErrors();
        }
    }

    public void RunMenuISFActionPerformed(ActionEvent evt) {
        ErrorList errs = this.fVal.getErrorList();
        errs.clear();
        if (!this.fVal.getStar().isConnected()) {
            this.fVal.getStar().connect(false);
        }
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT DISTINCT SFCAT,ID FROM SFCATS WHERE UNIQ='N' ");
            sql.append("OR (UNIQ='Y' AND SFCAT NOT IN (SELECT DISTINCT CATEGORY ");
            sql.append("FROM ENTRYSFS)) ORDER BY ID");
            Stardb star = this.fVal.getStar();
            Statement query = star.getQueryStatement();
            ResultSet rs = query.executeQuery(sql.toString());
            if (rs.next()) {
                ArrayList<String> sfcats = new ArrayList<String>();
                do {
                    sfcats.add(rs.getString(1));
                } while (rs.next());
                rs.close();
                query.close();
                String sfcat = (String)JOptionPane.showInputDialog(this, "Saveframe categories:", "Select saveframe category", -1, null, sfcats.toArray(), null);
                if (sfcat != null && sfcat.length() > 0) {
                    this.fVal.insertSaveFrame(sfcat);
                }
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
        }
        if (this.fErrorPane != null) {
            this.fErrorPane.showErrors();
        }
    }

    public void RunMenuSelectAllActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.getMenuCount(); ++i) {
            JMenu m = this.getMenu(i);
            for (int j = 0; j < m.getItemCount(); ++j) {
                if (!(m.getItem(j) instanceof JCheckBoxMenuItem)) continue;
                ((JCheckBoxMenuItem)m.getItem(j)).setSelected(true);
            }
        }
        this.fVal.selectAll();
    }

    public void RunMenuSelectActionPerformed(ActionEvent evt) {
        this.fSelectPopup.show(this, this.getWidth() / 2, this.getHeight() / 2);
    }

    public void RunMenuClearActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.getMenuCount(); ++i) {
            JMenu m = this.getMenu(i);
            for (int j = 0; j < m.getItemCount(); ++j) {
                if (!(m.getItem(j) instanceof JCheckBoxMenuItem)) continue;
                ((JCheckBoxMenuItem)m.getItem(j)).setSelected(false);
            }
        }
        this.fVal.deselectAll();
    }
}

