/*
 * Decompiled with CFR 0.152.
 */
package edu.bmrb.sans;

import edu.bmrb.sans.ContentHandler2;
import edu.bmrb.sans.ErrorHandler;
import edu.bmrb.sans.STARLexer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class SansParser2 {
    private static final boolean DEBUG = false;
    public static final String ERR_LEXER = "Lexer error: ";
    public static final String WARN_LEXER = "Lexer warning: ";
    public static final String ERR_TOPTOKEN = "Illegal token: ";
    public static final String ERR_DATATOKEN = "Illegal token in data_ block: ";
    public static final String ERR_SAVETOKEN = "Illegal token in saveframe: ";
    public static final String ERR_SAVEVAL = "Saveframe: value expected, found: ";
    public static final String ERR_SAVENVAL = "Saveframe: value not expected here: ";
    public static final String ERR_EOF = "Premature end of file";
    public static final String ERR_NOSAVE = ": no closing save_";
    public static final String ERR_NOSTOP = ": no closing stop_";
    public static final String ERR_NOTAGS = "Loop with no tags";
    public static final String ERR_NOVALS = "Loop with no values";
    public static final String WARN_LOOPCNT = "Loop count error";
    public static final String ERR_LOOPNVAL = "Loop: tag not expected here: ";
    public static final String ERR_LOOPTOKEN = "Illegal token in loop: ";
    private STARLexer fLex = null;
    private ErrorHandler fEh = null;
    private ContentHandler2 fCh = null;
    private String fBlockName = null;

    public SansParser2(STARLexer lex, ContentHandler2 ch, ErrorHandler eh) {
        this.fLex = lex;
        this.fEh = eh;
        this.fCh = ch;
    }

    private SansParser2(STARLexer lex) {
        this.fLex = lex;
    }

    public ContentHandler2 getContentHandler() {
        return this.fCh;
    }

    public void setContentHandler(ContentHandler2 ch) {
        this.fCh = ch;
    }

    public ErrorHandler getErrorHandler() {
        return this.fEh;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.fEh = eh;
    }

    public STARLexer getScanner() {
        return this.fLex;
    }

    public void setScanner(STARLexer lex) {
        this.fLex = lex;
    }

    public void parse() {
        assert (this.fLex != null);
        assert (this.fCh == null);
        assert (this.fEh == null);
        try {
            STARLexer.Types tok;
            block9: do {
                tok = this.fLex.yylex();
                switch (tok) {
                    case ERROR: {
                        this.fEh.fatalError(this.fLex.getLine(), this.fLex.getColumn(), ERR_LEXER + this.fLex.yytext());
                        return;
                    }
                    case WARNING: {
                        if (!this.fEh.warning(this.fLex.getLine(), this.fLex.getColumn(), WARN_LEXER + this.fLex.yytext())) continue block9;
                        return;
                    }
                    case COMMENT: {
                        if (!this.fCh.comment(this.fLex.getLine(), this.fLex.getText())) continue block9;
                        return;
                    }
                    case DATASTART: {
                        this.fBlockName = this.fLex.getText();
                        if (this.fCh.startData(this.fLex.getLine(), this.fBlockName)) {
                            return;
                        }
                        if (!this.parseDataBlock()) continue block9;
                        return;
                    }
                    case EOF: {
                        this.fCh.endData(this.fLex.getLine(), this.fBlockName);
                        return;
                    }
                    default: {
                        if (!this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_TOPTOKEN + this.fLex.yytext())) continue block9;
                        return;
                    }
                }
            } while (tok != STARLexer.Types.EOF);
        }
        catch (IOException e) {
            this.fEh.fatalError(this.fLex.getLine(), this.fLex.getColumn(), e.getMessage());
            System.err.println(e);
            e.printStackTrace();
        }
    }

    private boolean parseDataBlock() throws IOException {
        STARLexer.Types tok;
        block7: do {
            tok = this.fLex.yylex();
            switch (tok) {
                case ERROR: {
                    this.fEh.fatalError(this.fLex.getLine(), this.fLex.getColumn(), ERR_LEXER + this.fLex.yytext());
                    return true;
                }
                case WARNING: {
                    if (!this.fEh.warning(this.fLex.getLine(), this.fLex.getColumn(), WARN_LEXER + this.fLex.yytext())) continue block7;
                    return true;
                }
                case COMMENT: {
                    if (!this.fCh.comment(this.fLex.getLine(), this.fLex.getText())) continue block7;
                    return true;
                }
                case SAVESTART: {
                    String savename = this.fLex.getText();
                    if (this.fCh.startSaveFrame(this.fLex.getLine(), savename)) {
                        return true;
                    }
                    if (!this.parseSaveFrame(savename)) continue block7;
                    return true;
                }
                case EOF: {
                    this.fCh.endData(this.fLex.getLine(), this.fBlockName);
                    return true;
                }
                default: {
                    if (!this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_DATATOKEN + this.fLex.yytext())) continue block7;
                    return true;
                }
            }
        } while (tok != STARLexer.Types.DATAEND);
        return false;
    }

    private boolean parseSaveFrame(String name) throws IOException {
        STARLexer.Types tok;
        boolean needvalue = false;
        block14: do {
            tok = this.fLex.yylex();
            switch (tok) {
                case ERROR: {
                    this.fEh.fatalError(this.fLex.getLine(), this.fLex.getColumn(), ERR_LEXER + this.fLex.yytext());
                    return true;
                }
                case WARNING: {
                    if (!this.fEh.warning(this.fLex.getLine(), this.fLex.getColumn(), WARN_LEXER + this.fLex.yytext())) continue block14;
                    return true;
                }
                case COMMENT: {
                    if (!this.fCh.comment(this.fLex.getLine(), this.fLex.getText())) continue block14;
                    return true;
                }
                case EOF: {
                    this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), "Premature end of file: no closing save_");
                    this.fCh.endData(this.fLex.getLine(), this.fBlockName);
                    return true;
                }
                case SAVEEND: {
                    if (needvalue && this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_SAVEVAL + this.fLex.getText())) {
                        return true;
                    }
                    return this.fCh.endSaveFrame(this.fLex.getLine(), name);
                }
                case LOOPSTART: {
                    if (needvalue && this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_SAVEVAL + this.fLex.getText())) {
                        return true;
                    }
                    if (this.fCh.startLoop(this.fLex.getLine())) {
                        return true;
                    }
                    if (!this.parseLoop()) continue block14;
                    return true;
                }
                case TAGNAME: {
                    if (needvalue && this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_SAVEVAL + this.fLex.getText())) {
                        return true;
                    }
                    if (this.fCh.tag(this.fLex.getLine(), this.fLex.getText())) {
                        return true;
                    }
                    needvalue = true;
                    break;
                }
                case DVNSEMICOLON: 
                case DVNFRAMECODE: 
                case DVNSINGLE: 
                case DVNDOUBLE: 
                case DVNNON: {
                    if (!needvalue && this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_SAVENVAL + this.fLex.getText())) {
                        return true;
                    }
                    needvalue = false;
                    String val = this.fLex.getText();
                    switch (tok) {
                        case DVNSEMICOLON: {
                            if (val.indexOf(System.getProperty("line.separator")) != 0) break;
                            val = val.substring(System.getProperty("line.separator").length());
                            break;
                        }
                        case DVNFRAMECODE: {
                            val = val.substring(1);
                        }
                    }
                    if (!this.fCh.value(this.fLex.getLine(), val, tok)) continue block14;
                    return true;
                }
                default: {
                    if (!this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_DATATOKEN + this.fLex.yytext())) continue block14;
                    return true;
                }
            }
        } while (tok != STARLexer.Types.EOF);
        return false;
    }

    private boolean parseLoop() throws IOException {
        STARLexer.Types tok;
        int numtags = 0;
        int numvals = 0;
        int lastline = -1;
        int wrongline = -1;
        int wrongcol = -1;
        int loopcol = 0;
        boolean parsingtags = true;
        block13: do {
            tok = this.fLex.yylex();
            switch (tok) {
                case ERROR: {
                    this.fEh.fatalError(this.fLex.getLine(), this.fLex.getColumn(), ERR_LEXER + this.fLex.yytext());
                    return true;
                }
                case WARNING: {
                    if (!this.fEh.warning(this.fLex.getLine(), this.fLex.getColumn(), WARN_LEXER + this.fLex.yytext())) continue block13;
                    return true;
                }
                case COMMENT: {
                    if (!this.fCh.comment(this.fLex.getLine(), this.fLex.getText())) continue block13;
                    return true;
                }
                case EOF: {
                    this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), "Premature end of file: no closing stop_");
                    this.fCh.endData(this.fLex.getLine(), this.fBlockName);
                    return true;
                }
                case STOP: {
                    if (numtags < 1 && this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_NOTAGS)) {
                        return true;
                    }
                    if (numvals < 1 && this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_NOVALS)) {
                        return true;
                    }
                    boolean rc = false;
                    if (numvals % numtags != 0) {
                        if (wrongline < 0) {
                            wrongline = this.fLex.getLine();
                        }
                        rc = this.fEh.warning(wrongline, wrongcol, WARN_LOOPCNT);
                    }
                    rc = rc || this.fCh.endLoop(this.fLex.getLine());
                    return rc;
                }
                case TAGNAME: {
                    if (!parsingtags && this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_LOOPNVAL + this.fLex.yytext())) {
                        return true;
                    }
                    ++numtags;
                    if (!this.fCh.tag(this.fLex.getLine(), this.fLex.getText())) continue block13;
                    return true;
                }
                case DVNSEMICOLON: 
                case DVNFRAMECODE: 
                case DVNSINGLE: 
                case DVNDOUBLE: 
                case DVNNON: {
                    if (parsingtags) {
                        parsingtags = false;
                    }
                    String val = this.fLex.getText();
                    switch (tok) {
                        case DVNSEMICOLON: {
                            if (val.indexOf(System.getProperty("line.separator")) != 0) break;
                            val = val.substring(System.getProperty("line.separator").length());
                            break;
                        }
                        case DVNFRAMECODE: {
                            val = val.substring(1);
                        }
                    }
                    ++numvals;
                    if (++loopcol == numtags) {
                        if (lastline < this.fLex.getLine()) {
                            if (wrongline < 0) {
                                wrongline = this.fLex.getLine();
                                wrongcol = this.fLex.getColumn();
                            }
                            lastline = this.fLex.getLine();
                        }
                        loopcol = 0;
                    }
                    if (!this.fCh.value(this.fLex.getLine(), val, tok)) continue block13;
                    return true;
                }
                default: {
                    if (!this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_LOOPTOKEN + this.fLex.yytext())) continue block13;
                    return true;
                }
            }
        } while (tok != STARLexer.Types.EOF);
        return false;
    }

    private void test_parse() throws IOException {
        STARLexer.Types tok = this.fLex.yylex();
        while (tok != STARLexer.Types.EOF) {
            System.out.printf("%s (%d,%d): %s\n", new Object[]{tok, this.fLex.getLine(), this.fLex.getColumn(), this.fLex.getText()});
            tok = this.fLex.yylex();
        }
        System.out.println("End of data (EOF)");
    }

    public static void main(String[] args) {
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
            STARLexer lex = new STARLexer(r);
            SansParser2 p = new SansParser2(lex);
            p.test_parse();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(1);
        }
    }
}

