/*B-B-Reader, v. 2.2, 10/2003 */

/*
 COPYRIGHT NOTICE

BB-Reader is copyrighted but freely available software. You may use and distribute it free of
charge, but it must not be sold or offered as an inducement to buy other products. Moreover
modified source-code must not be distributed and the source-code must not be redistributed
without the accompanying files (manual).
If you use the software for your research, please include a reference to:
Wimmer R. et al; J.Biomol NMR 9, p.101-104 (1997)

(c) 1996-1999 by R. Wimmer, N. Mueller (University of Linz, Austria), S.B.Petersen (SINTEF BIOTECH, Trondheim, Norway)
(c) 2000-2003 by R.Wimmer, S.B. Petersen (University of Aalborg, Denmark), N.Mueller (University of Linz, Austria)
(c) 2004 by R.Wimmer (University of Aalborg, Denmark)

 WARRANTY DISCLAIMER

The software and accompanying instructions are provided "as is" without warranty of any kind.
The authors do not warrant, guarantee, or make any representations regarding the use, or the
results of the use of the software or accompanying instructions in terms of correctness,
accuracy, reliabilty, currentness or otherwise. The entire risk as to the results and
performance of the software is assumed by you. If the software or instructions are defective,
you, and not the authors, assume the entire cost of all necessary servicing, repair or correction.


*/

#include <stdio.h>

#include <math.h>

#include <string.h>

#include <stdlib.h>



#define MAXATOMNAME 5

#define MAXRESIDUENAME 30

#define MAXNAME 40

#define INTRASEQ 8  /*1.91*/

#define SEQUENTIAL 5		/*1.91*/

#define EXCHANGEABLE 4

#define GEMINAL 3

#define LONGRANGE 2

#define SURE 2

#define MAYBE 1

#define TRUE 1

#define FALSE 0

#define OK 1

#define NEG 0

#define MAXLINE 255

#define MAXFILENAME 40

#define MAXTYPE 21	/*number of possible different Amino Acids*/

#define MAXHITS 21	/*number of hits, that can be stored in the hitlist, plus 1*/

#define MAXATOM 36	/*number of possible atoms per residue*/

#define MAXATOMTYPE 70	/*number of possible different atom types*/

#define MAXRES 500

#define MAXNUCLEI 3

#define SINGLE_RESIDUE 3

#define NMR_1D 1

#define NMR_2D 2

#define xALA 1
#define xCYS 2
#define xASP 3
#define xGLU 4
#define xPHE 5
#define xGLY 6
#define xHIS 7
#define xILE 8
#define xLYS 9
#define xLEU 10
#define xMET 11
#define xASN 12
#define xPRO 13
#define xGLN 14
#define xARG 15
#define xSER 16
#define xTHR 17
#define xVAL 18
#define xTRP 19
#define xTYR 20


#define xH 1
#define xHA 2
#define x1HA 3
#define x2HA 4
#define xHB 5
#define x1HB 6
#define x2HB 7
#define x3HB 33
#define xHG 8
#define x1HG 34	 /*corresponds both to 1HG and HG1*/
#define x2HG 35
#define x1HG1 9
#define x1HG2 10
#define x2HG1 11
#define x2HG2 12
#define x3HG1 36
#define x3HG2 37
#define xHD 22
#define xHD1 13  /*corresponds both to 1HD and HD1*/
#define xHD2 14	 /*corresponds both to 2HD and HD2*/
#define x1HD2 24
#define x2HD2 25
#define x3HD2 38
#define x1HD1 39
#define x2HD1 40
#define x3HD1 41
#define xHE 21
#define xHE1 15	/*corresponds both to 1HE and HE1*/
#define xHE2 16	/*corresponds both to 2HE and HE2*/
#define xHE3 23 /*corresponds both to 3HE and HE3*/
#define x1HE2 26
#define x2HE2 27
#define xHH 42
#define xHH2 17
#define x1HH1 28
#define x2HH1 29
#define x1HH2 30
#define x2HH2 31
#define xHZ 18
#define xHZ2 19
#define xHZ3 20
#define x1HZ 43
#define x2HZ 44
#define xC 68
#define xCA 32
#define xCB 45
#define xCG 46
#define xCG1 48
#define xCG2 49
#define xCD 50
#define xCD1 51
#define xCD2 52
#define xCE 47
#define xCE1 53
#define xCE2 54
#define xCE3 59
#define xCZ 55
#define xCZ2 57
#define xCZ3 58
#define xCH2 56
#define xN 69
#define xND1 61
#define xND2 67
#define xNE 63
#define xNE1 62
#define xNE2 60
#define xNZ 66
#define xNH1 64
#define xNH2 65




int count_residues=0;

FILE *biomag_out, *debug_out, *multi_file;

struct aminoacid_atomdata

{
	short H_tot,C,N,ex_H;
};

struct protein_nmr_data

{

	char restype[MAXRESIDUENAME];

	char atomtype[MAXATOM][MAXATOMNAME];

	char biomag_atomtype[MAXATOM][MAXATOMNAME];

	int  atomnumber[MAXATOM];

	int  count_atoms;

	float xcor[MAXATOM];

	float ycor[MAXATOM];

	float zcor[MAXATOM];

	float chem_shift[MAXATOM];

	int is_biomag[MAXATOM];

	int is_PDB[MAXATOM];	/*RW*/

	char nucleus[MAXATOM];	/*RW*/

	short is_duplicate[MAXATOM];	/*RW*/
	
	short its_ResConst;

	short its_AtomConst[MAXATOM];

};

struct hit

{
int resid1,resid2,resid3,atom1,atom2,atom3,outflag,outflag_3D;
double dist,nearest_dist,score,dist_3D,nearest_dist_3D;
};

int forbidden_matrix[MAXATOMTYPE][MAXRES][MAXATOMTYPE];		/*RW*/

short forbidden_matrix_3D[MAXATOMTYPE];

int cosy_crosspeak[MAXTYPE][MAXATOMTYPE][MAXATOMTYPE];	/*RW*/
	
int identity[MAXTYPE][MAXATOMTYPE][MAXATOMTYPE];	/*RW*/

struct protein_nmr_data protein[MAXRES];

struct hit hitlist[MAXHITS];

struct hit hitlist2[MAXHITS];
	
struct aminoacid_atomdata statistic[MAXTYPE];

/*____________________________________________________________________*/


void initialize_protein_matrix()

{
int ri;

for (ri=1;ri<=MAXRES;ri++)
	{
	strcpy(protein[ri].restype,"N/A");
	}
}

/*____________________________________________________________________*/

void initialize_statistic()

{
int ri;

for (ri=1;ri<MAXTYPE;ri++)
	{
	statistic[ri].N=1;
	statistic[ri].ex_H=1;
	}

statistic[xALA].H_tot=5;
statistic[xALA].C=3;
statistic[xCYS].H_tot=5;
statistic[xCYS].C=3;
statistic[xCYS].ex_H=2;
statistic[xASP].H_tot=5;
statistic[xASP].C=4;
statistic[xASP].ex_H=2;
statistic[xGLU].H_tot=7;
statistic[xGLU].C=5;
statistic[xGLU].ex_H=2;
statistic[xPHE].H_tot=9;
statistic[xPHE].C=9;
statistic[xGLY].H_tot=3;
statistic[xGLY].C=2;
statistic[xHIS].H_tot=7;
statistic[xHIS].C=6;
statistic[xHIS].N=3;
statistic[xHIS].ex_H=2;
statistic[xILE].H_tot=11;
statistic[xILE].C=6;
statistic[xLYS].H_tot=12;
statistic[xLYS].C=6;
statistic[xLYS].N=2;
statistic[xLYS].ex_H=3;
statistic[xLEU].H_tot=11;
statistic[xLEU].C=6;
statistic[xMET].H_tot=9;
statistic[xMET].C=5;
statistic[xASN].H_tot=6;
statistic[xASN].C=4;
statistic[xASN].N=2;
statistic[xASN].ex_H=3;
statistic[xPRO].H_tot=7;
statistic[xPRO].C=5;
statistic[xPRO].ex_H=0;
statistic[xGLN].H_tot=8;
statistic[xGLN].C=5;
statistic[xGLN].N=2;
statistic[xGLN].ex_H=3;
statistic[xARG].H_tot=12;
statistic[xARG].C=6;
statistic[xARG].N=4;
statistic[xARG].ex_H=5;
statistic[xSER].H_tot=statistic[xCYS].H_tot;
statistic[xSER].C=statistic[xCYS].C;
statistic[xSER].ex_H=statistic[xCYS].ex_H;
statistic[xTHR].H_tot=7;
statistic[xTHR].C=4;
statistic[xTHR].ex_H=2;
statistic[xVAL].H_tot=9;
statistic[xVAL].C=5;
statistic[xTRP].H_tot=10;
statistic[xTRP].C=11;
statistic[xTRP].N=2;
statistic[xTRP].ex_H=2;
statistic[xTYR].H_tot=9;
statistic[xTYR].C=9;
statistic[xTYR].ex_H=2;
}


/*____________________________________________________________________*/

void initialize_hitlist()

{
int ri;

for (ri=0;ri<MAXHITS;ri++)
  {
 	hitlist[ri].resid1=-1;
	hitlist[ri].resid2=-1;
	hitlist[ri].resid3=-1;
	hitlist[ri].atom1=-1;
	hitlist[ri].atom2=-1;
	hitlist[ri].atom3=-1;
	hitlist[ri].dist=-1;
	hitlist[ri].nearest_dist=-1;
	hitlist[ri].dist_3D=-1;
	hitlist[ri].nearest_dist_3D=-1;
	hitlist[ri].score=-9999;
	hitlist[ri].outflag=0;
	hitlist[ri].outflag_3D=0;
  }
}


/*____________________________________________________________________*/

void initialize_COSY_Matrix()
  {
  int ri,rii,riii;
  for(ri=1;ri<MAXTYPE;ri++)
     { 
      for (rii=1;rii<MAXATOMTYPE;rii++)
         {
          for (riii=1;riii<MAXATOMTYPE;riii++)
            {
             cosy_crosspeak[ri][rii][riii]=FALSE;
            }
         }
      cosy_crosspeak[ri][xCA][xC]=TRUE;
      cosy_crosspeak[ri][xCA][xN]=INTRASEQ;  /*1.91*/
      cosy_crosspeak[ri][xC][xN]=SEQUENTIAL;		/*1.91*/
      
      if (ri != xGLY)
	{
         cosy_crosspeak[ri][xCA][xCB]=TRUE;
 	 cosy_crosspeak[ri][xHA][xH]=EXCHANGEABLE;
         cosy_crosspeak[ri][xCA][xHA]=TRUE;	 
	}
      else
	{
	cosy_crosspeak[ri][x1HA][xH]=EXCHANGEABLE;
	cosy_crosspeak[ri][x2HA][xH]=EXCHANGEABLE;
	cosy_crosspeak[ri][x1HA][xCA]=TRUE;
	cosy_crosspeak[ri][x2HA][xCA]=TRUE;
	}

      if ((ri != xALA) && (ri != xSER) && (ri!= xCYS)&& (ri != xILE) && (ri!= xVAL))
      	cosy_crosspeak[ri][xCG][xCB]=TRUE;

      cosy_crosspeak[ri][xH][xN]=EXCHANGEABLE;

      if ((ri !=xALA)&&(ri!=xVAL)&&(ri!=xILE)&&(ri!=xTHR)&&(ri!=xGLY))
	{
	 cosy_crosspeak[ri][xCB][x1HB]=TRUE;
	 cosy_crosspeak[ri][xCB][x2HB]=TRUE;
	}
       else if ((ri!=xALA)&&(ri!=xGLY))
	 cosy_crosspeak[ri][xCB][xHB]=TRUE;
     }
  
  cosy_crosspeak[xALA][x1HB][xHA]=TRUE;
  cosy_crosspeak[xALA][x2HB][xHA]=TRUE;
  cosy_crosspeak[xALA][x3HB][xHA]=TRUE;
  cosy_crosspeak[xALA][x1HB][xCB]=TRUE;
  cosy_crosspeak[xALA][x2HB][xCB]=TRUE;
  cosy_crosspeak[xALA][x3HB][xCB]=TRUE;
 

  cosy_crosspeak[xCYS][x1HB][xHA]=TRUE;
  cosy_crosspeak[xCYS][x2HB][xHA]=TRUE;
  cosy_crosspeak[xCYS][x1HB][x2HB]=GEMINAL;
  cosy_crosspeak[xCYS][xHG][x1HB]=EXCHANGEABLE;
  cosy_crosspeak[xCYS][xHG][x2HB]=EXCHANGEABLE;

  cosy_crosspeak[xASP][x1HB][xHA]=TRUE;
  cosy_crosspeak[xASP][x2HB][xHA]=TRUE;
  cosy_crosspeak[xASP][x1HB][x2HB]=GEMINAL;

  cosy_crosspeak[xGLU][x1HB][xHA]=TRUE;
  cosy_crosspeak[xGLU][x2HB][xHA]=TRUE;
  cosy_crosspeak[xGLU][x1HB][x2HB]=GEMINAL;
  cosy_crosspeak[xGLU][x1HB][x1HG]=TRUE;
  cosy_crosspeak[xGLU][x1HB][x2HG]=TRUE;
  cosy_crosspeak[xGLU][x2HB][x1HG]=TRUE;
  cosy_crosspeak[xGLU][x2HB][x2HG]=TRUE;
  cosy_crosspeak[xGLU][x1HG][x2HG]=GEMINAL;
  cosy_crosspeak[xGLU][xCG][xCD]=TRUE;
  cosy_crosspeak[xGLU][xCG][x1HG]=TRUE;
  cosy_crosspeak[xGLU][xCG][x2HG]=TRUE;

  cosy_crosspeak[xPHE][x1HB][xHA]=TRUE;
  cosy_crosspeak[xPHE][x2HB][xHA]=TRUE;
  cosy_crosspeak[xPHE][x1HB][x2HB]=GEMINAL;
  cosy_crosspeak[xPHE][xHD1][xHE1]=TRUE;
  cosy_crosspeak[xPHE][xHD2][xHE2]=TRUE;
  cosy_crosspeak[xPHE][xHD1][xHD2]=LONGRANGE;
  cosy_crosspeak[xPHE][xHE2][xHE1]=LONGRANGE;
  cosy_crosspeak[xPHE][xHZ][xHE1]=TRUE;
  cosy_crosspeak[xPHE][xHZ][xHE2]=TRUE;
  cosy_crosspeak[xPHE][xHZ][xHD2]=LONGRANGE;
  cosy_crosspeak[xPHE][xHD1][xHZ]=LONGRANGE;
  cosy_crosspeak[xPHE][xCG][xCD1]=TRUE;
  cosy_crosspeak[xPHE][xCG][xCD2]=TRUE;
  cosy_crosspeak[xPHE][xCE1][xCD1]=TRUE;
  cosy_crosspeak[xPHE][xCE2][xCD2]=TRUE;
  cosy_crosspeak[xPHE][xCE1][xCZ]=TRUE;
  cosy_crosspeak[xPHE][xCE2][xCZ]=TRUE;
  cosy_crosspeak[xPHE][xHD1][xCD1]=TRUE;
  cosy_crosspeak[xPHE][xHD2][xCD2]=TRUE;
  cosy_crosspeak[xPHE][xCE1][xHE1]=TRUE;
  cosy_crosspeak[xPHE][xCE2][xHE2]=TRUE;
  cosy_crosspeak[xPHE][xHZ][xCZ]=TRUE;

  cosy_crosspeak[xGLY][x1HA][x2HA]=GEMINAL;

  cosy_crosspeak[xHIS][x1HB][x2HB]=GEMINAL;
  cosy_crosspeak[xHIS][x1HB][xHA]=TRUE;
  cosy_crosspeak[xHIS][xHA][x2HB]=TRUE;
  cosy_crosspeak[xHIS][xHD2][xHE1]=LONGRANGE;
  cosy_crosspeak[xHIS][xHD1][xHE1]=EXCHANGEABLE;
  cosy_crosspeak[xHIS][xCG][xND1]=TRUE;
  cosy_crosspeak[xHIS][xCG][xCD2]=TRUE;
  cosy_crosspeak[xHIS][xCE1][xND1]=TRUE;
  cosy_crosspeak[xHIS][xCD2][xNE2]=TRUE;
  cosy_crosspeak[xHIS][xCE1][xNE2]=TRUE;
  cosy_crosspeak[xHIS][xCD2][xHD2]=TRUE;
  cosy_crosspeak[xHIS][xCE1][xHE1]=TRUE;


  cosy_crosspeak[xILE][xHB][xHA]=TRUE;
  cosy_crosspeak[xILE][xHB][x1HG2]=TRUE;
  cosy_crosspeak[xILE][xHB][x2HG2]=TRUE;
  cosy_crosspeak[xILE][xHB][x3HG2]=TRUE;
  cosy_crosspeak[xILE][xHB][x2HG1]=TRUE;
  cosy_crosspeak[xILE][xHB][x1HG1]=TRUE;
  cosy_crosspeak[xILE][x2HG1][x1HG1]=GEMINAL;
  cosy_crosspeak[xILE][x1HD1][x2HG1]=TRUE;
  cosy_crosspeak[xILE][x1HD1][x1HG1]=TRUE;
  cosy_crosspeak[xILE][x2HD1][x2HG1]=TRUE;
  cosy_crosspeak[xILE][x2HD1][x1HG1]=TRUE;
  cosy_crosspeak[xILE][x3HD1][x2HG1]=TRUE;
  cosy_crosspeak[xILE][x3HD1][x1HG1]=TRUE;
  cosy_crosspeak[xILE][xCB][xCG1]=TRUE;
  cosy_crosspeak[xILE][xCB][xCG2]=TRUE;
  cosy_crosspeak[xILE][xCD1][xCG1]=TRUE;
  cosy_crosspeak[xILE][xCG1][x1HG1]=TRUE;
  cosy_crosspeak[xILE][xCG1][x2HG1]=TRUE;
  cosy_crosspeak[xILE][xCG2][x1HG2]=TRUE;
  cosy_crosspeak[xILE][xCG2][x2HG2]=TRUE;
  cosy_crosspeak[xILE][xCG2][x3HG2]=TRUE;
  cosy_crosspeak[xILE][xCD1][x1HD1]=TRUE;
  cosy_crosspeak[xILE][xCD1][x2HD1]=TRUE;
  cosy_crosspeak[xILE][xCD1][x3HD1]=TRUE;


  cosy_crosspeak[xLYS][xHA][x1HB]=TRUE;
  cosy_crosspeak[xLYS][xHA][x2HB]=TRUE;
  cosy_crosspeak[xLYS][x2HB][x1HB]=GEMINAL;
  cosy_crosspeak[xLYS][xHD1][xHD2]=GEMINAL;
  cosy_crosspeak[xLYS][xHD1][x1HG]=TRUE;
  cosy_crosspeak[xLYS][xHD1][x2HG]=TRUE;
  cosy_crosspeak[xLYS][xHD2][x1HG]=TRUE;
  cosy_crosspeak[xLYS][xHD2][x2HG]=TRUE;
  cosy_crosspeak[xLYS][x1HB][x1HG]=TRUE;
  cosy_crosspeak[xLYS][x1HB][x2HG]=TRUE;
  cosy_crosspeak[xLYS][x2HB][x1HG]=TRUE;
  cosy_crosspeak[xLYS][x2HB][x2HG]=TRUE;
  cosy_crosspeak[xLYS][xHE1][xHE2]=GEMINAL;
  cosy_crosspeak[xLYS][x1HG1][x2HG]=GEMINAL;
  cosy_crosspeak[xLYS][xHD1][xHE1]=TRUE;
  cosy_crosspeak[xLYS][xHD1][xHE2]=TRUE;
  cosy_crosspeak[xLYS][xHD2][xHE1]=TRUE;
  cosy_crosspeak[xLYS][xHD2][xHE2]=TRUE;
  cosy_crosspeak[xLYS][xHZ][xHE1]=EXCHANGEABLE;
  cosy_crosspeak[xLYS][xHZ][xHE2]=EXCHANGEABLE;
  cosy_crosspeak[xLYS][xCG][xCD]=TRUE;
  cosy_crosspeak[xLYS][xCE][xCD]=TRUE;
  cosy_crosspeak[xLYS][xCE][xNZ]=TRUE;
  cosy_crosspeak[xLYS][xCG][x1HG]=TRUE;
  cosy_crosspeak[xLYS][xCG][x2HG]=TRUE;
  cosy_crosspeak[xLYS][xCD][xHD1]=TRUE;
  cosy_crosspeak[xLYS][xCD][xHD2]=TRUE;
  cosy_crosspeak[xLYS][xCE][xHE1]=TRUE;
  cosy_crosspeak[xLYS][xCE][xHE2]=TRUE;
  cosy_crosspeak[xLYS][x1HZ][xNZ]=EXCHANGEABLE;
  cosy_crosspeak[xLYS][x2HZ][xNZ]=EXCHANGEABLE;

  cosy_crosspeak[xLEU][xHA][x1HB]=TRUE;
  cosy_crosspeak[xLEU][xHA][x2HB]=TRUE;
  cosy_crosspeak[xLEU][x1HB][x2HB]=GEMINAL;
  cosy_crosspeak[xLEU][xHG][x1HB]=TRUE;
  cosy_crosspeak[xLEU][xHG][x2HB]=TRUE;
  cosy_crosspeak[xLEU][xHG][x1HD1]=TRUE;
  cosy_crosspeak[xLEU][xHG][x1HD2]=TRUE;
  cosy_crosspeak[xLEU][xHG][x2HD1]=TRUE;
  cosy_crosspeak[xLEU][xHG][x2HD2]=TRUE;
  cosy_crosspeak[xLEU][xHG][x3HD1]=TRUE;
  cosy_crosspeak[xLEU][xHG][x3HD2]=TRUE;
  cosy_crosspeak[xLEU][xCG][xCD1]=TRUE;
  cosy_crosspeak[xLEU][xCG][xCD2]=TRUE;
  cosy_crosspeak[xLEU][xCG][xHG]=TRUE;
  cosy_crosspeak[xLEU][x1HD2][xCD2]=TRUE;
  cosy_crosspeak[xLEU][x2HD2][xCD2]=TRUE;
  cosy_crosspeak[xLEU][x3HD2][xCD2]=TRUE;
  cosy_crosspeak[xLEU][x1HD1][xCD1]=TRUE;
  cosy_crosspeak[xLEU][x2HD1][xCD1]=TRUE;
  cosy_crosspeak[xLEU][x3HD1][xCD1]=TRUE;

  cosy_crosspeak[xMET][xHA][x1HB]=TRUE;
  cosy_crosspeak[xMET][xHA][x2HB]=TRUE;
  cosy_crosspeak[xMET][x1HB][x2HB]=GEMINAL;
  cosy_crosspeak[xMET][x1HG][x1HB]=TRUE;
  cosy_crosspeak[xMET][x1HG][x2HB]=TRUE;
  cosy_crosspeak[xMET][x2HG][x1HB]=TRUE;
  cosy_crosspeak[xMET][x2HG][x2HB]=TRUE;
  cosy_crosspeak[xMET][x1HG][x2HG]=GEMINAL;
  cosy_crosspeak[xMET][x1HG][xCG]=TRUE;
  cosy_crosspeak[xMET][x2HG][xCG]=TRUE;
  cosy_crosspeak[xMET][xCE][xHE1]=TRUE;
  cosy_crosspeak[xMET][xCE][xHE2]=TRUE;
  cosy_crosspeak[xMET][xCE][xHE3]=TRUE;

  cosy_crosspeak[xASN][x1HB][xHA]=TRUE;
  cosy_crosspeak[xASN][x2HB][xHA]=TRUE;
  cosy_crosspeak[xASN][x1HB][x2HB]=GEMINAL;
  cosy_crosspeak[xASN][xCG][xND2]=TRUE;
  cosy_crosspeak[xASN][x1HD2][xND2]=EXCHANGEABLE;
  cosy_crosspeak[xASN][x2HD2][xND2]=EXCHANGEABLE;

  cosy_crosspeak[xPRO][xHA][x1HB]=TRUE;
  cosy_crosspeak[xPRO][xHA][x2HB]=TRUE;
  cosy_crosspeak[xPRO][x1HB][x2HB]=GEMINAL;
  cosy_crosspeak[xPRO][x1HG][x1HB]=TRUE;
  cosy_crosspeak[xPRO][x1HG][x2HB]=TRUE;
  cosy_crosspeak[xPRO][x2HG][x1HB]=TRUE;
  cosy_crosspeak[xPRO][x2HG][x2HB]=TRUE;
  cosy_crosspeak[xPRO][x1HG][x2HG]=GEMINAL;
  cosy_crosspeak[xPRO][x1HG][xHD1]=TRUE;
  cosy_crosspeak[xPRO][x1HG][xHD2]=TRUE;
  cosy_crosspeak[xPRO][x2HG][xHD1]=TRUE;
  cosy_crosspeak[xPRO][x2HG][xHD2]=TRUE;
  cosy_crosspeak[xPRO][xHD1][xHD2]=GEMINAL;
  cosy_crosspeak[xPRO][xCG][xCD]=TRUE;
  cosy_crosspeak[xPRO][x1HG][xCG]=TRUE;
  cosy_crosspeak[xPRO][x2HG][xCG]=TRUE;
  cosy_crosspeak[xPRO][xHD1][xCD]=TRUE;
  cosy_crosspeak[xPRO][xHD2][xCD]=TRUE;

  cosy_crosspeak[xGLN][x1HB][xHA]=TRUE;
  cosy_crosspeak[xGLN][x2HB][xHA]=TRUE;
  cosy_crosspeak[xGLN][x1HB][x2HB]=GEMINAL;
  cosy_crosspeak[xGLN][x1HB][x1HG]=TRUE;
  cosy_crosspeak[xGLN][x1HB][x2HG]=TRUE;
  cosy_crosspeak[xGLN][x2HB][x1HG]=TRUE;
  cosy_crosspeak[xGLN][x2HB][x2HG]=TRUE;
  cosy_crosspeak[xGLN][x1HG][x2HG]=GEMINAL;
  cosy_crosspeak[xGLN][xCG][xCD]=TRUE;
  cosy_crosspeak[xGLN][xNE2][xCD]=TRUE;
  cosy_crosspeak[xGLN][x1HG][xCG]=TRUE;
  cosy_crosspeak[xGLN][x2HG][xCG]=TRUE;
  cosy_crosspeak[xGLN][xNE2][x1HE2]=EXCHANGEABLE;
  cosy_crosspeak[xGLN][xNE2][x2HE2]=EXCHANGEABLE;


  for (rii=1;rii<MAXATOMTYPE;rii++)
         {for (riii=1;riii<MAXATOMTYPE;riii++)
            {cosy_crosspeak[xARG][rii][riii]=cosy_crosspeak[xPRO][rii][riii];
            }
         }
  cosy_crosspeak[xARG][xCD][xNE]=TRUE;
  cosy_crosspeak[xARG][xCZ][xNE]=TRUE;
  cosy_crosspeak[xARG][xCZ][xNH1]=TRUE;
  cosy_crosspeak[xARG][xCZ][xNH2]=TRUE;
  cosy_crosspeak[xARG][xHE][xNE]=EXCHANGEABLE;
  cosy_crosspeak[xARG][x1HH1][xNH1]=TRUE;
  cosy_crosspeak[xARG][x1HH2][xNH2]=TRUE;
  cosy_crosspeak[xARG][x2HH1][xNH1]=TRUE;
  cosy_crosspeak[xARG][x2HH2][xNH2]=TRUE;


   for (rii=1;rii<MAXATOMTYPE;rii++)
         {for (riii=1;riii<MAXATOMTYPE;riii++)
            {cosy_crosspeak[xSER][rii][riii]=cosy_crosspeak[xCYS][rii][riii];
            }
         }
 
  cosy_crosspeak[xTHR][xHA][xHB]=TRUE;
  cosy_crosspeak[xTHR][x1HG2][xHB]=TRUE;
  cosy_crosspeak[xTHR][x2HG2][xHB]=TRUE;
  cosy_crosspeak[xTHR][x3HG2][xHB]=TRUE;
  cosy_crosspeak[xTHR][x1HG][xHB]=EXCHANGEABLE;
  cosy_crosspeak[xTHR][xCG2][xCB]=TRUE;
  cosy_crosspeak[xTHR][x1HG2][xCG2]=TRUE;
  cosy_crosspeak[xTHR][x2HG2][xCG2]=TRUE;
  cosy_crosspeak[xTHR][x3HG2][xCG2]=TRUE;


  cosy_crosspeak[xVAL][xHA][xHB]=TRUE;
  cosy_crosspeak[xVAL][x1HG2][xHB]=TRUE;
  cosy_crosspeak[xVAL][x1HG1][xHB]=TRUE;
  cosy_crosspeak[xVAL][x2HG2][xHB]=TRUE;
  cosy_crosspeak[xVAL][x2HG1][xHB]=TRUE;
  cosy_crosspeak[xVAL][x3HG2][xHB]=TRUE;
  cosy_crosspeak[xVAL][x3HG1][xHB]=TRUE;
  cosy_crosspeak[xVAL][xCG2][xCB]=TRUE;
  cosy_crosspeak[xVAL][xCG1][xCB]=TRUE;
  cosy_crosspeak[xVAL][x1HG2][xCG2]=TRUE;
  cosy_crosspeak[xVAL][x2HG2][xCG2]=TRUE;
  cosy_crosspeak[xVAL][x3HG2][xCG2]=TRUE;
  cosy_crosspeak[xVAL][x1HG1][xCG1]=TRUE;
  cosy_crosspeak[xVAL][x2HG1][xCG1]=TRUE;
  cosy_crosspeak[xVAL][x3HG1][xCG1]=TRUE;

  cosy_crosspeak[xTRP][x1HB][xHA]=TRUE;
  cosy_crosspeak[xTRP][x2HB][xHA]=TRUE;
  cosy_crosspeak[xTRP][x1HB][x2HB]=GEMINAL;
  cosy_crosspeak[xTRP][xHE3][xHZ3]=TRUE;
  cosy_crosspeak[xTRP][xHH2][xHZ3]=TRUE;
  cosy_crosspeak[xTRP][xHH2][xHZ2]=TRUE;
  cosy_crosspeak[xTRP][xHZ3][xHZ2]=LONGRANGE;
  cosy_crosspeak[xTRP][xHE3][xHH2]=LONGRANGE;
  cosy_crosspeak[xTRP][xHD1][xHE1]=EXCHANGEABLE;
  cosy_crosspeak[xTRP][xCG][xCD1]=TRUE;
  cosy_crosspeak[xTRP][xCG][xCD2]=TRUE;
  cosy_crosspeak[xTRP][xNE1][xCD1]=TRUE;
  cosy_crosspeak[xTRP][xNE1][xCE2]=TRUE;
  cosy_crosspeak[xTRP][xCD2][xCE2]=TRUE;
  cosy_crosspeak[xTRP][xCZ2][xCE2]=TRUE;
  cosy_crosspeak[xTRP][xCZ2][xCH2]=TRUE;
  cosy_crosspeak[xTRP][xCZ3][xCH2]=TRUE;
  cosy_crosspeak[xTRP][xCZ3][xCE3]=TRUE;
  cosy_crosspeak[xTRP][xCD2][xCE3]=TRUE;
  cosy_crosspeak[xTRP][xHD1][xCD1]=TRUE;
  cosy_crosspeak[xTRP][xCZ2][xHZ2]=TRUE;
  cosy_crosspeak[xTRP][xHH2][xCH2]=TRUE;
  cosy_crosspeak[xTRP][xCZ3][xHZ3]=TRUE;
  cosy_crosspeak[xTRP][xHE3][xCE3]=TRUE;
  cosy_crosspeak[xTRP][xNE1][xHE1]=EXCHANGEABLE;

  cosy_crosspeak[xTYR][x1HB][xHA]=TRUE;
  cosy_crosspeak[xTYR][x2HB][xHA]=TRUE;
  cosy_crosspeak[xTYR][x1HB][x2HB]=GEMINAL;
  cosy_crosspeak[xTYR][xHD1][xHE1]=TRUE;
  cosy_crosspeak[xTYR][xHD2][xHE2]=TRUE;
  cosy_crosspeak[xTYR][xHD1][xHD2]=LONGRANGE;
  cosy_crosspeak[xTYR][xHE2][xHE1]=LONGRANGE;
  cosy_crosspeak[xTYR][xCG][xCD1]=TRUE;
  cosy_crosspeak[xTYR][xCG][xCD2]=TRUE;
  cosy_crosspeak[xTYR][xCE1][xCD1]=TRUE;
  cosy_crosspeak[xTYR][xCE2][xCD2]=TRUE;
  cosy_crosspeak[xTYR][xCE1][xCZ]=TRUE;
  cosy_crosspeak[xTYR][xCE2][xCZ]=TRUE;
  cosy_crosspeak[xTYR][xHD1][xCD1]=TRUE;
  cosy_crosspeak[xTYR][xHD2][xCD2]=TRUE;
  cosy_crosspeak[xTYR][xCE1][xHE1]=TRUE;
  cosy_crosspeak[xTYR][xCE2][xHE2]=TRUE;

/*make table symmetric: */  

  for(ri=1;ri<MAXTYPE;ri++)
     { 
      for (rii=1;rii<MAXATOMTYPE;rii++)
         {
          for (riii=1;riii<MAXATOMTYPE;riii++)
            {
             cosy_crosspeak[ri][rii][riii]=(cosy_crosspeak[ri][riii][rii] | cosy_crosspeak[ri][rii][riii]);
            }
         }
     }
}

/*____________________________________________________________________*/

void initialize_identity_Matrix()
  {
  int ri,rii,riii;
  for(ri=1;ri<MAXTYPE;ri++)
     { 
      for (rii=0;rii<MAXATOMTYPE;rii++)
         {
          for (riii=0;riii<MAXATOMTYPE;riii++)
            {
             if (rii==riii)
		identity[ri][rii][riii]=SURE; /*same atomtypes*/
	     else
		identity[ri][rii][riii]=FALSE;

            }
         }
     }
  identity[xGLY][x1HA][x2HA]=MAYBE;   /*maybe means that identity is only given, when protons 
					have the same chemical shift (diastereotopic)*/
  identity[xALA][x1HB][x2HB]=SURE;    /*sure means that those protons are always identical (free rotation of groups)*/
  identity[xALA][x1HB][x3HB]=SURE;
  identity[xALA][x3HB][x2HB]=SURE;

  identity[xSER][x1HB][x2HB]=MAYBE;
  identity[xCYS][x1HB][x2HB]=MAYBE;

  identity[xVAL][x1HG1][x2HG1]=SURE;
  identity[xVAL][x1HG1][x3HG1]=SURE;
  identity[xVAL][x3HG1][x2HG1]=SURE;
  identity[xVAL][x1HG2][x2HG2]=SURE;
  identity[xVAL][x1HG2][x3HG2]=SURE;
  identity[xVAL][x3HG2][x2HG2]=SURE;
  identity[xVAL][x1HG1][x1HG2]=MAYBE;
  identity[xVAL][x1HG1][x2HG2]=MAYBE;
  identity[xVAL][x1HG1][x3HG2]=MAYBE;
  identity[xVAL][x2HG1][x1HG2]=MAYBE;
  identity[xVAL][x2HG1][x2HG2]=MAYBE;
  identity[xVAL][x2HG1][x3HG2]=MAYBE;
  identity[xVAL][x3HG1][x1HG2]=MAYBE;
  identity[xVAL][x3HG1][x2HG2]=MAYBE;
  identity[xVAL][x3HG1][x3HG2]=MAYBE;
  identity[xVAL][xCG1][xCG2]=MAYBE;


  identity[xLEU][x1HB][x2HB]=MAYBE;
  identity[xLEU][x1HD1][x2HD1]=SURE;
  identity[xLEU][x1HD1][x3HD1]=SURE;
  identity[xLEU][x3HD1][x2HD1]=SURE;
  identity[xLEU][x1HD2][x2HD2]=SURE;
  identity[xLEU][x1HD2][x3HD2]=SURE;
  identity[xLEU][x3HD2][x2HD2]=SURE;
  identity[xLEU][x1HD1][x1HD2]=MAYBE;
  identity[xLEU][x1HD1][x2HD2]=MAYBE;
  identity[xLEU][x1HD1][x3HD2]=MAYBE;
  identity[xLEU][x2HD1][x1HD2]=MAYBE;
  identity[xLEU][x2HD1][x2HD2]=MAYBE;
  identity[xLEU][x2HD1][x3HD2]=MAYBE;
  identity[xLEU][x3HD1][x1HD2]=MAYBE;
  identity[xLEU][x3HD1][x2HD2]=MAYBE;
  identity[xLEU][x3HD1][x3HD2]=MAYBE;
  identity[xLEU][xCD1][xCD2]=MAYBE;

 
  identity[xILE][x1HG1][x2HG1]=MAYBE;
  identity[xILE][x1HG2][x2HG2]=SURE;
  identity[xILE][x1HG2][x3HG2]=SURE;
  identity[xILE][x3HG2][x2HG2]=SURE;
  identity[xILE][x1HD1][x2HD1]=SURE;
  identity[xILE][x1HD1][x3HD1]=SURE;
  identity[xILE][x3HD1][x2HD1]=SURE;

  identity[xMET][x1HB][x2HB]=MAYBE;
  identity[xMET][x1HG][x2HG]=MAYBE;
  identity[xMET][xHE1][xHE2]=SURE;
  identity[xMET][xHE1][xHE3]=SURE;
  identity[xMET][xHE3][xHE2]=SURE;

  identity[xPRO][x1HB][x2HB]=MAYBE;
  identity[xPRO][x1HG][x2HG]=MAYBE;
  identity[xPRO][xHD1][xHD2]=MAYBE;

  identity[xASP][x1HB][x2HB]=MAYBE;
  identity[xASN][x1HB][x2HB]=MAYBE;
  identity[xGLU][x1HB][x2HB]=MAYBE;
  identity[xGLU][x1HG][x2HG]=MAYBE;
  identity[xGLN][x1HB][x2HB]=MAYBE;
  identity[xGLN][x1HG][x2HG]=MAYBE;

  identity[xTHR][x1HG2][x2HG2]=SURE;
  identity[xTHR][x1HG2][x3HG2]=SURE;
  identity[xTHR][x3HG2][x2HG2]=SURE;

  identity[xPHE][x1HB][x2HB]=MAYBE;
  identity[xPHE][xHD1][xHD2]=MAYBE;
  identity[xPHE][xHE1][xHE2]=MAYBE;
  identity[xPHE][xCD1][xCD2]=MAYBE;
  identity[xPHE][xCE1][xCE2]=MAYBE;

  identity[xTYR][x1HB][x2HB]=MAYBE;
  identity[xTYR][xHD1][xHD2]=MAYBE;
  identity[xTYR][xHE1][xHE2]=MAYBE;
  identity[xTYR][xCD1][xCD2]=MAYBE;
  identity[xTYR][xCE1][xCE2]=MAYBE;

  identity[xHIS][x1HB][x2HB]=MAYBE;

  identity[xLYS][x1HB][x2HB]=MAYBE;
  identity[xLYS][x1HG][x2HG]=MAYBE;
  identity[xLYS][xHD1][xHD2]=MAYBE;
  identity[xLYS][xHE1][xHE2]=MAYBE;
  identity[xLYS][x1HZ][x2HZ]=SURE;

  identity[xARG][x1HB][x2HB]=MAYBE;
  identity[xARG][x1HG][x2HG]=MAYBE;
  identity[xARG][xHD1][xHD2]=MAYBE;
  identity[xARG][x1HH1][x2HH1]=SURE;
  identity[xARG][x1HH2][x2HH2]=SURE;

  identity[xTRP][x1HB][x2HB]=MAYBE;

/*make table symmetric: */  

  for(ri=1;ri<MAXTYPE;ri++)
     { 
      for (rii=1;rii<MAXATOMTYPE;rii++)
         {
          for (riii=1;riii<MAXATOMTYPE;riii++)
            {
             identity[ri][rii][riii]=(identity[ri][riii][rii] | identity[ri][rii][riii]);
            }
         }
     }
  

}

/*____________________________________________________________________*/


void clear_forbidden_matrix()

{
	int ri, rii,riii;

   for (ri=0;ri<MAXATOMTYPE;ri++)
      for (rii=0;rii<MAXRES;rii++)
          for (riii=0;riii<MAXATOMTYPE;riii++)
             forbidden_matrix[ri][rii][riii]=FALSE;
}


/*____________________________________________________________________*/


int getmidstring(char string1[],char string2[],int start,int stop)

{

	int i,j;

	j=0;

	strcpy(string2,"");

	for (i=start-1;i<strlen(string1) && i<stop;i++)

	{
		string2[j]=string1[i];

		j++;
	}

	string2[j]='\0';

	return 1;
}




/*____________________________________________________________________*/

int wild_string_compare(char string1[],char string2[],int size)


{

		int i,hits=0;

		int wild_card=0;

		for (i=0;i<size;i++)

			{
			if (string1[i]=='*')

				{

				wild_card++;

				}

			if (string1[i]==string2[i])

				{

				hits++;

				}
			}

		if (hits >= size-wild_card) return 1;

		if (size==wild_card) return 1;

		return 0;
}


/*____________________________________________________________________*/

int match(char string1[],char string2[])

{

	int len1,len2;

	int i,j;

	char buffer[MAXLINE];

	len1=strlen(string1);

	len2=strlen(string2);

	strcpy(buffer,"");



	if (len1>len2)

		{

		return -2;

		}

	if (len1>MAXLINE-1)

		{

		return -2;

		}

	if (len2>MAXLINE-1)

		{

		return -2;

		}

	for (i=0;i<=len2-len1;i++)

	{

	     for (j=0;j<=len1;j++)

	     {

	     buffer[j]=string2[i+j];

	     }

		 buffer[j]='\0';

		 if (1==wild_string_compare(string1,buffer,len1)) return i;

	}

	return -1;
}



/*____________________________________________________________________*/

int removechar(char buffer2[],char ch)

{
	int i,j=0;

	char temp[MAXLINE];

	j=0;		/*RW*/

	for (i=0;i<=strlen(buffer2);i++)  /*RW  <  -> <= */
	{
		if (buffer2[i]!=ch) 
		{       
			temp[j]=buffer2[i];

			j++;
		}
	}

	temp[j]='\0';

	strcpy(buffer2,temp);

	return 1;
}


/*____________________________________________________________________*/

int getresiduenumber(char residue_name[])

{

	int i,j,resnum,flag;

	char snum[10];

	flag=NEG;

	j=0;

	for (i=0;i<strlen(residue_name);i++)

	{

		if (flag==OK)

		{

			if (residue_name[i]=='(') 

			{

				flag=NEG;

				break;

			}

			snum[j]=residue_name[i];        

			j++;

			snum[j]='\0';
		}
		if (residue_name[i]=='(') flag=OK;
	}
	resnum=atoi(snum);

	return resnum;
}




/*____________________________________________________________________*/

short read_pdb(char file_name[])

{

	int anum, atomnumber, resnumber, old_resnumber;

	float atom_xcor, atom_ycor, atom_zcor ;

	char   atomtype[MAXTYPE], restype[MAXTYPE] ;

	char  buffer[MAXLINE], buffer2[MAXLINE] ;

	FILE *pdb;

	 

	pdb=fopen(file_name,"r");

	if (pdb==NULL)

	{
		printf("\n\07 Cannot open %s - will exit",file_name);

		return -1;
	}

	anum=0;
	count_residues=0;					 /* changed in V 0.91 */
        strcpy(buffer,"HEADER");				 /* changed in V 0.91 */
 	old_resnumber=0;					 /* changed in V 0.91 */
	while (!feof(pdb) && (strncmp(buffer,"TER",3)!=0) )      /* changed in V 0.91 */

	{
		fgets(buffer,MAXLINE,pdb);

		if (strncmp(buffer,"ATOM",4)==0)

		{
			getmidstring(buffer,buffer2,5,11);

			atomnumber=atoi(buffer2);

			getmidstring(buffer,buffer2,12,16);

			removechar(buffer2,32);

			strcpy(atomtype,buffer2);

			getmidstring(buffer,buffer2,18,20);

			strcpy(restype,buffer2);

			removechar(restype,32); 		 /*RW*/

			getmidstring(buffer,buffer2,23,26);  /* changed in V 1.0 */

			resnumber=atoi(buffer2);

			if (resnumber==old_resnumber) anum++;
			else 

			{
				anum=0;

				;
			}

			getmidstring(buffer,buffer2,30,38);

			atom_xcor=atof(buffer2);

			getmidstring(buffer,buffer2,39,46);

	   		atom_ycor=atof(buffer2);

			getmidstring(buffer,buffer2,47,54);

			atom_zcor=atof(buffer2); 

/* printf("\nBeen at pt. 2a, resnumber=%d, restype=%s",resnumber,restype);
 */
			strcpy(protein[resnumber].restype,restype);

			strcpy(protein[resnumber].atomtype[anum],atomtype);

			protein[resnumber].atomnumber[anum]=atomnumber;

			protein[resnumber].xcor[anum]=atom_xcor;

			protein[resnumber].ycor[anum]=atom_ycor;

			protein[resnumber].zcor[anum]=atom_zcor;

			protein[resnumber].count_atoms=anum;

			protein[resnumber].is_biomag[anum]= FALSE;

			protein[resnumber].is_PDB[anum]= TRUE;        /*RW*/

			protein[resnumber].is_duplicate[anum]=FALSE;

			old_resnumber=resnumber;

		} /*end if lines starts with ATOM*/
	}
	count_residues=resnumber;
	printf("\n highest residue number in PDB : %d ",count_residues);
	fclose(pdb);

	return 1;
}



/*____________________________________________________________________*/

int GetAtomNum(int db_resnum,char mtype[])  /*looks for the atom with type mtype in residue db_resnum
					      and returns its atomnumber as function value
					      returns -1 if atom type not found (i.e. atom not in PDB)*/

{
int atnum, i;

atnum=-1;

for(i=0;i<=protein[db_resnum].count_atoms;i++)
  if (strcmp(protein[db_resnum].atomtype[i],mtype)==0) atnum=i;

return(atnum);

}

/*____________________________________________________________________*/


void AddAtom(int db_resnum,char biomag_atomname[],char atomname[],float shift,char nucl) /* Adds atoms to the atom list. This
										happens, when an atom did not occur
										in the PDB-file, but in the BioMagResBank*/

{
int newnum;
protein[db_resnum].count_atoms++;
newnum=protein[db_resnum].count_atoms;
if (newnum<MAXATOM)
  {
	strcpy(protein[db_resnum].biomag_atomtype[newnum],biomag_atomname);
	strcpy(protein[db_resnum].atomtype[newnum],atomname);
	protein[db_resnum].chem_shift[newnum]=shift;
	protein[db_resnum].xcor[newnum]=-1;
	protein[db_resnum].ycor[newnum]=-1;
	protein[db_resnum].zcor[newnum]=-1;
	protein[db_resnum].is_biomag[newnum]=TRUE;
	protein[db_resnum].is_PDB[newnum]=FALSE;
	protein[db_resnum].nucleus[newnum]=nucl;
	protein[db_resnum].is_duplicate[newnum]=FALSE;
   }
 else
   {	
	printf("\n WARNING: The maximum possible number of atoms within one residue is\n");
        printf("          reached, atom %s of residue %s %d will not be considered any further!\n",
   		biomag_atomname,protein[db_resnum].restype,db_resnum);
	protein[db_resnum].count_atoms--;
   }
}

/*____________________________________________________________________*/


int DuplicateAtom(int db_resnum,int cnum)  /*Generates a new atom at the end of the list and copies all data from atom
						cnum to this new atom */
{
int newnum;

protein[db_resnum].count_atoms++;
newnum=protein[db_resnum].count_atoms;
if (newnum<=MAXATOM)
  {
	strcpy(protein[db_resnum].biomag_atomtype[newnum],protein[db_resnum].biomag_atomtype[cnum]);
	strcpy(protein[db_resnum].atomtype[newnum],protein[db_resnum].atomtype[cnum]);
	protein[db_resnum].nucleus[newnum]=protein[db_resnum].nucleus[cnum];
	protein[db_resnum].chem_shift[newnum]=protein[db_resnum].chem_shift[cnum];
	protein[db_resnum].xcor[newnum]=protein[db_resnum].xcor[cnum];
	protein[db_resnum].ycor[newnum]=protein[db_resnum].ycor[cnum];
	protein[db_resnum].zcor[newnum]=protein[db_resnum].zcor[cnum];
	protein[db_resnum].is_biomag[newnum]=protein[db_resnum].is_biomag[cnum];
	protein[db_resnum].is_PDB[newnum]=protein[db_resnum].is_PDB[cnum];
	protein[db_resnum].is_duplicate[cnum]=TRUE;
	return (TRUE);
   }
 else
   {	
	printf("\n WARNING: The maximum possible number of atoms within one residue is\n");
        printf("          reached, atom %s of residue %s %d will not be considered any further!\n",
   		protein[db_resnum].biomag_atomtype[cnum],protein[db_resnum].restype,db_resnum);
	protein[db_resnum].count_atoms--;
	return(FALSE);
   }
}


/*____________________________________________________________________*/


void EnterBioMagData(int db_resnum,int cnum,float shift,char biomag_atomname[],char nucl)  
										/*Adds the data from the biomagresbank to
										   the corresponding atom previously read
										 from the PDB-file*/

{
int ok_flag;

	if (protein[db_resnum].is_biomag[cnum])	/*first check, whether there is already biomag-data entered for this atom
						  this happens, when protons are contained twice in the Biomagresbank as
						  it is the case with diastereotopic protons, where the assignment is not sure*/
	   {
		ok_flag=DuplicateAtom(db_resnum,cnum);	/*generate a new atom and copy the data there*/
	   }
							/*now the first data can be overwritten, the atom is
							  now existing twice, as in the BioMagResBank,
							  both atoms still have the same PDB data*/
	protein[db_resnum].chem_shift[cnum]=shift;
	protein[db_resnum].is_biomag[cnum]=TRUE;
	strcpy(protein[db_resnum].biomag_atomtype[cnum],biomag_atomname);
	protein[db_resnum].nucleus[cnum]=nucl;
}


/*____________________________________________________________________*/


void SimpleMap(int db_resnum, char attype[],float shift,char biomag_atomname[],char nucl)

{ int cnum;

cnum=GetAtomNum(db_resnum,attype);

if (cnum>=0)
   EnterBioMagData(db_resnum,cnum,shift,biomag_atomname,nucl);
else
  AddAtom(db_resnum,biomag_atomname,attype,shift,nucl);
}


/*____________________________________________________________________*/


int GetResName(char biomag_string[])  /*retrieves the residue name from the biomagres-databank, obsolete with NMR star v2.1*/

{ 
	int value=FALSE;

        if (strcmp(biomag_string,"G")==NULL) { value=TRUE; strcpy(biomag_string,"GLY"); }
        if (strcmp(biomag_string,"A")==NULL) { value=TRUE; strcpy(biomag_string,"ALA"); }
        if (strcmp(biomag_string,"S")==NULL) { value=TRUE; strcpy(biomag_string,"SER"); }
        if (strcmp(biomag_string,"C")==NULL) { value=TRUE; strcpy(biomag_string,"CYS"); }
        if (strcmp(biomag_string,"V")==NULL) { value=TRUE; strcpy(biomag_string,"VAL"); }
        if (strcmp(biomag_string,"L")==NULL) { value=TRUE; strcpy(biomag_string,"LEU"); }
        if (strcmp(biomag_string,"I")==NULL) { value=TRUE; strcpy(biomag_string,"ILE"); }
        if (strcmp(biomag_string,"M")==NULL) { value=TRUE; strcpy(biomag_string,"MET"); }
        if (strcmp(biomag_string,"P")==NULL) { value=TRUE; strcpy(biomag_string,"PRO"); }
        if (strcmp(biomag_string,"D")==NULL) { value=TRUE; strcpy(biomag_string,"ASP"); }
        if (strcmp(biomag_string,"N")==NULL) { value=TRUE; strcpy(biomag_string,"ASN"); }
        if (strcmp(biomag_string,"E")==NULL) { value=TRUE; strcpy(biomag_string,"GLU"); }
        if (strcmp(biomag_string,"Q")==NULL) { value=TRUE; strcpy(biomag_string,"GLN"); }
        if (strcmp(biomag_string,"T")==NULL) { value=TRUE; strcpy(biomag_string,"THR"); }
        if (strcmp(biomag_string,"F")==NULL) { value=TRUE; strcpy(biomag_string,"PHE"); }
        if (strcmp(biomag_string,"Y")==NULL) { value=TRUE; strcpy(biomag_string,"TYR"); }
        if (strcmp(biomag_string,"H")==NULL) { value=TRUE; strcpy(biomag_string,"HIS"); }
        if (strcmp(biomag_string,"K")==NULL) { value=TRUE; strcpy(biomag_string,"LYS"); }
        if (strcmp(biomag_string,"R")==NULL) { value=TRUE; strcpy(biomag_string,"ARG"); }
        if (strcmp(biomag_string,"W")==NULL) { value=TRUE; strcpy(biomag_string,"TRP"); }
return(value);
}


/*____________________________________________________________________*/

short which_nuclei(char biomag_filename[])

{

	char buffer[MAXLINE], buffer2[MAXLINE];

	short job_done, rvalue=0;

	FILE *biomag;

	biomag=fopen(biomag_filename,"r");

	if (biomag==NULL)
	  {
		printf("\nCannot open BIOMAG file %s for input ... will exit\n",biomag_filename);
		exit (-1);
	  }
	job_done=FALSE;
	while (!job_done)
	  {
	  while ((feof(biomag)==0) && (strstr(buffer,"loop_")==NULL))
	    {
		fgets(buffer,MAXLINE,biomag);
	    }
	  fgets(buffer,MAXLINE,biomag);
 	  if (strstr(buffer,"Data_type")!=NULL)
	   {
            fgets(buffer,MAXLINE,biomag);
	   if ((strstr(buffer,"Data_value_count")!=NULL) || (strstr(buffer,"Data_type_count")!=NULL))
	      {
	       fgets(buffer,MAXLINE,biomag); /*empty line*/
	       printf("\nChemical shift data is available for the following nuclei:");
	       fgets(buffer,MAXLINE,biomag);
	       while ((strstr(buffer,"stop_")==NULL) && (!feof(biomag)))
		{
		 if (strstr(buffer,"chemical shift")!=NULL)
		   {
		    removechar(buffer,32);
		    getmidstring(buffer,buffer2,2,4);
		    removechar(buffer2,'c'); /*occurs when nucleus is 1H*/
	 	    printf("\n\t%s",buffer2);
		    if (strcmp(buffer2,"1H")==0)
			rvalue=rvalue | 1;
		    else if (strcmp(buffer2,"13C")==0)
			rvalue=rvalue | 2;
		    else if (strcmp(buffer2,"15N")==0)
			rvalue=rvalue | 4;
		    else
			printf(", but this version of the program can't handle that nucleus!");
		    job_done=TRUE;
		   }
	    	fgets(buffer,MAXLINE,biomag);
		}
	      }
	    }
 	  }
	fclose(biomag);
	return rvalue;
}

/*____________________________________________________________________*/
int GetResConst(int resnum)
{
	char res_name[4];
	short res_ID;

	strcpy(res_name,protein[resnum].restype);
	res_ID=FALSE;

	if ((strcmp(res_name,"ALA")==0)||(strcmp(res_name,"Ala")==0))
  	    res_ID=xALA;
 	if ((strcmp(res_name,"CYS")==0)||(strcmp(res_name,"Cys")==0))
	    res_ID=xCYS;
  	if ((strcmp(res_name,"ASP")==0)||(strcmp(res_name,"Asp")==0))
	    res_ID=xASP;
  	if ((strcmp(res_name,"GLU")==0)||(strcmp(res_name,"Glu")==0))
	    res_ID=xGLU;
  	if ((strcmp(res_name,"PHE")==0)||(strcmp(res_name,"Phe")==0))
	    res_ID=xPHE;
  	if ((strcmp(res_name,"GLY")==0)||(strcmp(res_name,"Gly")==0))
	    res_ID=xGLY;
  	if ((strcmp(res_name,"HIS")==0)||(strcmp(res_name,"His")==0))
	    res_ID=xHIS;
  	if ((strcmp(res_name,"ILE")==0)||(strcmp(res_name,"Ile")==0))
	    res_ID=xILE;
  	if ((strcmp(res_name,"LYS")==0)||(strcmp(res_name,"Lys")==0))
	    res_ID=xLYS;
  	if ((strcmp(res_name,"LEU")==0)||(strcmp(res_name,"Leu")==0))
	    res_ID=xLEU;
  	if ((strcmp(res_name,"MET")==0)||(strcmp(res_name,"Met")==0))
	    res_ID=xMET;
  	if ((strcmp(res_name,"ASN")==0)||(strcmp(res_name,"Asn")==0))
	    res_ID=xASN;
  	if ((strcmp(res_name,"PRO")==0)||(strcmp(res_name,"Pro")==0))
	    res_ID=xPRO;
  	if ((strcmp(res_name,"GLN")==0)||(strcmp(res_name,"Gln")==0))
	    res_ID=xGLN;
  	if ((strcmp(res_name,"ARG")==0)||(strcmp(res_name,"Arg")==0))
	    res_ID=xARG;
  	if ((strcmp(res_name,"SER")==0)||(strcmp(res_name,"Ser")==0))
	    res_ID=xSER;
  	if ((strcmp(res_name,"THR")==0)||(strcmp(res_name,"Thr")==0))
	    res_ID=xTHR;
  	if ((strcmp(res_name,"VAL")==0)||(strcmp(res_name,"Val")==0))
	    res_ID=xVAL;
  	if ((strcmp(res_name,"TRP")==0)||(strcmp(res_name,"Trp")==0))
	    res_ID=xTRP;
  	if ((strcmp(res_name,"TYR")==0)||(strcmp(res_name,"Tyr")==0))
	    res_ID=xTYR;

	return(res_ID);
}


/*____________________________________________________________________*/



short read_biomag(char biomag_filename[], int use_pdb_flag,int log_flag)

{

	int db_resnum, write_flag,ambiguity, format_OK, can_go_on, last_resnum;

	char residue_name[MAXATOMNAME],buffer[MAXLINE], nu;

	char buffer2[MAXLINE],biomag_atomname[MAXATOMNAME],data[10][10];

	float shift;
		
	short alert=0,pointer,column,pt2,i;

	short alert_flag;

	FILE *biomag;

	biomag=fopen(biomag_filename,"r");


	if (biomag==NULL)

	{

		printf("\nCannot open BIOMAG file %s for input ... will exit\n",biomag_filename);

		return -1;
	}
        
        
	strcpy(buffer2,"1.0");
	  printf("\n Title of BIOMAG database entry: \n");
        
	  while ((feof(biomag)==0) && (strstr(buffer,"_Entry_title")==NULL))
	    {
                   fgets(buffer,MAXLINE,biomag);
	    }
            fgets(buffer,MAXLINE,biomag);
	  while ((feof(biomag)==0) && (strstr(buffer,";")!=NULL))
	    {
                   fgets(buffer,MAXLINE,biomag);
		   printf("\n %s",buffer);
	    }
	 printf("\n");

	  while ((feof(biomag)==0) && (strstr(buffer,"_NMR_STAR_version")==NULL))
	    {
                   fgets(buffer,MAXLINE,biomag);
	    }
	   if  (strstr(buffer,"_NMR_STAR_version")!=NULL)
       	     {
	       getmidstring(buffer,buffer2,28,34);
	       removechar(buffer2,' ');
	     }
	     printf("\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n");
             printf("\n This file is in a NMR-STAR format version %s\n",buffer2);
             printf("\n This version of BBReader is designed for NMR-STAR V2.1\n");
	     printf("\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n");

	 
	 fclose(biomag);

	 biomag=fopen(biomag_filename,"r");


        can_go_on=FALSE; 

     	while (!feof(biomag) && !can_go_on)
	  {
	  while ((feof(biomag)==0) && (strstr(buffer,"loop_")==NULL))
	    {
		fgets(buffer,MAXLINE,biomag);
	    }
	  fgets(buffer,MAXLINE,biomag);
 	  if (strstr(buffer,"Atom_shift_assign_ID")!=NULL)
	   {
			if (!feof(biomag))
			  {
				format_OK=TRUE;
				/*from here onward the format is checked*/
			   	fgets(buffer,MAXLINE,biomag);			
				if (strstr(buffer,"_Residue_seq_code")==NULL)  format_OK=FALSE;
			   	fgets(buffer,MAXLINE,biomag);			
				if (strstr(buffer,"_Residue_label")==NULL)  format_OK=FALSE;
			   	fgets(buffer,MAXLINE,biomag);			
				if (strstr(buffer,"_Atom_name")==NULL)  format_OK=FALSE;
			   	fgets(buffer,MAXLINE,biomag);			
				if (strstr(buffer,"_Atom_type")==NULL)  format_OK=FALSE;
			   	fgets(buffer,MAXLINE,biomag);			
				if (strstr(buffer,"_Chem_shift_value")==NULL)  format_OK=FALSE;
			   	fgets(buffer,MAXLINE,biomag);			
				if (strstr(buffer,"_Chem_shift_value_error")==NULL)  format_OK=FALSE;
			   	fgets(buffer,MAXLINE,biomag);			
				if (strstr(buffer,"_Chem_shift_ambiguity_code")==NULL)  format_OK=FALSE;

				if (!format_OK)
				{
					printf("\nThis BioMagRes-File cannot be read!");
					printf("\nMake sure you use an unedited copy of the file in the");
					printf("\nSTAR 2.1 flat-file format as you retrieved it from the database!");
					return -1;
				}
				can_go_on=TRUE;
			  }
			else
			  {
				printf("\nThis BioMagRes-File cannot be read!");
				printf("\nMake sure you use an unedited copy of the file in the");
				printf("\nSTAR 2.1 flat-file format as you retrieved it from the database!");
				return -1;
			  }
			  
		  } /*end if (strstr....  */
	    } /* end while (feof(biomag)==0) && !can_go_on */	

	   fgets(buffer,MAXLINE,biomag);	/*read one empty line*/

	/*now the chemical shift data starts:*/

	   fgets(buffer,MAXLINE,biomag);

	   alert_flag=FALSE;

	   while ((strstr(buffer,"stop_")==NULL)&&(strlen(buffer)>10)&& (!feof(biomag)))
		{
                pointer=0;
 		column=0;
		while (pointer<=strlen(buffer))
		{
 		  if (buffer[pointer]!=' ')
		    {
		     column=column+1;
		     pt2=pointer;
 		     while (buffer[pt2]!=' ')
			pt2=pt2+1;
		     getmidstring(buffer,data[column],pointer,pt2);
		     pointer=pt2;
		    }
		pointer++;
		}

/* printf("\ninput line: %s \n chopped up in columns:",buffer);	
for(i=1;i<=8;i++)
	printf("\n%u  %s",i,data[i]);
printf("\n");
	
 */		db_resnum=atoi(data[2]);
		if (last_resnum != db_resnum)
		
			alert_flag=FALSE;

		last_resnum=db_resnum;
		strcpy(residue_name,data[3]);
		removechar(residue_name,' ');
		/* some programs add the charge to the residue name */
                removechar(residue_name,'+');
		removechar(residue_name,'-');
		if (strlen(residue_name)==1)
		  write_flag=GetResName(residue_name);
	 	else 
		  write_flag=TRUE;


/* printf("\ndb_resnum= %d, count_residues= %d, GetResConst(db_resnum= %d",db_resnum,count_residues, GetResConst(db_resnum));
 */
   		if (((db_resnum > count_residues) || (GetResConst(db_resnum)==FALSE))) 
					/*if no pdb_flag is used, it doesn't make sense to tell the user,that no pdb
				  entry for the residues is here*/
			   {
			    if (use_pdb_flag)
			      printf("\nResidue %s %d is not in the PDB-database, but in the BiomagResBank.",
					residue_name,db_resnum);
			     if (write_flag)
				{
				 strcpy(protein[db_resnum].restype,residue_name);
				 protein[db_resnum].count_atoms=0;
				 if (use_pdb_flag)
				 	printf("\n It will be considered as %s, but no distance information can be given.",
													residue_name);
				 if (db_resnum > count_residues)
					count_residues=db_resnum;
				}
			    else if (use_pdb_flag)
				 printf("\nIts type of residue is unknown, it will be ignored!");
			   }
		if (!write_flag)
		  {
			if (!alert_flag)
			   {
		 		printf("\nWARNING: Residue No. %d is of the unknown type %s. All its atoms are ignored.",
				  	db_resnum,residue_name);	
		  		printf("\n\t This version of BBReader can only handle the 20 \"classical\" L-amino-acids!");
				if (log_flag)
					fprintf(biomag_out,"\nWARNING: Residue No. %d is of the unknown type %s. All its atoms are ignored.",
				  	db_resnum,residue_name);
			   	alert_flag=TRUE;
			   }
		  }

		else if (strcmp(residue_name,protein[db_resnum].restype)!=0)
		  {
			if (!alert_flag)
			   {
				alert++;
				printf("\nWARNING: Residue No. %d is of type %s in the PDB-file and of type %s in the BMRB!",
				  	db_resnum,protein[db_resnum].restype,residue_name);
				printf("\n\t All its atoms are ignored.");
				if (log_flag)
				  {
					fprintf(biomag_out,"\nWARNING: Residue No. %d is of type %s in the PDB-file and of type %s in the BMRB!",
				  	     db_resnum,protein[db_resnum].restype,residue_name);
					fprintf(biomag_out,"\n\t All its atoms are ignored.");
				  }
			   	alert_flag=TRUE;
			   }	
		  }
		else
		  {
		   strcpy(biomag_atomname,data[4]);	   
		   removechar(biomag_atomname,' ');
		   removechar(data[5],' ');
		   nu=data[5][0];
		   removechar(data[6],' ');
		   shift=atof(data[6]);
		   removechar(data[8],' ');
		   ambiguity=atoi(data[8]);

		   if (db_resnum<MAXRES)
			{
			if (nu=='H')
			  {
				if (strcmp(biomag_atomname,"H")==0)
					SimpleMap(db_resnum,"H",shift,biomag_atomname,'H');
				if (strcmp(biomag_atomname,"HA")==0)
					SimpleMap(db_resnum,"HA",shift,biomag_atomname,'H');
				if (strcmp(biomag_atomname,"HA2")==0)
				  {
					SimpleMap(db_resnum,"1HA",shift,biomag_atomname,'H');
					if (ambiguity==2)
						SimpleMap(db_resnum,"2HA",shift,"HA3",'H');
				  }
				if (strcmp(biomag_atomname,"HA3")==0)
				  {
					SimpleMap(db_resnum,"2HA",shift,biomag_atomname,'H');
					if (ambiguity==2)
						SimpleMap(db_resnum,"1HA",shift,"HA2",'H');
				  }
				if (strcmp(biomag_atomname,"HB")==0) /*occurs in ALA, VAL, ILE,THR*/
				  {
					if (strcmp(protein[db_resnum].restype,"ALA")==0)
				  	{
						SimpleMap(db_resnum,"1HB",shift,biomag_atomname,'H');
						SimpleMap(db_resnum,"2HB",shift,biomag_atomname,'H');
						SimpleMap(db_resnum,"3HB",shift,biomag_atomname,'H');							}
					else /*VAL,ILE,THR*/
						SimpleMap(db_resnum,"HB",shift,biomag_atomname,'H');
						
				  }
				if (strcmp(biomag_atomname,"HB2")==0)
				  {
					SimpleMap(db_resnum,"1HB",shift,biomag_atomname,'H');
					if (ambiguity==2)
						SimpleMap(db_resnum,"2HB",shift,"HB3",'H');
				  }
				if (strcmp(biomag_atomname,"HB3")==0)
				  {
					SimpleMap(db_resnum,"2HB",shift,biomag_atomname,'H');
					if (ambiguity==2)
						SimpleMap(db_resnum,"1HB",shift,"HB2",'H');
				  }
				if (strcmp(biomag_atomname,"HG")==0)
					SimpleMap(db_resnum,"HG",shift,biomag_atomname,'H');
				if (strcmp(biomag_atomname,"HG1")==0)
				  {
					if (strncmp(protein[db_resnum].restype,"VAL",3)==0)
					{
						SimpleMap(db_resnum,"1HG1",shift,biomag_atomname,'H');
						SimpleMap(db_resnum,"2HG1",shift,biomag_atomname,'H');
						SimpleMap(db_resnum,"3HG1",shift,biomag_atomname,'H');
					}
					if (strncmp(protein[db_resnum].restype,"THR",3)==0)
						 	SimpleMap(db_resnum,"HG1",shift,biomag_atomname,'H');
				  }
				if (strcmp(biomag_atomname,"HG2")==0)
				  {
					if ((strncmp(protein[db_resnum].restype,"VAL",3)==0) ||
					    (strncmp(protein[db_resnum].restype,"ILE",3)==0) ||
					    (strncmp(protein[db_resnum].restype,"THR",3)==0))
					  {
						SimpleMap(db_resnum,"1HG2",shift,biomag_atomname,'H');
						SimpleMap(db_resnum,"2HG2",shift,biomag_atomname,'H');
						SimpleMap(db_resnum,"3HG2",shift,biomag_atomname,'H');
					  }
					else   /*all residues with a CH2-group at CG*/
					  {
						SimpleMap(db_resnum,"1HG",shift,biomag_atomname,'H');
						if (ambiguity==2)
							SimpleMap(db_resnum,"2HG",shift,"HG3",'H');
					  }
				  }
				if (strcmp(biomag_atomname,"HG3")==0)
				  {
					SimpleMap(db_resnum,"2HG",shift,biomag_atomname,'H');
					if (ambiguity==2)
						SimpleMap(db_resnum,"1HG",shift,"HG2",'H');
				  }
				if (strcmp(biomag_atomname,"HG12")==0)
				  {
					SimpleMap(db_resnum,"1HG1",shift,biomag_atomname,'H');
					if (ambiguity==2)
						SimpleMap(db_resnum,"2HG1",shift,"HG13",'H');
				  }
				if (strcmp(biomag_atomname,"HG13")==0)
				  {
					SimpleMap(db_resnum,"2HG1",shift,biomag_atomname,'H');
					if (ambiguity==2)
						SimpleMap(db_resnum,"1HG1",shift,"HG12",'H');
				  }
				if (strcmp(biomag_atomname,"HD")==0) /*occurs only in ILE*/
				  {
					SimpleMap(db_resnum,"1HD1",shift,biomag_atomname,'H');
					SimpleMap(db_resnum,"2HD1",shift,biomag_atomname,'H');
					SimpleMap(db_resnum,"3HD1",shift,biomag_atomname,'H');
				  }
				if (strcmp(biomag_atomname,"HD1")==0) /*occurs in LEU,ILE,PHE,TYR,HIS,TRP*/
				  {
					if ((strcmp(protein[db_resnum].restype,"LEU")==0) 				                                                        ||(strcmp(protein[db_resnum].restype,"ILE")==0))
					  {
						SimpleMap(db_resnum,"1HD1",shift,biomag_atomname,'H');
						SimpleMap(db_resnum,"2HD1",shift,biomag_atomname,'H');
						SimpleMap(db_resnum,"3HD1",shift,biomag_atomname,'H');
					  }
					else /*PHE,TYR,HIS,TRP*/
					  {	SimpleMap(db_resnum,"HD1",shift,biomag_atomname,'H');
					        if(ambiguity==3)
						  SimpleMap(db_resnum,"HD2",shift,biomag_atomname,'H');
					  }	
				  }
				if (strcmp(biomag_atomname,"HD2")==0) /*occurs in LEU,PHE,TYR,HIS,PRO,LYS,ARG,ASP*/
				  {
					if (strcmp(protein[db_resnum].restype,"LEU")==0)
					  {
						SimpleMap(db_resnum,"1HD2",shift,biomag_atomname,'H');
						SimpleMap(db_resnum,"2HD2",shift,biomag_atomname,'H');
						SimpleMap(db_resnum,"3HD2",shift,biomag_atomname,'H');
					  }
					else if ((strcmp(protein[db_resnum].restype,"PHE")==0) ||
					    	  (strcmp(protein[db_resnum].restype,"TYR")==0) ||
					    	  (strcmp(protein[db_resnum].restype,"HIS")==0)||
					    	  (strcmp(protein[db_resnum].restype,"ASP")==0))
					  {	SimpleMap(db_resnum,"HD2",shift,biomag_atomname,'H');
					        if(ambiguity==3)
						  SimpleMap(db_resnum,"HD1",shift,biomag_atomname,'H');
					  }	
					else /*PRO, LYS, ARG*/
					  {
						SimpleMap(db_resnum,"1HD",shift,biomag_atomname,'H');
						if (ambiguity==2)
							SimpleMap(db_resnum,"2HD",shift,"HD3",'H');
				  	  }
				  }
				if (strcmp(biomag_atomname,"HD3")==0) /*occurs in PRO,LYS,ARG*/
				  {
					SimpleMap(db_resnum,"2HD",shift,biomag_atomname,'H');
					if (ambiguity==2)
						SimpleMap(db_resnum,"1HD",shift,"HD2",'H');
				  }
				if (strcmp(biomag_atomname,"HD21")==0) /*occurs in ASN*/
				  {
					SimpleMap(db_resnum,"1HD2",shift,biomag_atomname,'H');
					if (ambiguity==2)
						SimpleMap(db_resnum,"2HD2",shift,"HD22",'H');
				  }
				if (strcmp(biomag_atomname,"HD22")==0) /*occurs in ASN*/
				  {
					SimpleMap(db_resnum,"2HD2",shift,biomag_atomname,'H');
					if (ambiguity==2)
						SimpleMap(db_resnum,"1HD2",shift,"HD21",'H');
				  }
				if (strcmp(biomag_atomname,"HE")==0) /*occurs in MET and ARG*/
				  {
					if (strcmp(protein[db_resnum].restype,"MET")==0)
					  {
						SimpleMap(db_resnum,"1HE",shift,biomag_atomname,'H');
						SimpleMap(db_resnum,"2HE",shift,biomag_atomname,'H');
						SimpleMap(db_resnum,"3HE",shift,biomag_atomname,'H');				  	  }
					else /*ARG*/
						SimpleMap(db_resnum,"HE",shift,biomag_atomname,'H');
				  }
				if (strcmp(biomag_atomname,"HE1")==0) /*occurs in PHE,TYR,HIS,TRP*/
					  {
					    SimpleMap(db_resnum,"HE1",shift,biomag_atomname,'H');
					    if(ambiguity==3)
						  SimpleMap(db_resnum,"HE2",shift,biomag_atomname,'H');
					  }	
				if (strcmp(biomag_atomname,"HE2")==0) /*occurs in PHE,TYR,HIS,ARG,LYS,GLU*/
				  {
					if ((strcmp(protein[db_resnum].restype,"ARG")==0) || (strcmp(protein[db_resnum].restype,"LYS")==0))
					  {
						SimpleMap(db_resnum,"1HE",shift,biomag_atomname,'H');
						if (ambiguity==2)
							SimpleMap(db_resnum,"2HE",shift,"HE3",'H');
					  }
					else /*PHE,TYR,HIS,GLU*/
					  {
					    SimpleMap(db_resnum,"HE2",shift,biomag_atomname,'H');
					    if(ambiguity==3)
						  SimpleMap(db_resnum,"HE1",shift,biomag_atomname,'H');
					  }	
				  }
				if (strcmp(biomag_atomname,"HE3")==0) /*occurs in ARG,TRP,LYS*/
				  {
					if ((strcmp(protein[db_resnum].restype,"ARG")==0) || (strcmp(protein[db_resnum].restype,"LYS")==0))
					  {
						SimpleMap(db_resnum,"2HE",shift,biomag_atomname,'H');
						if (ambiguity==2)
							SimpleMap(db_resnum,"1HE",shift,"HE2",'H');
					  }
					else /*TRP*/
						SimpleMap(db_resnum,"HE3",shift,biomag_atomname,'H');
				  }
				if (strcmp(biomag_atomname,"HE21")==0) /*occurs in GLN*/
				  {
					SimpleMap(db_resnum,"1HE2",shift,biomag_atomname,'H');
					if (ambiguity==2)
						SimpleMap(db_resnum,"2HE2",shift,"HE22",'H');
				  }
				if (strcmp(biomag_atomname,"HE22")==0) /*occurs in GLN*/
				  {
					SimpleMap(db_resnum,"2HE2",shift,biomag_atomname,'H');
					if (ambiguity==2)
						SimpleMap(db_resnum,"1HE2",shift,"HE21",'H');
				  }

				if (strcmp(biomag_atomname,"HZ")==0) /*occurs in LYS,PHE*/
				  {
					if (strcmp(protein[db_resnum].restype,"PHE")==0)
						SimpleMap(db_resnum,"HZ",shift,biomag_atomname,'H');
					else /*LYS*/
					   {
						SimpleMap(db_resnum,"1HZ",shift,biomag_atomname,'H');
						SimpleMap(db_resnum,"2HZ",shift,biomag_atomname,'H');
					   }
				  }
				if (strcmp(biomag_atomname,"HZ2")==0) /*occurs in TRP*/
					SimpleMap(db_resnum,"HZ2",shift,biomag_atomname,'H');
				if (strcmp(biomag_atomname,"HZ3")==0) /*occurs in TRP*/
					SimpleMap(db_resnum,"HZ3",shift,biomag_atomname,'H');
				if (strcmp(biomag_atomname,"HH")==0) /*occurs in TYR*/
					SimpleMap(db_resnum,"HH",shift,biomag_atomname,'H');
				if (strcmp(biomag_atomname,"HH2")==0) /*occurs in TRP*/
					SimpleMap(db_resnum,"HH2",shift,biomag_atomname,'H');
				if (strcmp(biomag_atomname,"HH11")==0) /*occurs in ARG*/
				  {
					SimpleMap(db_resnum,"1HH1",shift,biomag_atomname,'H');
					if (ambiguity==2)
						SimpleMap(db_resnum,"2HH1",shift,"HH12",'H');
				  }
				if (strcmp(biomag_atomname,"HH12")==0) /*occurs in ARG*/
				  {
					SimpleMap(db_resnum,"2HH1",shift,biomag_atomname,'H');
					if (ambiguity==2)
						SimpleMap(db_resnum,"1HH1",shift,"HH11",'H');
				  }
				if (strcmp(biomag_atomname,"HH21")==0) /*occurs in ARG*/
				  {
					SimpleMap(db_resnum,"1HH2",shift,biomag_atomname,'H');
					if (ambiguity==2)
						SimpleMap(db_resnum,"2HH2",shift,"HH22",'H');
				  }
				if (strcmp(biomag_atomname,"HH22")==0) /*occurs in ARG*/
				  {
					SimpleMap(db_resnum,"2HH2",shift,biomag_atomname,'H');
					if (ambiguity==2)
						SimpleMap(db_resnum,"1HH2",shift,"HH21",'H');
				  }
			  }
			else if (nu=='C')
			   {	
				if (strcmp(biomag_atomname,"C")==0) /*carbonyl-C */
					SimpleMap(db_resnum,"C",shift,biomag_atomname,'C');
				if (strcmp(biomag_atomname,"CA")==0)
					SimpleMap(db_resnum,"CA",shift,biomag_atomname,'C');
				if (strcmp(biomag_atomname,"CB")==0)
					SimpleMap(db_resnum,"CB",shift,biomag_atomname,'C');
				if (strcmp(biomag_atomname,"CG")==0)
					SimpleMap(db_resnum,"CG",shift,biomag_atomname,'C');
				if (strcmp(biomag_atomname,"CG1")==0)
					SimpleMap(db_resnum,"CG1",shift,biomag_atomname,'C');
				if (strcmp(biomag_atomname,"CG2")==0)
					SimpleMap(db_resnum,"CG2",shift,biomag_atomname,'C');
				if (strcmp(biomag_atomname,"CD")==0)
					SimpleMap(db_resnum,"CD",shift,biomag_atomname,'C');
				if (strcmp(biomag_atomname,"CD1")==0)
					SimpleMap(db_resnum,"CD1",shift,biomag_atomname,'C');
				if (strcmp(biomag_atomname,"CD2")==0)
					SimpleMap(db_resnum,"CD2",shift,biomag_atomname,'C');
				if (strcmp(biomag_atomname,"CE")==0)
					SimpleMap(db_resnum,"CE",shift,biomag_atomname,'C');
				if (strcmp(biomag_atomname,"CE1")==0)
					SimpleMap(db_resnum,"CE1",shift,biomag_atomname,'C');
				if (strcmp(biomag_atomname,"CE2")==0)
					SimpleMap(db_resnum,"CE2",shift,biomag_atomname,'C');
				if (strcmp(biomag_atomname,"CE3")==0)
					SimpleMap(db_resnum,"CE3",shift,biomag_atomname,'C');
				if (strcmp(biomag_atomname,"CH2")==0)
					SimpleMap(db_resnum,"CH2",shift,biomag_atomname,'C');
				if (strcmp(biomag_atomname,"CZ")==0)
					SimpleMap(db_resnum,"CZ",shift,biomag_atomname,'C');
				if (strcmp(biomag_atomname,"CZ3")==0)
					SimpleMap(db_resnum,"CZ3",shift,biomag_atomname,'C');
				if (strcmp(biomag_atomname,"CZ2")==0)
					SimpleMap(db_resnum,"CZ2",shift,biomag_atomname,'C');
			   }
			else if (nu=='N')
			   {
				if (strcmp(biomag_atomname,"N")==0) /*peptide-bond-N */
					SimpleMap(db_resnum,"N",shift,biomag_atomname,'N');
				if (strcmp(biomag_atomname,"NZ")==0)
					SimpleMap(db_resnum,"NZ",shift,biomag_atomname,'N');
				if (strcmp(biomag_atomname,"ND1")==0)
					SimpleMap(db_resnum,"ND1",shift,biomag_atomname,'N');
				if (strcmp(biomag_atomname,"ND2")==0)
					SimpleMap(db_resnum,"ND2",shift,biomag_atomname,'N');
				if (strcmp(biomag_atomname,"NE")==0)
					SimpleMap(db_resnum,"NE",shift,biomag_atomname,'N');
				if (strcmp(biomag_atomname,"NE1")==0)
					SimpleMap(db_resnum,"NE1",shift,biomag_atomname,'N');
				if (strcmp(biomag_atomname,"NE2")==0)
					SimpleMap(db_resnum,"NE2",shift,biomag_atomname,'N');
				if (strcmp(biomag_atomname,"NH1")==0)
					SimpleMap(db_resnum,"NH1",shift,biomag_atomname,'N');
				if (strcmp(biomag_atomname,"NH2")==0)
					SimpleMap(db_resnum,"NH2",shift,biomag_atomname,'N');
			   }

			} /*endif db_resnum<MAXRES*/
		  }

		if (!feof(biomag))
		   {
			fgets(buffer,MAXLINE,biomag);
		   }
	} /* end while (!feof(biomag)) */

fclose(biomag);

 if (alert>0)
	{
	if (alert==1)
		strcpy (buffer,"residue");
	else
		strcpy (buffer,"residues");
	printf("\nFor %d %s the type contained in the PDB and in the BMRB-database are different!",alert,buffer);
/*	printf("\nExit? (y/n):");
	scanf("%s",buffer);
	if ((buffer[0]=='y')||(buffer[0]=='Y'))
   	  exit (-1);
*/	}

 return alert;

} /*end of function read_biomag */


/*____________________________________________________________________*/


short GetAtomConst(int resnum,int atnum)

{
	short at_ID;
	char at_type[MAXATOMNAME];

	strcpy(at_type,protein[resnum].atomtype[atnum]);
	at_ID=FALSE;
/*	removechar(at_type,32);
*/
            if (strcmp(at_type,"HA")==0)
		at_ID=xHA;
            if (strcmp(at_type,"H")==0)
		at_ID=xH;
            if (strcmp(at_type,"1HA")==0)
		at_ID=x1HA;
            if (strcmp(at_type,"2HA")==0)
		at_ID=x2HA;
            if (strcmp(at_type,"HB")==0)
		at_ID=xHB;
            if (strcmp(at_type,"1HB")==0)
		at_ID=x1HB;
            if (strcmp(at_type,"2HB")==0)
		at_ID=x2HB;
            if (strcmp(at_type,"3HB")==0)
		at_ID=x3HB;
            if (strcmp(at_type,"HG")==0)
		at_ID=xHG;
            if ((strcmp(at_type,"1HG")==0) || (strcmp(at_type,"HG1")==0))
		at_ID=x1HG;
            if (strcmp(at_type,"2HG")==0)
		at_ID=x2HG;
             if (strcmp(at_type,"1HG1")==0)
		at_ID=x1HG1;
            if (strcmp(at_type,"1HG2")==0)
		at_ID=x1HG2;
            if (strcmp(at_type,"2HG1")==0)
		at_ID=x2HG1;
            if (strcmp(at_type,"2HG2")==0)
		at_ID=x2HG2;
           if (strcmp(at_type,"3HG1")==0)
		at_ID=x3HG1;
            if (strcmp(at_type,"3HG2")==0)
		at_ID=x3HG2;
           if (strcmp(at_type,"HD")==0)
		at_ID=xHD;
            if ((strcmp(at_type,"HD1")==0) || (strcmp(at_type,"1HD")==0))
		at_ID=xHD1;
            if ((strcmp(at_type,"HD2")==0) || (strcmp(at_type,"2HD")==0))
		at_ID=xHD2;
           if (strcmp(at_type,"1HD2")==0)
		at_ID=x1HD2;
           if (strcmp(at_type,"2HD2")==0)
		at_ID=x2HD2;
           if (strcmp(at_type,"3HD2")==0)
		at_ID=x3HD2;
           if (strcmp(at_type,"1HD1")==0)
		at_ID=x1HD1;
           if (strcmp(at_type,"2HD1")==0)
		at_ID=x2HD1;
           if (strcmp(at_type,"3HD1")==0)
		at_ID=x3HD1;
            if (strcmp(at_type,"HE")==0)
		at_ID=xHE;
            if ((strcmp(at_type,"HE1")==0) || (strcmp(at_type,"1HE")==0))
		at_ID=xHE1;
            if ((strcmp(at_type,"HE2")==0) || (strcmp(at_type,"2HE")==0))
		at_ID=xHE2;
            if ((strcmp(at_type,"HE3")==0) || (strcmp(at_type,"3HE")==0))
		at_ID=xHE3;
            if (strcmp(at_type,"1HE2")==0)
		at_ID=x1HE2;
            if (strcmp(at_type,"2HE2")==0)
		at_ID=x2HE2;
            if (strcmp(at_type,"HH")==0)
		at_ID=xHH;
            if (strcmp(at_type,"HH2")==0)
		at_ID=xHH2;
           if (strcmp(at_type,"1HH2")==0)
		at_ID=x1HH2;
           if (strcmp(at_type,"2HH2")==0)
		at_ID=x2HH2;
           if (strcmp(at_type,"1HH1")==0)
		at_ID=x1HH1;
           if (strcmp(at_type,"2HH1")==0)
		at_ID=x2HH1;
           if (strcmp(at_type,"HZ")==0)
		at_ID=xHZ;
           if (strcmp(at_type,"1HZ")==0)
		at_ID=x1HZ;
           if (strcmp(at_type,"2HZ")==0)
		at_ID=x2HZ;
           if (strcmp(at_type,"HZ2")==0)
		at_ID=xHZ2;
           if (strcmp(at_type,"HZ3")==0)
		at_ID=xHZ3;
           if (strcmp(at_type,"C")==0)
                at_ID=xC;
           if (strcmp(at_type,"CA")==0)
                at_ID=xCA;
           if (strcmp(at_type,"CB")==0)
                at_ID=xCB;
           if (strcmp(at_type,"CG")==0)
                at_ID=xCG;
           if (strcmp(at_type,"CG1")==0)
                at_ID=xCG1;
           if (strcmp(at_type,"CG2")==0)
                at_ID=xCG2;
           if (strcmp(at_type,"CD")==0)
                at_ID=xCD;
           if (strcmp(at_type,"CD1")==0)
                at_ID=xCD1;
           if (strcmp(at_type,"CD2")==0)
                at_ID=xCD2;
           if (strcmp(at_type,"CE")==0)
                at_ID=xCE;
           if (strcmp(at_type,"CE1")==0)
                at_ID=xCE1;
           if (strcmp(at_type,"CE2")==0)
                at_ID=xCE2;
           if (strcmp(at_type,"CE3")==0)
                at_ID=xCE3;
           if (strcmp(at_type,"CZ")==0)
                at_ID=xCZ;
           if (strcmp(at_type,"CZ2")==0)
                at_ID=xCZ2;
           if (strcmp(at_type,"CZ3")==0)
                at_ID=xCZ3;
           if (strcmp(at_type,"CH2")==0)
                at_ID=xCH2;
           if (strcmp(at_type,"N")==0)
                at_ID=xN;
           if (strcmp(at_type,"ND1")==0)
                at_ID=xND1;
           if (strcmp(at_type,"ND2")==0)
                at_ID=xND2;
           if (strcmp(at_type,"NE")==0)
                at_ID=xNE;
           if (strcmp(at_type,"NE1")==0)
                at_ID=xNE1;
           if (strcmp(at_type,"NE2")==0)
                at_ID=xNE2;
           if (strcmp(at_type,"NZ")==0)
                at_ID=xNZ;
           if (strcmp(at_type,"NH1")==0)
                at_ID=xNH1;
           if (strcmp(at_type,"NH2")==0)
                at_ID=xNH2;

	return (at_ID);
}


/*____________________________________________________________________*/


int identity_check(int i,int j,int ii,int jj)
{

	if (i!=ii)
		return(FALSE);

	if (protein[i].its_ResConst==FALSE)
	   {
	    printf ("\n Encountered illegal residue-name %s, res.no.%d, will be ignored!\n",
			protein[i].restype,i);
   	    return (FALSE);
           }

	return(identity[protein[i].its_ResConst][protein[i].its_AtomConst[j]][protein[i].its_AtomConst[jj]]);
}



/*____________________________________________________________________*/


int check_COSY(int resnum1,int atnum1,int resnum2,int atnum2)
  {
	short at_ID[2],ri,outnum,outres,result;
 
	if (protein[resnum1].its_ResConst==FALSE) 
	   {
	    printf ("\n Encountered illegal residue-name %s, res.no.%d, will be ignored!\n",
			protein[resnum1].restype,resnum1);
   	    return FALSE;
           }
	if (protein[resnum2].its_ResConst==FALSE) 
	   {
	    printf ("\n Encountered illegal residue-name %s, res.no.%d, will be ignored!\n",
			protein[resnum2].restype,resnum2);
   	    return FALSE;
           }

	 at_ID[0]=protein[resnum1].its_AtomConst[atnum1];
	 at_ID[1]=protein[resnum2].its_AtomConst[atnum2];
	 for (ri=0;ri<=1;ri++)
	    {
	      if (at_ID[ri]==FALSE)
                {
	         if (ri==0)
  		  {
		   outnum=atnum1;
		   outres=resnum1;
		  }
	         else /*ri==1*/
	 	  {
		   outnum=atnum2;
		   outnum=resnum2;
		  }
                 printf("\nEncountered unknown atom-type %s in residue %s %d, will be ignored!\n",
		   	protein[outres].atomtype[outnum],protein[outres].restype,outres);
     	         return FALSE;
                }
	    }

	result=cosy_crosspeak[protein[resnum1].its_ResConst][at_ID[0]][at_ID[1]];

/*        printf("\nResidues %s %d atom %d / %s %d atom %d, crosspeak-matrix shows %d.",protein[resnum1].restype,
			resnum1,at_ID[0], protein[resnum2].restype,resnum2,at_ID[1],
			result);
  	  printf("\nThe atom's biomag_atomtype is %s and %s",protein[resnum1].biomag_atomtype[atnum1],
			protein[resnum2].biomag_atomtype[atnum2]);
  	  printf("\nThe atom's atomtype is %s and %s\n",protein[resnum1].atomtype[atnum1],
			protein[resnum2].atomtype[atnum2]); */
  /*only for debugging*/


	if (resnum1==resnum2)
          {
	   if (result == SEQUENTIAL) 
		return FALSE;  /*sequential peaks cannot occur between atoms within the same residue! */
	     else if (result == INTRASEQ)
		return TRUE;
	     else
		return result; 
 	  }
	else
	  {
	  if ((resnum1<resnum2) && (at_ID[1]==xN))
		{
		if ((result==SEQUENTIAL) || (result==INTRASEQ))
			return result;
		  else
			return FALSE;
		}
	   else if ((resnum1>resnum2) && (at_ID[0]==xN))
		{
		if ((result==SEQUENTIAL) || (result==INTRASEQ))
			return result;		
		  else
			return FALSE;
		}
 	   else 
		return FALSE;	/*sequential peaks can only occur to an amide nitrogen*/
          }
      return FALSE; /*This point is never reached, the statement merely suppresses a warning from the compiler*/
 }


/*____________________________________________________________________*/


void ForbidIdentical(int res1,int res2,int at1,int at2)		/*is called after a matching peak is found, it 
								  takes care, that other possible cross-peaks 
								  to/from identical peaks are not considered any more*/

{
	int ri,rii,at1ID,at2ID,comp1ID,comp2ID,res1ID,res2ID;

	res1ID=protein[res1].its_ResConst;
	if (res1ID==FALSE)
   	    return;
	at1ID=protein[res1].its_AtomConst[at1];
	if (at1ID==FALSE)
  	   return;
 	if (res2>=0)    /*when only 1D-info is desired, res2 will be given as -1*/
	  {
	   res2ID=protein[res2].its_ResConst;
	   if (res2ID==FALSE)
  	       return;
	   at2ID=protein[res2].its_AtomConst[at2];
	   if (at2ID==FALSE)
  	       return;

	   for (ri=0;ri<=protein[res1].count_atoms;ri++)
	   {
		comp1ID=protein[res1].its_AtomConst[ri];
		if (comp1ID!=0)
		{
	   	   if ((identity[res1ID][comp1ID][at1ID]==SURE) || ((identity[res1ID][comp1ID][at1ID]==MAYBE) &&
						 (protein[res1].chem_shift[at1]==protein[res1].chem_shift[ri]))) 
		   {
			for (rii=0;rii<=protein[res2].count_atoms;rii++)
			{
				comp2ID=protein[res2].its_AtomConst[rii];
				if (comp2ID!=0)
				{
				   if ((identity[res2ID][comp2ID][at2ID]==SURE) || ((identity[res2ID][comp2ID][at2ID]==MAYBE) &&
						 (protein[res2].chem_shift[at2]==protein[res2].chem_shift[rii])))
				   {
					forbidden_matrix[ri][res2][rii]=TRUE;
					forbidden_matrix[rii][res2][ri]=TRUE;
				   }
				}
			}
		   }
		}
	    }
	  }
	  else /* only 1D-info*/
	    for (ri=0;ri<=protein[res1].count_atoms;ri++)
	     {
		comp1ID=protein[res1].its_AtomConst[ri];
		if (comp1ID!=0)
		{
	   	   if ((identity[res1ID][comp1ID][at1ID]==SURE) || ((identity[res1ID][comp1ID][at1ID]==MAYBE) &&
						 (protein[res1].chem_shift[at1]==protein[res1].chem_shift[ri]))) 
		   {
			forbidden_matrix[ri][0][0]=TRUE;
		   }
		}
	     }

}


/*____________________________________________________________________*/


double CalcDistance(int res1,int res2,int at1,int at2)

{
	double dx, dy, dz;


     if ((!protein[res1].is_PDB[at1]) || (!protein[res2].is_PDB[at2]))	/*if one of atoms not in PDB*/
	{							
	  return (-2.0);
	}
       else
	{
	  dx=protein[res1].xcor[at1]-protein[res2].xcor[at2];

	  dy=protein[res1].ycor[at1]-protein[res2].ycor[at2];

	  dz=protein[res1].zcor[at1]-protein[res2].zcor[at2];

	  return (sqrt(dx*dx+dy*dy+dz*dz));
	}

}


/*____________________________________________________________________*/


float ScanIdenticalGroup(int res1,int res2,int at1,int at2)	/*Scans all possible identical groups to the input group
								  and returns the smallest distance occurring within
								  the group. If no identical other groups are found*/
{								/*the routine returns -1  */
	int ri,rii,at1ID,at2ID,comp1ID,comp2ID,res1ID,res2ID;
	double distance, helpdistance;

	distance=-1.;
	res1ID=protein[res1].its_ResConst;
	if (!res1ID)
   	    return (-1);
	at1ID=protein[res1].its_AtomConst[at1];
	if (!at1ID)
  	   return (-1);
	res2ID=protein[res2].its_ResConst;
	if (!res2ID)
  	   return (-1);
	at2ID=protein[res2].its_AtomConst[at2];
	if (!at2ID)
  	   return (-1);

	for (ri=0;ri<protein[res1].count_atoms;ri++)
	   {
	    comp1ID=protein[res1].its_AtomConst[ri];
	    if (comp1ID!=0)
	      {
	       if ((identity[res1ID][comp1ID][at1ID]==SURE) || ((identity[res1ID][comp1ID][at1ID]==MAYBE) &&
						 (protein[res1].chem_shift[at1]==protein[res1].chem_shift[ri]))) 
		   {
			for (rii=0;rii<protein[res2].count_atoms;rii++)
			{
				comp2ID=protein[res2].its_AtomConst[rii];
				if (comp2ID!=0)
				{
				   if ((identity[res2ID][comp2ID][at2ID]==SURE) || ((identity[res2ID][comp2ID][at2ID]==MAYBE) &&
						 (protein[res2].chem_shift[at2]==protein[res2].chem_shift[rii])))
				   {
					if ((ri!=at1) || (rii != at2))  /*we do not want to get back the distance between
									the two original atoms, because that way, we can */
					  {				/*easily decide, whether there is another identical
									group or not and therby decide, whether to print
									"dist" or "smallest dist" in the output*/
					   if ((protein[res1].is_PDB[ri]) && (protein[res2].is_PDB[rii]))
					     {
					   	helpdistance=CalcDistance(res1,res2,ri,rii);
						if ((helpdistance<1.2)&&(helpdistance>0))
printf("\nWARNING! distance (from PDB) between %s %d %s and %s %d %s is only %4.2f A !",protein[res1].restype,res1,
		protein[res1].biomag_atomtype[ri],protein[res2].restype,res2,
		protein[res1].biomag_atomtype[rii],helpdistance);
				
					   	if (((helpdistance<distance)||(distance<0)) && (helpdistance!=0))
							distance=helpdistance;
					     }
					  }
				   }
				}
			}
		   }
	      }
	  }
	return (distance);
}



/*____________________________________________________________________*/


void FindIdenticalGroups(int res,int atom,char out_string[])

{
	int res_ID,atom_ID,comp_ID,ri;

	res_ID=protein[res].its_ResConst;
	if (!res_ID)
		return;
	atom_ID=protein[res].its_AtomConst[atom];
	if (!atom_ID)
		return;
	strcpy(out_string,protein[res].biomag_atomtype[atom]);
	for (ri=0;ri<=protein[res].count_atoms;ri++)
	   {
	   comp_ID=protein[res].its_AtomConst[ri];
	   if ((comp_ID) && (comp_ID!=atom_ID))
		{
		if ((identity[res_ID][atom_ID][comp_ID]==SURE) || ((identity[res_ID][atom_ID][comp_ID]==MAYBE) &&
							(protein[res].chem_shift[atom]==protein[res].chem_shift[ri])))
		    {
			if (strstr(out_string,protein[res].biomag_atomtype[ri])==NULL)
			   {
		 		strcat(out_string,"/");
				strcat(out_string,protein[res].biomag_atomtype[ri]);
			   }
		    }
		}
	   }

}

/*____________________________________________________________________*/


void NewHit(char spec_type[],int i,int ii,int iii,int j,int jj,int jjj,double dist,double nearest_dist,double dist_3D,
		double nearest_dist_3D,int out_flag,int out_flag_3D,
		int use_pdb_flag,short dim, double ideal_shift[4])

{ 		/*is called, whenever a new hit is found. It writes the new hit to its position in the hitlist*/
	int ri,rj,factor[4];
	double scr, dist_score1,dist_score2,f1_score,f2_score, f3_score;
	
	   if (protein[i].nucleus[j]=='H')
		factor[1]=90;
	   else
		factor[1]=4;
	
	   if (protein[ii].nucleus[jj]=='H')
		factor[2]=90;
	   else
		factor[2]=4;

	   if (protein[iii].nucleus[jjj]=='H')
		factor[3]=90;
	   else
		factor[3]=4;
	
	
	f1_score=(factor[1]*(protein[i].chem_shift[j]-ideal_shift[1]));
	f2_score=0;
	f3_score=0;
	dist_score1=0;
	dist_score2=0;
	if (dim>1)
	  {
		f2_score=factor[2]*(protein[ii].chem_shift[jj]-ideal_shift[2]);
		
		if (((spec_type[0]=='n') && (use_pdb_flag)) && (out_flag!=2))
		   {
			if ((dist>nearest_dist)	&& (nearest_dist>0))
				dist=nearest_dist;
			if (dist>4)
				dist_score1=(dist-4)*(dist-4)*10;
		   }
		if (out_flag==2)
		  {
		   dist_score1=(ii-i);
		   if (dist_score1<0) dist_score1=-dist_score1;
		   if (dist_score1>4) dist_score1=5; /*score = number of res in between, but max. 5!*/
		  }

		if (dim==3)
		   {

			f3_score=factor[3]*(protein[iii].chem_shift[jjj]-ideal_shift[3]);

			if (((spec_type[1]=='n') && (use_pdb_flag))&& (out_flag!=2))
			   {
				if ((dist_3D>nearest_dist_3D)	&& (nearest_dist_3D>0))
					dist_3D=nearest_dist_3D;
				if (dist_3D>4)
					dist_score2=(dist_3D-4)*(dist_3D-4)*10;
		 	  }
			if (out_flag_3D==2)  /*1.91*/
		 	 {
			   dist_score2=(iii-i)/10;
			   if (dist_score2<0) dist_score2=-dist_score2;
			   if (dist_score2>4) dist_score2=5; /*score = number of res in between, but max. 5!*/		  }

			  }

		   }



	scr=100-(dist_score1+dist_score2+(f1_score*f1_score+f2_score*f2_score+f3_score*f3_score))/dim;  /*purly arbitrary*/

/* printf("\n\t\tAnalyzing hit: %s %d | %s %d | %s %d; outflag= %d, outflag_3D=%d, score=%3.0f, 			spectype=%s",protein[i].biomag_atomtype[j],i,protein[ii].biomag_atomtype[jj],ii,protein[iii].biomag_atomtype[jjj],iii,out_flag,out_flag_3D,scr,spec_type);
 */

if ((((spec_type[0]=='n') && (out_flag==TRUE)) || ((spec_type[1]=='n') && (out_flag_3D==TRUE))) || ((spec_type[0]=='c') && (spec_type[1]=='c')) || ((dim==2) && (spec_type[0]=='c')))	
			/* either are all dimensions COSY or one of them is NOESY AND the distance between atoms is known */ /*1.91*/
	{
		/* printf(" -> hitlist"); */
 	ri=0;
	while ((hitlist[ri].score>=scr) &&(ri<MAXHITS-1))	/*browses the hitlist until it finds worse score*/
		ri++;

	for (rj=MAXHITS-1;rj>ri;rj--)	/*shifts the whole hitlist up for 1 position to make*/
	  {				/*free position for new hit, the hitherto worst hit is deleted*/
		hitlist[rj].resid1=hitlist[rj-1].resid1;
		hitlist[rj].resid2=hitlist[rj-1].resid2;
		hitlist[rj].resid3=hitlist[rj-1].resid3;
		hitlist[rj].atom1=hitlist[rj-1].atom1;
		hitlist[rj].atom2=hitlist[rj-1].atom2;
		hitlist[rj].atom3=hitlist[rj-1].atom3;
		hitlist[rj].score=hitlist[rj-1].score;
		hitlist[rj].dist=hitlist[rj-1].dist;
		hitlist[rj].nearest_dist=hitlist[rj-1].nearest_dist;
		hitlist[rj].dist_3D=hitlist[rj-1].dist_3D;
		hitlist[rj].nearest_dist_3D=hitlist[rj-1].nearest_dist_3D;
		hitlist[rj].outflag=hitlist[rj-1].outflag;
		hitlist[rj].outflag_3D=hitlist[rj-1].outflag_3D;
	  }
	
	if (ri<MAXHITS-1)
	  {
		hitlist[ri].resid1=i;
		hitlist[ri].resid2=ii;
		hitlist[ri].resid3=iii;
		hitlist[ri].atom1=j;
		hitlist[ri].atom2=jj;
		hitlist[ri].atom3=jjj;
		hitlist[ri].score=scr;
		hitlist[ri].dist=dist;
		hitlist[ri].nearest_dist=nearest_dist;
		hitlist[ri].dist_3D=dist_3D;
		hitlist[ri].nearest_dist_3D=nearest_dist_3D;
		hitlist[ri].outflag=out_flag;				
		hitlist[ri].outflag_3D=out_flag_3D;				
	  }
	}
       else if ((out_flag==2) || (out_flag_3D==2)) 
	{
		/*  printf(" -> hitlist2"); */
	ri=0;
	while ((hitlist2[ri].score>=scr) &&(ri<MAXHITS-1))	/*browses the hitlist2 until it finds worse score*/
		ri++;

	for (rj=MAXHITS-1;rj>ri;rj--)	/*shifts the whole hitlist2 up for 1 position to make*/
	  {				/*free position for new hit, the hitherto worst hit is deleted*/
		hitlist2[rj].resid1=hitlist2[rj-1].resid1;
		hitlist2[rj].resid2=hitlist2[rj-1].resid2;
		hitlist2[rj].resid3=hitlist2[rj-1].resid3;
		hitlist2[rj].atom1=hitlist2[rj-1].atom1;
		hitlist2[rj].atom2=hitlist2[rj-1].atom2;
		hitlist2[rj].atom3=hitlist2[rj-1].atom3;
		hitlist2[rj].score=hitlist2[rj-1].score;
		hitlist2[rj].dist=hitlist2[rj-1].dist;
		hitlist2[rj].nearest_dist=hitlist2[rj-1].nearest_dist;
		hitlist2[rj].dist_3D=hitlist2[rj-1].dist_3D;
		hitlist2[rj].nearest_dist_3D=hitlist2[rj-1].nearest_dist_3D;
		hitlist2[rj].outflag=hitlist2[rj-1].outflag;
		hitlist2[rj].outflag_3D=hitlist2[rj-1].outflag_3D;
	  }
	
	if (ri<MAXHITS-1)
	  {
		hitlist2[ri].resid1=i;
		hitlist2[ri].resid2=ii;
		hitlist2[ri].resid3=iii;
		hitlist2[ri].atom1=j;
		hitlist2[ri].atom2=jj;
		hitlist2[ri].atom3=jjj;
		hitlist2[ri].score=scr;
		hitlist2[ri].dist=dist;
		hitlist2[ri].nearest_dist=nearest_dist;
		hitlist2[ri].dist_3D=dist_3D;
		hitlist2[ri].nearest_dist_3D=nearest_dist_3D;
		hitlist2[ri].outflag=out_flag;				
		hitlist2[ri].outflag_3D=out_flag_3D;				
	  }
	}

}

/*____________________________________________________________________*/


void print_output_line(char spec_type[],int i,int ii,int iii,int j,int jj, int jjj,double dist,double nearest_dist,
			double dist_3D, double nearest_dist_3D,int out_flag,int out_flag_3D,int logflag, int use_pdb_flag)

{
	char type_output1[2*MAXATOMNAME+1],type_output2[2*MAXATOMNAME+1],type_output3[2*MAXATOMNAME+1];

	FindIdenticalGroups(i,j,type_output1);

	if (ii<0) /*1-D-spectrum */
	   {
		printf("\n%4s\t%3d\t%9s\t%5.2f\t",protein[i].restype,i,type_output1,
									protein[i].chem_shift[j]);
		if (logflag==TRUE)
			fprintf(biomag_out,"\n%4s\t%3d\t%9s\t%5.2f\t",protein[i].restype,i,type_output1,
									protein[i].chem_shift[j]);
	   }
	else
	  {
 		FindIdenticalGroups(ii,jj,type_output2);

		printf("\n%4s %3d %9s %5.2f ppm |%4s %3d %9s %5.2f ppm | ",protein[i].restype,i,type_output1,
			protein[i].chem_shift[j],protein[ii].restype,ii,type_output2,protein[ii].chem_shift[jj]);

		if (logflag==TRUE)
		   {
			fprintf(biomag_out,"\n%4s %3d %9s %5.2f ppm |",protein[i].restype,
					i,type_output1,protein[i].chem_shift[j]);
			fprintf(biomag_out,"%4s %3d %9s %5.2f ppm | ",protein[ii].restype,ii,type_output2,
					protein[ii].chem_shift[jj]);
		    }


		if (spec_type[0]=='n')      /*in case of a COSY distance-info*/
		    {				/*is not needed*/
			if ((!protein[i].is_PDB[j]) ||(!protein[ii].is_PDB[jj]))
			   {
				printf(" unknown dist |");

				if (logflag) fprintf(biomag_out," unknown dist|");
			   }
			else
			   {
				if (nearest_dist<0) /*no identical group found*/
				   {
					printf("dist    %4.2f A |",dist);
					if (logflag) fprintf(biomag_out,"dist    %4.2f A |",dist);
				   }
				else
				   {
					if (nearest_dist>dist)	/*dist is the smallest*/
						nearest_dist=dist;  /*distance of group*/
					printf("nearest %4.2f A |",nearest_dist);
					if (logflag) fprintf(biomag_out,"nearest %4.2f A |",nearest_dist);
				   }
			   } 
		   }
		else if ((protein[ii].nucleus[jj]=='H')||(protein[i].nucleus[j]=='H'))/*spec_type[0]=='c'*/
		   {
			if (out_flag== LONGRANGE) 
			   {
				printf("allylic |");
				if (logflag) fprintf(biomag_out,"allylic |");
			   }
									
			if (out_flag== GEMINAL) 
			   {
				printf("geminal |");
				if (logflag) fprintf(biomag_out,"geminal |");
			   }
			
/*			if (out_flag==EXCHANGEABLE)
			   {
				printf("exchangeable |");
				if (logflag) fprintf(biomag_out,"exchangeable |");
			   }
*/						
			else /*if (out_flag==TRUE)*/
			   {
				 printf("        |");
				 if (logflag) fprintf(biomag_out,"        |");
			   }
								
		   }
	   if (jjj>=0) /* 3D-spectrum */
		{
		  FindIdenticalGroups(iii,jjj,type_output3);
		  printf("%4s %3d %9s %5.2f ppm | ",protein[iii].restype,iii,type_output3,
			protein[iii].chem_shift[jjj]);

		  if (logflag)
			fprintf(biomag_out,"%4s %3d %9s %5.2f ppm | ",protein[iii].restype,iii,type_output3,
				protein[iii].chem_shift[jjj]);
		  if (spec_type[1]=='n')      /*in case of a COSY distance-info*/
		    {				/*is not needed*/
			if ((!protein[iii].is_PDB[jjj]) ||(!protein[ii].is_PDB[jj]))
			   {
				printf(" unknown dist|");
				if (logflag) fprintf(biomag_out," unknown dist|");
			   }
			else
			   {
				if (nearest_dist_3D<0) /*no identical group found*/
				   {
					printf("dist    %4.2f A",dist_3D);
					if (logflag) fprintf(biomag_out,"dist    %4.2f A",dist_3D);
				   }
				else
				   {
					if (nearest_dist_3D>dist_3D)	/*dist is the smallest*/
						nearest_dist_3D=dist_3D;  /*distance of group*/
					printf("nearest %4.2f A",nearest_dist_3D);
					if (logflag) fprintf(biomag_out,"nearest %4.2f A",nearest_dist_3D);
				   }
			   } 
		    }
		  else if ((protein[ii].nucleus[jj]=='H')||(protein[iii].nucleus[jjj]=='H'))/*spec_type[1]=='c'*/
		    {
			if (out_flag_3D== LONGRANGE) 
			   {
				printf("allylic |");
				if (logflag) fprintf(biomag_out,"allylic |");
			   }
									
			if (out_flag_3D== GEMINAL) 
			   {
				printf("geminal |");
				if (logflag) fprintf(biomag_out,"geminal |");
			   }
			
/*			if (out_flag_3D==EXCHANGEABLE)
			   {
				printf("exchangeable |");
				if (logflag) fprintf(biomag_out,"exchangeable |");
			   }
*/						
			else /*if (out_flag_3D==TRUE)*/
			   {
				 printf("        |");
				 if (logflag) fprintf(biomag_out,"        |");
			   }
		     }
		}
	  }

}

/*____________________________________________________________________*/


void PrintHitList(char spec_type[],int logflag, int use_pdb_flag,short dim)

{
	int ri;

	for (ri=0;((ri<MAXHITS-1) && (hitlist[ri].score>0));ri++)
	  {
		print_output_line(spec_type,hitlist[ri].resid1,hitlist[ri].resid2,hitlist[ri].resid3,hitlist[ri].atom1,
			hitlist[ri].atom2,hitlist[ri].atom3,hitlist[ri].dist,hitlist[ri].nearest_dist,
			hitlist[ri].dist_3D,hitlist[ri].nearest_dist_3D,
			hitlist[ri].outflag,hitlist[ri].outflag_3D,logflag,use_pdb_flag);
		if (dim>1)
		   {
			printf("sc=%3.0f",hitlist[ri].score);
			if (logflag)
				fprintf(biomag_out,"sc=%3.0f",hitlist[ri].score);
		   }
	  }
}   


/*____________________________________________________________________*/

void PrintHitList2(char spec_type[],int logflag, int use_pdb_flag,short dim)

{
	int ri;

	for (ri=0;((ri<MAXHITS-1) && (hitlist2[ri].score>0));ri++)
	  {
		print_output_line(spec_type,hitlist2[ri].resid1,hitlist2[ri].resid2,hitlist2[ri].resid3,hitlist2[ri].atom1,
			hitlist2[ri].atom2,hitlist2[ri].atom3,hitlist2[ri].dist,hitlist2[ri].nearest_dist,
			hitlist2[ri].dist_3D,hitlist2[ri].nearest_dist_3D,
			hitlist2[ri].outflag,hitlist2[ri].outflag_3D,logflag,use_pdb_flag);
		if (dim>1)
		   {
			printf("sc=%3.0f",hitlist2[ri].score);
			if (logflag)
				fprintf(biomag_out,"sc=%3.0f",hitlist2[ri].score);
		   }
	  }
}   


/*____________________________________________________________________*/

void clear_forbidden_matrix_3D()
{
 int ri;
 for(ri=0;ri<MAXATOMTYPE;ri++)
	forbidden_matrix_3D[ri]=FALSE;
}

/*____________________________________________________________________*/

void ForbidIdentical_3D(int res1, int at1)

{
	short ri, comp1ID, res1ID, at1ID;

	res1ID=protein[res1].its_ResConst;

	at1ID=protein[res1].its_AtomConst[at1];

	for (ri=0;ri<=protein[res1].count_atoms;ri++)
	     {
		comp1ID=protein[res1].its_AtomConst[ri];
		if (comp1ID!=0)
		{
	   	   if ((identity[res1ID][comp1ID][at1ID]==SURE) || ((identity[res1ID][comp1ID][at1ID]==MAYBE) &&
						 (protein[res1].chem_shift[at1]==protein[res1].chem_shift[ri]))) 
		   {
			forbidden_matrix_3D[ri]=TRUE;
		   }
		}
	     }

}


/*____________________________________________________________________*/



void main(int argc, char *argv[])

{

	int i,ii,j,jj,iii,jjj;

	int out_flag,log_flag, multi_flag,use_pdb_flag,out_flag_3D,out_flag2_occurred;

	int H_count,ex_H_count, H_PDB_count, H_RBM_count, C_count, C_PDB_count,
				 C_RBM_count, N_count, N_PDB_count, N_RBM_count;

	short available, any_hit;
	
	short H_available=0;

	short C_available=0;

	short N_available=0;

	short pdb_flag, biomag_flag, dim;

	double dist, dist_threshold, ideal_shift[4],dist_3D,nearest_dist_3D;

	double nearest_dist;

	double llim[4],ulim[4],shift1, shift2, shift3;

	char pdb_filename[MAXFILENAME], biomag_filename[MAXFILENAME], buffer[MAXLINE], buffer2[MAXLINE];
       
  	char spec_type[2],list_type[2],add_text[10],print_cmd[64], nuc[5], nucl;

	char version[5];

	strcpy(version,"2.2");


	printf("Program %s version %s is running\n",argv[0],version);

	if (argc>1)
	 {
	  if (strcmp(argv[1],"-h")==0)
	    {
		printf ("\n\nHelp on %s, version %s:",argv[0],version);
		printf ("\n\nUsage: %s [-hrlfpd123] [spectrum-type]",argv[0]);
		printf ("\n\tThe program reads a PDB-file and a file from the BioMagResBank and");
		printf ("\n\tlets you search for specific (cross-)peaks by scanning the two files");
		printf ("\n\tand pre-selecting chemically possible (cross-)peaks.");
		printf ("\n\n\th\tHELP on arguments (as you've found out)");
		printf ("\n\n\tr\tranking of the best found (cross-)peaks will be given\n\t\t(can't be used with 'l')");
		printf ("\n\tl\tlist of possible (cross-)peaks will be given\n\t\t(can't be used with 'r')");
		printf ("\n\n\tf\tlogfile with name 'RBMlog.out' will be generated (this contains");
		printf ("\n\t\tno other information than is given on the screen)");
		printf ("\n\tp\ta logfile with name 'RBMlog.out' will be generated and printed");
		printf ("\n\t\tusing the command given in the file \"RBM_default_printcmd\".");
		printf ("\n\n\td\tthe PDB and BioMagRes-Files, that were used last time,");
		printf ("\n\t\twill be used again (very useful, if you want to investigate");
		printf ("\n\t\tseveral peaks from one spectrum).");
		printf ("\n\n\t1,2,3\tDimension of spectrum.");
		printf ("\n");
		printf ("\n\tThe second argument can be used to specify the spectrum-type.");
		printf ("\n\tIt must give the nucleus for each dimension (in capital letters)");
		printf ("\n\tand the type of magnetization ('c' for COSY-type, 'n' for NOESY-type");
		printf ("\n\tbetween the nuclei. For example: HnHcC determines a H-H-C spectrum with");
		printf ("\n\tNOESY-type magnetization transfer between dimension 1 (1H) and dimension 2 (1H)");
		printf ("\n\tand COSY-type between dimension 2 (1H) and dimension 3 (13C).");
		printf ("\n\n\n");
		exit(0);
	   }
	 }

	initialize_statistic();

	initialize_COSY_Matrix();

	initialize_identity_Matrix();
	
	initialize_protein_matrix();

	clear_forbidden_matrix();

	initialize_hitlist();

	use_pdb_flag=TRUE;

	multi_flag=TRUE;

	out_flag2_occurred=FALSE;

	if (argc>1)
	  {
		if (strchr(argv[1],'d')!=NULL)
		  {
			multi_file=fopen("RBM_default_BMRB","r");
			if (multi_file!=NULL)
			  {
				fgets(biomag_filename,MAXLINE,multi_file);
				fclose(multi_file);
				multi_flag=FALSE;
			  }
			else 
			  {
				printf("\nThe file, that contains the default BioMagRes-File,");
				printf("\n    can't be opened!");
			   }
		  }
	  }

	if (multi_flag)
	  {
		printf("\nInput BIOMAG file name :");

		scanf("%s",biomag_filename);	
		multi_file=fopen("RBM_default_BMRB","w");
		if (multi_file!=NULL)
		  {	
			fprintf(multi_file,"%s",biomag_filename);
			fclose (multi_file);
		  }
	  }

	available=which_nuclei(biomag_filename);
	H_available=available & 1;
	C_available=available & 2;
	N_available=available & 4;

	strcpy(nuc,"    ");
	dim=0;
	if (argc>1)
	  {
		if (strchr(argv[1],'1')!=NULL)
		  dim=1;
		if (strchr(argv[1],'2')!=NULL)
		  dim=2;
		if (strchr(argv[1],'3')!=NULL)
		  dim=3;
	  }
	if (dim!=0)
	   {
		printf("\n%dD-spectrum chosen.",dim);
/*		allow_2nd_arg=TRUE;
*/	   }

	while ((dim!=1)&&(dim!=2)&&(dim!=3))
	   {
		printf("\nHow many dimensions should your spectrum have? (1-3) : ");
		scanf("%s",buffer);
		dim=atoi(buffer);
	   }

	multi_flag=FALSE;
	strcpy(buffer,"    ");
	if (H_available) buffer[1]='H';
	if (C_available) buffer[2]='C';
	if (N_available) buffer[3]='N';
	removechar(buffer,32);

	if (argc>2)
		{
		 multi_flag=TRUE;
		 if (strlen(argv[2])==(2*dim-1))  /*label e*/
		   {
		    if  (strchr(buffer,argv[2][0])!=NULL)  /*label d*/
		     {
			nuc[1]=argv[2][0];
			if (dim>1)
			  {
			     if (strchr("cn",argv[2][1])!=NULL)  /*label c*/
				{
				spec_type[0]=argv[2][1];
				if (strchr(buffer,argv[2][2])!=NULL) /*label b*/
				  {
				   nuc[2]=argv[2][2];
				   if (((nuc[1]!='H')||(nuc[2]!='H'))&&(spec_type[0]=='n'))
					{
					printf("\nWARNING: magnetization transfer between dimension 1 and 2 can");
					printf("\n\tonly be of COSY-type, if other nuclei than 1H are involved!");
					spec_type[0]='c';
					}
				   if (dim>2)
				     {
					if (strchr("cn",argv[2][3])!=NULL) /*label a*/
					  {
					   spec_type[1]=argv[2][3];
					   if (strchr(buffer,argv[2][4])!=NULL)
					     {
						nuc[3]=argv[2][4];
					   	if (((nuc[2]!='H')||(nuc[3]!='H'))&&(spec_type[1]=='n'))
					 	  {
						   printf("\nWARNING: magnetization transfer between dimension 2 and 3 can");
						   printf("\n\tonly be of COSY-type, if other nuclei than 1H are involved!");
					 	   spec_type[1]='c';
	  					  }
					     }
					   else
					      {
						multi_flag=FALSE;
						printf("\nNucleus nr. 3 (%c) from argument#2 is not available!",argv[2][4]);
					      }
					  }  /*END label a*/
					else multi_flag=FALSE;
				     }/*END if (dim>2)*/
				   
				  } /*END label b*/
				else 
				  {
				    multi_flag=FALSE;
				    printf("\nNucleus nr. 2 (%c) from argument#2 is not available!",argv[2][2]);
				  }
				} /*label c*/
			     else
				 multi_flag=FALSE;
			  } /*END if (dim>1) */
		      } /*END label d */
		    else
		 	{
			 multi_flag=FALSE;
			 printf("\nNucleus nr.1 (%c) from argument#2 is not available!",argv[2][0]);
			}
		    } /*label e*/
		else
		  multi_flag=FALSE;

		if (!multi_flag)
			printf("\nThe format of the second argument is not as required!");
		else
		  {
		    add_text[0]=nuc[1];
		    add_text[1]=0;
		    if (dim>1)
			{
			add_text[1]='-';
			add_text[2]=nuc[2];
			add_text[3]=0;
			if (dim>2)
			   {
			   add_text[3]='-';
			   add_text[4]=nuc[3];
			   add_text[5]=0;
			   }
			}
		    printf("\n%dD %s spectrum chosen.",dim,add_text);
		    for (i=1;i<dim;i++)
			{
			if (spec_type[i-1]=='n')
			    strcpy(add_text,"NOESY");
			else
			    strcpy(add_text,"COSY");
			printf("\nMagnetization transfer between dimension %d and %d is of %s-type.",i,i+1,add_text);
		  	}
		  }
	} /*END if argc>2*/

	if ((argc<=2)|| (!multi_flag))
	  {
	  if ((H_available)&&(!C_available)&&(!N_available))
	   {
	    printf("\nOnly 1H available from the BMRB-file! Assigning 1H to all dimensions!");
	    for (i=1;i<=dim;i++)
		nuc[i]='H';
	   }
	  else if ((!H_available)&&(C_available)&&(!N_available))
	   {
	    printf("\nOnly 13C available from the BMRB-file! Assigning 13C to all dimensions!");
	    for (i=1;i<=dim;i++)
		nuc[i]='C';
	   }
	  else if ((!H_available)&&(!C_available)&&(N_available))
	   {
	    printf("\nOnly 15N available from the BMRB-file! Assigning 15N to all dimensions!");
	    for (i=1;i<=dim;i++)
		nuc[i]='N';
	   }
	  else
	   {
	    for (i=1;i<=dim;i++)
	       {
	        while (strchr(buffer,nuc[i])==NULL)
	        {
	         printf("\n\nNucleus for %d. dimension? (available:%s) :",i,buffer);
	         scanf("%s",buffer2);
    	         nuc[i]=buffer2[0];
	         if (nuc[i]=='h') nuc[i]='H';
	         if (nuc[i]=='c') nuc[i]='C';
	         if (nuc[i]=='n') nuc[i]='N';
	        }
	       }
	     }

	  if (dim>1)
	   {
	    for (i=1;i<dim;i++)
	     {
	      if ((nuc[i]=='H') && (nuc[i+1]=='H')) /*when magnetization transfer happens between two protons*/
	       {					 /*COSY and NOESY-type is possible*/
		buffer[0]=' ';
		while (strchr("cnCN",buffer[0])==NULL)
		  {
		   printf("\n\nIs the magnetization transfer between");
		   printf("\n\tdimension %d and %d of COSY or NOESY-type? (c/n) : ",i,i+1);
		   scanf("%s",buffer);
		  }
		if (buffer[0]=='C') buffer[0]='c';
		if (buffer[0]=='N') buffer[0]='n';
		spec_type[i-1]=buffer[0];
	       }
	      else spec_type[i-1]='c';  /*for heteronuclei, only COSY-type-spectra are possible*/
	     }/*endFOR*/
	   }
 	 } /*END if ((argc<=2)||(!multi_flag)) */
	
	if (strchr(spec_type,'n')!=NULL)
	  {
		multi_flag=TRUE;

		if (argc>1)
	  	  {
			if (strchr(argv[1],'d')!=NULL)
		 	 {
				multi_file=fopen("RBM_default_PDB","r");
				if (multi_file!=NULL)
				  {
					fgets(pdb_filename,MAXLINE,multi_file);
					fclose(multi_file);
					multi_flag=FALSE;
				  }
				else 
				  {
					printf("\nThe file, that contains the default PDB-File,");
					printf("\n    can't be opened!");
				   }
			  }
		  }

		if (multi_flag)
		  {
			printf("\n");

			printf("\nInput PDB file name (enter \"0\", if you wish to work with \n");
			printf("      BioMagRes-Files only) : ");

			scanf("%s",pdb_filename);	

			multi_file=fopen("RBM_default_PDB","w");
			if (multi_file!=NULL)
			  {	
				fprintf(multi_file,"%s",pdb_filename);
				fclose (multi_file);
			  }
		  }
	
		if (strcmp(pdb_filename, "0")==0)
			use_pdb_flag=FALSE;

		if (use_pdb_flag)
		   {
			pdb_flag=read_pdb(pdb_filename);

			if (pdb_flag<0) 
		  	  {
				printf("\nWARNING: Cannot open %s\n",pdb_filename);
				use_pdb_flag=FALSE;
			  }
			if (use_pdb_flag)
		 	   printf("\nPDB File %s read",pdb_filename);
			else
			   printf("\nNo PDB-File is used.");

		   }
	  }

	else
	  use_pdb_flag=FALSE;

/*Check for unusual combinations*/
	if (dim==3)
		if ((nuc[1]==nuc[2])&&(nuc[2]==nuc[3])&&(nuc[1]!='H') ) /*CCC or NNN*/
			printf("\nWARNING! You have chosen a very unusual combination of nuclei! I hope it's O.K.");
	if (((nuc[1]==nuc[2])||(nuc[2]==nuc[3]))&& (nuc[2]=='N')) /*any combination of NN*/
		printf("\nWARNING! You have chosen a very unusual combination of nuclei! I hope it's O.K.");

	

	multi_file=fopen("RBM_default_printcmd","r");
	if (multi_file !=NULL)
	  {
		fgets(print_cmd,MAXLINE,multi_file);
		fclose(multi_file);
	  }
	else
	  {
		printf("\n\n*************************************************************************");
		printf("\n* You have not yet specified a default print command, \"lp\" will be used!*");
		printf("\n* You should generate a text file named: \"RBM_default_printcmd\". ,      *");
		printf("\n* that contains your print command in the first line!                   *");
		printf("\n*************************************************************************\n");
		strcpy(print_cmd,"lp");
	  }
	removechar (print_cmd,'*'); /*to avoid bad surprises */
	removechar (print_cmd,'?');
	while (TRUE)
	 {	
	      if (argc>1)  /*must catch the case that no arguments are given! Otherwise CRASH!*/
               {
		if ((strchr(argv[1],'f')==NULL) && (strchr(argv[1],'p')==NULL))
		 {
		  printf("\n\nDo you want a logfile written (will be named 'RBMlog.out')? (y/n) : ");
		  scanf("%s",buffer);
		 }
	     	else
		 {
		  printf("\nLogfile will be generated");
		  if (strchr(argv[1],'p')!=NULL)
			printf(" and printed");
		  printf(".");
		  strcpy(buffer,"y");
		 }
	        }
	       else
		 {
		  printf("\n\nDo you want a logfile written (will be named 'RBMlog.out')? (y/n) : ");
		  scanf("%s",buffer);
		 }
	       if ((buffer[0]=='y') || (buffer[0]=='Y'))
		  {
			log_flag=TRUE;
			biomag_out=fopen("RBMlog.out","w");
			fprintf(biomag_out,"\n\nLogfile of program %s version %s",argv[0],version);
			fprintf(biomag_out,"\n\nBIOMAG File is %s",biomag_filename);
			if (use_pdb_flag)
		 	   fprintf(biomag_out,"\nPDB File is %s",pdb_filename);
			else
			   fprintf(biomag_out,"\nNo PDB-File is used.");
			fprintf(biomag_out,"\n\n%d-D- ",dim);
			for (i=1;i<=dim;i++)
			    fprintf(biomag_out,"%c ",nuc[i]);
			fprintf(biomag_out,"- spectrum is chosen.\n");
			for (i=1;i<dim;i++)
			  {
			    fprintf(biomag_out,"\tDimension %d -> %d (nuclei %c -> %c) magnetization transfer is of ",
						i,i+1,nuc[i],nuc[i+1]);
			    if (spec_type[i-1]=='n')
				fprintf(biomag_out,"NOESY-type.\n");
			    else
				fprintf(biomag_out,"COSY-type.\n");
			  }
		         
			break;
		  }
		else if ((buffer[0]=='n') || (buffer[0]=='N'))
		  {
			log_flag=FALSE;
			break;
		  }
		else
			printf ("Type 'y' or 'n' !");
	 }


	biomag_flag=read_biomag(biomag_filename, use_pdb_flag,log_flag);

	if (biomag_flag<0) 
		{
			printf("\nCannot open %s\n",biomag_filename);
			exit(-1);
		}
	printf("\nBIOMAG File %s read\n",biomag_filename);

  	strcpy(add_text," ");
	if (dim>1)
		strcat(add_text,"cross-");

	while(TRUE)
	{
	   if (argc>1)  /*must catch the case that no arguments are given! Otherwise CRASH!*/
            {
	    if ((strchr(argv[1],'r')==NULL) && (strchr(argv[1],'l')==NULL))
	      {
		printf("\nDo you like: - a list of possible%speaks within a shift-range  (l)",add_text);
		printf("\n         or  - a ordered list of the best hits for a certain%speak?  (r)",add_text);
		printf("\n(l/r) : ");
		scanf("%s",list_type);
	      }
	    else if (strchr(argv[1],'r')!=NULL)
	      {
		printf("\nOrdered list of the best hits for a certain%speak chosen.",add_text);
		list_type[0]='r';
	      }
	    else /* (strchr(argv[1],'l')!=NULL) */
	      {
		printf("\nList of all possible%speaks within a shift-range chosen.",add_text);
		list_type[0]='l';
	      }
	    }
	   else
	      {
		printf("\nDo you like: - a list of possible%speaks within a shift-range  (l)",add_text);
		printf("\n         or  - a ordered list of the best hits for a certain%speak?  (r)",add_text);
		printf("\n(l/r) : ");
		scanf("%s",list_type);
	      }

	   if ((list_type[0] == 'l') || (list_type[0] == 'L'))
	      {
		list_type[0]='l';
		if (log_flag) fprintf(biomag_out,"\n\nlist of possible%speaks within a shift-range chosen.",add_text);
		break;
	      }
	   else if ((list_type[0] == 'r') || (list_type[0] == 'R'))
	      {
		list_type[0]='r';
		if (log_flag) fprintf(biomag_out,"\n\nordered list of best hits for a certain%speaks chosen.",add_text);
		break;
	      }
	   else
		printf("\nEnter 'l' or 'r' !");
	}

	if ((spec_type[0]=='n') && (list_type[0]=='l') && use_pdb_flag)
	   {
  		printf("\nInput distance threshold : ");
		scanf("%lf",&dist_threshold);
		if (log_flag) fprintf(biomag_out,"\n\nDistance threshold: %5.2f Angstrom",dist_threshold);
	   }

	printf("\nInput first dimension (nucleus %c) chem shift ",nuc[1]);
	if (log_flag) fprintf(biomag_out,"\nFirst Dimension (nucleus %c) chem shift ",nuc[1]);
	
	if (list_type[0]=='l')
	   {
		printf("lower limit : ");
		if (log_flag) fprintf(biomag_out,"range : ");
	   }
	else /*list_type[0]=='r'*/
	   {
		printf(": ");
		if (log_flag) fprintf(biomag_out,": ");
	   }
	scanf("%lf",&llim[1]);
	
	if (log_flag) fprintf(biomag_out,"%5.2f ppm",llim[1]);

	if (list_type[0]=='l')
	   {
		printf("\nInput %c - chem shift upper limit : ",nuc[1]);
		scanf("%lf",&ulim[1]);
		if (log_flag) fprintf(biomag_out," < x < %5.2f ppm",ulim[1]);
	   }

        if (dim>1)
	  {
	    for (i=2;i<=dim;i++)
	     {
		nucl=nuc[i];
		if (i==2) strcpy(add_text,"second ");
		else strcpy(add_text,"third ");
		printf("\nInput %sdimension (nucleus %c) chem shift ",add_text,nucl);
		if (log_flag) fprintf(biomag_out,"\n%sdimension (nucleus %c) chem shift ",add_text,nucl);

		if (list_type[0]=='l')
		   {
			printf("lower limit : ");
			if (log_flag) fprintf(biomag_out,"range : ");
		   }
		else /*list_type[0]=='r'*/
		   {
			printf(": ");
			if (log_flag) fprintf(biomag_out,": ");
		   }

		scanf("%lf",&llim[i]);

		if (log_flag) fprintf(biomag_out,"%5.2f ppm",llim[i]);

		if (list_type[0]=='l')
		   {
			multi_flag=FALSE;
			while (!multi_flag)
			  {
			  printf("\nInput %sdimension (nucleus %c) chem shift upper limit : ",add_text,nucl);
			  scanf("%lf",&ulim[i]);
			  if (ulim[i]<=llim[i])
				printf("WARNING: upper limit must be higher than lower limit!");
			  else
				multi_flag=TRUE;
			  }
			if (log_flag) fprintf(biomag_out," < x < %5.2f ppm",ulim[i]);
		   }
	       }
	   }

	printf("\n");
/* printf("Reached point 11.\n"); */
	if (log_flag) fprintf(biomag_out,"\n");

	if (list_type[0]=='r')
	   {				/*define a scanning-range within to look for cross-peaks for the hitlist*/
	    for (i=1;i<=dim;i++)
	      {
		ideal_shift[i]=llim[i];
		if (nuc[i]=='H') dist=0.15;
		if (nuc[i]=='C') dist=3.5;
		if (nuc[i]=='N') dist=3.5;		
		llim[i]=llim[i]-dist;
		ulim[i]=llim[i]+2*dist;
	      }
	    dist_threshold=8;
	    for (i=1;i<dim;i++)
	      {
		if (nuc[i]==nuc[i+1])
		  {
		   if ((llim[i+1]<=ulim[i])&&(ideal_shift[i+1]>ideal_shift[i]))  /*overlapping shift-ranges for same nucleus*/
			{							/*in two dimensions causes problems with ranking*/
			llim[i+1]=(ideal_shift[i]+ideal_shift[i+1])/2;
			ulim[i]=llim[i+1]-0.001;
			}
		   if ((ulim[i+1]>llim[i])&&(ideal_shift[i+1]<ideal_shift[i]))
			{
			llim[i]=(ideal_shift[i]+ideal_shift[i+1])/2;
			ulim[i+1]=llim[i]-0.001;
			}
		  }
	      }
	   }
/* for (i=1;i<=dim;i++)
	printf("\nShift range %d: %f - %f ppm",i,llim[i],ulim[i]);
*/	
/* printf("Reached point 12.\n"); */
/* for debugging only: (writes the complete data in memory to a file) */
debug_out=fopen("test.dat","w");
for (i=0;i<=count_residues;i++)
	{ 
	fprintf(debug_out,"\n\nResidue %d %s____________________",i,protein[i].restype);
	for (j=0;j<=protein[i].count_atoms;j++)
		fprintf(debug_out,"\nAtom %2d Type %4s BM-type %4s, shift %f (x/y/z)=(%4.1f/%4.1f/%4.1f),isbio:%d, isPDB:%d, isDupl:%d, nuc:%c",
		  j,protein[i].atomtype[j],protein[i].biomag_atomtype[j],protein[i].chem_shift[j],
		  protein[i].xcor[j],protein[i].ycor[j],protein[i].zcor[j],protein[i].is_biomag[j],protein[i].is_PDB[j],
			protein[i].is_duplicate[j],protein[i].nucleus[j]);
        }
fclose(debug_out); 

/*printf("\n              012345");
printf("\nnuclei field: %s",nuc);
*/
/* printf("Reached point 13. Nores=%d\n",count_residues); */
	for (i=0;i<=count_residues;i++)				
	   { 
		protein[i].its_ResConst=GetResConst(i);
		for (j=0;j<=protein[i].count_atoms;j++)		
		   protein[i].its_AtomConst[j]=GetAtomConst(i,j);
	   }
/* printf("Reached point 14.\n"); */
	
	for (i=0;i<=count_residues;i++)				
	{ 
                clear_forbidden_matrix();
/* printf("Reached point 15. Current res=%d.\n",i); */

		for (j=0;j<=protein[i].count_atoms;j++)		
		{	
  		   if ((protein[i].is_biomag[j]==OK) && (protein[i].nucleus[j]==nuc[1])) 
		    {
			shift1=protein[i].chem_shift[j];			

			if ((llim[1]<=shift1) && (ulim[1]>=shift1)) 
			{
			  if (dim==1)   /* 1D-spectrum*/
		 	    {
				if (!forbidden_matrix[j][0][0])
				   {
					if (list_type[0]=='l')
						print_output_line("11",i,-1,-1, j,-1,-1,-1,-1,-1,-1,-1,-1,log_flag,-1);
					else /*if (list_type[0]=='r') */
						NewHit("11",i,-1,-1,j,-1,-1,-1,-1,-1,-1,-1,-1,-1,dim,ideal_shift);

			  		ForbidIdentical(i,-1,j,0); /* -1 to tell routine, that only 1D-info is required */
				   }
			     }
			  else
			   {
/* printf("\nCame to point 1a.");
 */				
			    for (ii=1;ii<=count_residues;ii++)	   /* RW < -> <=  */ 
			     {
			     if ((spec_type[0]!='c') || (i==ii) || (i==ii+1) || (i==ii-1))  /*in case of a COSY-spectrum this loop shall be executed
								only, if i=ii (because COSY-crosspeaks can only be observed
								between atoms belonging to the same residue, except in some cases (HNCO, HNCA, where sequential
								cosy-type peaks can occur */   /*1.91*/
			      {
				for (jj=0;jj<=protein[ii].count_atoms;jj++)  /* RW < -> <=  */
					{
					     if ((protein[ii].is_biomag[jj]==OK)&&(protein[ii].nucleus[jj]==nuc[2])&&
									(identity_check(i,j,ii,jj)!=SURE) &&
									(!forbidden_matrix[j][ii][jj]))
					     {
						 shift2=protein[ii].chem_shift[jj];
/*printf("\nCame to point 1b.");
*/
						if ((llim[2]<=shift2) && (ulim[2]>=shift2) && 
							((shift1 != shift2) || (nuc[1]!=nuc[2])))
						{	 /*changed < to <= and > to >=*/       /*crosspeaks
 								between atoms with same chemical shift cannot be observed*/

							out_flag=FALSE;
							out_flag_3D=FALSE; /*1.91*/

							if (spec_type[0]=='n')
							  {
							    if (((!protein[i].is_PDB[j]) ||	/*if atoms not in PDB*/
								(!protein[ii].is_PDB[jj])) ||	/*or no PDB-file is used*/
								(!use_pdb_flag))		/*mark them for output*/										
								{
								out_flag=2;
								out_flag2_occurred=TRUE;
								}
							    else
							      {
								dist = CalcDistance(i,ii,j,jj);

							    	if ((dist<dist_threshold)&& (dist!=0))
								
									out_flag=TRUE;
							      }
							   }
							else  /*spec_type[0]=='c'*/
							  {
/*printf("\nCame to point 1c.");
*/							     out_flag=check_COSY(i,j,ii,jj);	/*1.91*/
							     /*printf("\nFor atom %d and %d of Res. %d COSYMatrix shows %d.",
									j,jj,i,out_flag);  only for debugging! */
							  }

							if (out_flag!=FALSE)
							 {
							  if ((spec_type[0]=='n') && (out_flag!=2))
			    				      nearest_dist=ScanIdenticalGroup(i,ii,j,jj);
							  if (dim==2)
 							   {
/*printf("\nCame to point 2.");
*/							    if (list_type[0]=='l')
							      {
								print_output_line(spec_type,i,ii,-1,j,jj,-1,dist,
										nearest_dist,-1,-1,out_flag,-1,log_flag,
										use_pdb_flag);
							      }
							    else /*if (list_type[0]=='r') */
							      {
								NewHit(spec_type,i,ii,-1,j,jj,-1,dist,
										nearest_dist,-1,-1,out_flag,-1,use_pdb_flag,
										dim,ideal_shift);
/*printf("\nCame to point 3.");
*/							      }
							    ForbidIdentical(i,ii,j,jj);
							   }
							 

							  else /*(dim==3)*/

{
   any_hit=FALSE;
		/*  printf("\n atom pair:%s Res. %d | %s of Res. %d checking for interaction with: .",
						protein[i].biomag_atomtype[j],i,protein[ii].biomag_atomtype[jj],ii); only for debugging! */

   for (iii=1;iii<=count_residues;iii++)
     {
		/* printf("res %d \t",iii); */
	out_flag_3D=FALSE;
	clear_forbidden_matrix_3D();
	if ((spec_type[1]!='c') || (ii==iii) || (ii==iii+1) || (ii==iii-1))
          {
	  for (jjj=0;jjj<=protein[iii].count_atoms;jjj++) 	
	    {
		/* if ((i==77) && (ii==77))
		 {
		printf("\n\t res 77 | 77 | %d checking...",iii);
		printf("\n\t\t with atom %s %d: is_biomag=%d, nuc=%c, matches with nuc: %d, identity check: %d, forbidden_matrix: %d, if-statement: %d" 				,protein[iii].biomag_atomtype[jjj],iii,protein[iii].is_biomag[jjj],protein[iii].nucleus[jjj],protein[iii].nucleus[jjj]==nuc[3], 					identity_check(ii,jj,iii,jjj),forbidden_matrix_3D[jjj],((protein[iii].is_biomag[jjj]==OK)&&(protein[iii].nucleus[jjj]==nuc[3])&&
		(identity_check(ii,jj,iii,jjj)!=SURE) &&(!forbidden_matrix_3D[jjj])));
		 } */
	     if ((protein[iii].is_biomag[jjj]==OK)&&(protein[iii].nucleus[jjj]==nuc[3])&&
		(identity_check(ii,jj,iii,jjj)!=SURE) &&(!forbidden_matrix_3D[jjj]))
	      {
		shift3=protein[iii].chem_shift[jjj];
				/* printf("\n\t atom %s %d with shift %6.1f",protein[iii].biomag_atomtype[jjj],iii,shift3); */
		if ((llim[3]<=shift3) && (ulim[3]>=shift3) && ((shift3 != shift2) || (nuc[3]!=nuc[2])))
		  {
		    out_flag_3D=FALSE;
				/* printf("..shift matches between %6.1f and %6.1f",llim[3],ulim[3]); */
		    if (spec_type[1]=='n')
		      {
			if (((!protein[ii].is_PDB[jj]) ||	/*if atoms not in PDB*/
				(!protein[iii].is_PDB[jjj])) ||	/*mark them for output*/
				(!use_pdb_flag))		/*i*/
								/*no PDB-file is used*/
				{
				out_flag_3D=2;
				
				out_flag2_occurred=TRUE;
				}
			  else
			  	{
			  	  dist_3D = CalcDistance(iii,ii,jjj,jj);

			  	  if ((dist_3D<dist_threshold)&& (dist_3D!=0))
				     {
/*printf("\n\t atom %d and %d of Res. %d distance is %5.2f.",
						jj,jjj,ii,dist_3D);  only for debugging! */
								
				     out_flag_3D=TRUE;
				
				     }
				}
			}
		    else
			{
		 	  out_flag_3D=check_COSY(ii,jj,iii,jjj);  /*1.91*/
			 			/*  printf("\n\t %s %d | %s %d : COSYMatrix = %d.",
						protein[ii].biomag_atomtype[jj],ii,protein[iii].biomag_atomtype[jjj],iii,out_flag_3D); only for debugging! */
			}
		    if (out_flag_3D !=FALSE)
		      {
			if ((spec_type[1]=='n') && (out_flag_3D!=2)) /*1.91*/
			    	nearest_dist_3D=ScanIdenticalGroup(ii,iii,jj,jjj);

			if (list_type[0]=='l')
			  {
				print_output_line(spec_type,i,ii,iii,j,jj,jjj,dist,
					nearest_dist,dist_3D,nearest_dist_3D,out_flag,out_flag_3D,log_flag,use_pdb_flag);
			  }
			else /*if (list_type[0]=='r') */
			  {
				NewHit(spec_type,i,ii,iii,j,jj,jjj,dist,nearest_dist,dist_3D,nearest_dist_3D,out_flag,
				out_flag_3D,use_pdb_flag,dim,ideal_shift);
			  }
			ForbidIdentical_3D(iii,jjj);
			any_hit=TRUE;
		      }
		  }
	      }	   
	   }
	}/*end if ((spec_type[1]!='c') || (ii==iii) )*/
     }/*endFOR iii*/
    if (any_hit)
		ForbidIdentical(i,ii,j,jj);

}
			

							 }/*end IF (out_flag!=FALSE) */

						}
					  }
					}
				  }
				}
			    }
			}
		  }
		}

		

	}
	if (list_type[0]=='r')
	  {
		if (use_pdb_flag) 
			{
			printf("\nPossible cross peaks from atoms in the PDB:\n"); 
			if (log_flag) fprintf(biomag_out,"\nPossible cross peaks from atoms in the PDB:\n");
			}
		PrintHitList(spec_type,log_flag, use_pdb_flag,dim);
		if (use_pdb_flag) 
		 {
			printf("\n\nPossible cross peaks from atoms NOT in the PDB:\n"); 
			if (log_flag) fprintf(biomag_out,"\n\nPossible cross peaks from atoms NOT in the PDB:\n");
			
		if (out_flag2_occurred)
		   {
		    PrintHitList2(spec_type,log_flag, use_pdb_flag,dim);
		   }
		  else printf("\nNone.");
		  }
		}
		H_count=0;
		ex_H_count=0;
		H_PDB_count=0;
		H_RBM_count=0;
		C_count=0;
		C_PDB_count=0;
		C_RBM_count=0;
		N_count=0;
		N_PDB_count=0;
		N_RBM_count=0;

		for (i=1;i<=count_residues;i++)				
  		   { 
		    if ((protein[i].its_ResConst>0)&&(protein[i].its_ResConst<MAXTYPE))
		      {
			H_count=H_count+statistic[protein[i].its_ResConst].H_tot;
			N_count=N_count+statistic[protein[i].its_ResConst].N;
			C_count=C_count+statistic[protein[i].its_ResConst].C;
			ex_H_count=ex_H_count+statistic[protein[i].its_ResConst].ex_H;
			
			for (j=0;j<=protein[i].count_atoms;j++)		
			 {
			  if (!protein[i].is_duplicate[j])
			    {
			     if (protein[i].is_PDB[j])
				{
				 nucl=protein[i].atomtype[j][0]; /*the first letter contains either 1,2,3 or the atom symbol*/
				 if (strchr("123",nucl)!=NULL)	/*if the first letter is a number, then the second letter*/
					 nucl=protein[i].atomtype[j][1];	/*contains the atom-symbol*/
				 if (nucl=='H')
					{
					H_PDB_count++;
					if (protein[i].is_biomag[j])
					   H_RBM_count++;
					}
				 else if (nucl=='C')
					{
					C_PDB_count++;
					if (protein[i].is_biomag[j])
					   C_RBM_count++;
					}
				 else if (nucl=='N') 
					{
					N_PDB_count++;
					if (protein[i].is_biomag[j])
					   N_RBM_count++;
					}
				}
			     else if (protein[i].is_biomag[j])
				{
				 if (protein[i].nucleus[j]=='H')
				  {
			   	   H_RBM_count++;
				  }
				 else if (protein[i].nucleus[j]=='C')
				  {
			   	   C_RBM_count++;
				  }
				 else /*if (protein[i].nucleus[j]=='H'))*/
				  {
			   	   N_RBM_count++;
				  }
				}				    
			     }
			  }
			}
		    }
		if (H_available)
		  {
		   H_count=H_count+2; /*C-terminal and N-terminal*/
		   ex_H_count=ex_H_count+2;
		   printf("\n\nData statistics for 1H (from available residues!):");
		   printf("\n\tThe molecule contains %d 1H-nuclei",H_count);
		   printf("\n\t\tof which %d are exchangeable.",ex_H_count);
		   if (use_pdb_flag)
		   	printf("\n\t%d protons are in the PDB-file",H_PDB_count);
		   printf("\n\tand %d are in the BioMagRes-file.",H_RBM_count);		
		   if (log_flag==TRUE)
		     {
			fprintf(biomag_out,"\n\nData statistics for 1H (from available residues!):");
			fprintf(biomag_out,"\n\tThe molecule contains %d 1H-nuclei",H_count);
			fprintf(biomag_out,"\n\t\tof which %d are exchangeable.",ex_H_count);
		   	if (use_pdb_flag)
				fprintf(biomag_out,"\n\t%d protons are in the PDB-file",H_PDB_count);
			fprintf(biomag_out,"\n\tand %d are in the BioMagRes-file.",H_RBM_count);				
		     }
		  }
		if (C_available)
		  {
		   printf("\n\nData statistics for 13C (from available residues!):");
		   printf("\n\tThe molecule contains %d 13C-nuclei",C_count);
		   if (use_pdb_flag)
			   printf("\n\t\tof which %d are in the PDB-file",C_PDB_count);
		   printf("\n\t\tand %d are in the BioMagRes-file.",C_RBM_count);		
		   if (log_flag==TRUE)
		     {
			fprintf(biomag_out,"\n\nData statistics for 13C (from available residues!):");
			fprintf(biomag_out,"\n\tThe molecule contains %d 13C-nuclei",C_count);
			if (use_pdb_flag)
				fprintf(biomag_out,"\n\t\tof which %d are in the PDB-file",C_PDB_count);
			fprintf(biomag_out,"\n\t\tand %d are in the BioMagRes-file.",C_RBM_count);				
		     }
		  }
		if (N_available)
		  {
		   printf("\n\nData statistics for 15N (from available residues!):");
		   printf("\n\tThe molecule contains %d 15N-nuclei",N_count);
		   if (use_pdb_flag)
			   printf("\n\t\tof which %d are in the PDB-file",N_PDB_count);
		   printf("\n\t\tand %d are in the BioMagRes-file.",N_RBM_count);		
		   if (log_flag==TRUE)
		     {
			fprintf(biomag_out,"\n\nData statistics for 15N (from available residues!):");
			fprintf(biomag_out,"\n\tThe molecule contains %d 15N-nuclei",N_count);
			if (use_pdb_flag)
				fprintf(biomag_out,"\n\t\tof which %d are in the PDB-file",N_PDB_count);
			fprintf(biomag_out,"\n\t\tand %d are in the BioMagRes-file.",N_RBM_count);				
		    }
		  }

	if (log_flag==TRUE) 
	   {
	      fclose(biomag_out);
	      
	      if (argc>1)
		{
		if (strchr(argv[1],'p')==NULL)
		   {
			printf("\n\nDo you want the logfile printed? (y/n) : ");
			scanf("%s",spec_type);
		   }
		else
		   {
			printf ("\n\nPrinting the logfile with command %s",print_cmd);
			spec_type[0]='y';
		   }
		}
	      else
		   {
			printf("\n\nDo you want the logfile printed? (y/n) : ");
			scanf("%s",spec_type);
		   }

	      if ((spec_type[0]=='y') || (spec_type[0]=='Y')) system(print_cmd);
	   }

  printf("\nEnd of Program\n\n");
}



