function status = LACS(filename)
% LACS read NMR star file and give reference offsets for all backbone
% chemical shifts.
%
% Liya Wang, 01/28/3009

warning off
[pathstr, name, ext, versn] = fileparts(filename);
addpath(pathstr);
ca=0; cb=0; ha=0; co=0; nh=0; hn=0;
warning off
S2txt(filename);

if ~exist(strcat('cs', name), 'file')
    status = 0;
    warning('Chemical shift data is not available or not sufficient for offset estimation!');
    return;
else
    status = 1;
end

fid = fopen(strcat(name, '_LACS.out'), 'w');
fprintf(fid, '%s\n', '          #################################');
fprintf(fid, '%s\n', '          #    LACS Output Information    #');
fprintf(fid, '%s\n', '          #################################');
fprintf(fid, '%s\n', '');
fprintf(fid, '%s\n', ' ############################################################');
fprintf(fid, '%s\n', ' #              LACS Designator Definition                  #');
fprintf(fid, '%s\n', ' #                                                          #');
fprintf(fid, '%s\n', ' #   Index Value                    Definition              #');
fprintf(fid, '%s\n', ' #                                                          #');
fprintf(fid, '%s\n', ' #          0                        Outliers               #');
fprintf(fid, '%s\n', ' #          1                      Normal points            #');
fprintf(fid, '%s\n', ' #          2                   End points for line 1       #');
fprintf(fid, '%s\n', ' #          3                   End points for line 2       #');
fprintf(fid, '%s\n', ' #                                                          #'); 
fprintf(fid, '%s\n', ' ############################################################');            
fprintf(fid, '%s\n', ' ');
fprintf(fid, '%s\n', ' loop_');
fprintf(fid, '%s\n', '     _LACS.Residue_seq_code');
fprintf(fid, '%s\n', '     _LACS.Residue_label');
fprintf(fid, '%s\n', '     _LACS.Atom_name');
fprintf(fid, '%s\n', '     _LACS.X_Coord_name');
fprintf(fid, '%s\n', '     _LACS.Y_Coord_name');
fprintf(fid, '%s\n', '     _LACS.X_Coord_val');
fprintf(fid, '%s\n', '     _LACS.Y_Coord_val');
fprintf(fid, '%s\n', '     _LACS.Designator');
fprintf(fid, '%s\n', '');
fclose(fid);

ca = ord(name, 2);
cb = ord(name, 3);
ha = ord(name, 4);
co = ord(name, 5);

hn = ordN(name, 6);
n = ordN(name, 7);

fid = fopen(strcat(name, '_LACS.out'), 'a');
fprintf(fid, '\n %s\n', 'stop_')
fclose(fid);

fid = fopen(strcat(name, '_LACS_offsets.out'), 'w');
fprintf(fid, '%s\n', '%   CA     CB     HA     CO     HN      N');
if ca > -100, fprintf(fid, ' %5.2f ', ca); else,  fprintf(fid, ' %s ', ' ----'); end
if cb > -100, fprintf(fid, ' %5.2f ', cb); else,  fprintf(fid, ' %s ', ' ----'); end
if ha > -100, fprintf(fid, ' %5.2f ', ha); else,  fprintf(fid, ' %s ', ' ----'); end
if co > -100, fprintf(fid, ' %5.2f ', co); else,  fprintf(fid, ' %s ', ' ----'); end
if hn > -100, fprintf(fid, ' %5.2f ', hn); else,  fprintf(fid, ' %s ', ' ----'); end
if n  > -100, fprintf(fid, ' %5.2f ',  n); else,  fprintf(fid, ' %s ', ' ----'); end
fclose(fid);

delete(strcat('cs', name));
rmpath(pathstr);

return;
