function [S pH] = start2S(filename)
% Read in bmrb entry in string format and extract chemical shift information.
% This function calls txt2mat to get a cell format copy S.
%
% Liya Wang, 01/24/2009

s = urlread(strcat('file:', filename));

[s1 f1] = regexp(s, 'pH');


if length(f1) < 1
    S = []; pH = '7';
    return;
end

i = 1;
while 1
    pH = strtok(s(f1(i)+1 : f1(i)+min(100, length(s)-f1(i))));
    if length(str2num(pH)) > 0 | i > length(f1)-1
        break;        
    end
    i = i + 1;
end
        
if length(pH) < 1
    pH = '7';
end

if nargin < 1, error('No input');  end

% get chemical shifts
[start finish] = regexp(s, '_Chem_shift_ambiguity_code[^(stop)]*stop_');
N = length(start);
k = 1;
if length(start) < 1
S = []; pH = '7';
    return;
end
    
for i = 1 : 1
    cs = s(start(i):finish(i));
    [id, bid] = regexp(cs, '_Chem_shift_ambiguity_code[\n]*');
    [eid, id] = regexp(cs, '[\n][\s]*stop_');
    css{i} = cs(bid+1:eid);
    [tst, tid] = regexp(css{i}, '[A-Z]{3}'); % verify whether it is protein or not(DNA or RNA)
    if length(tst) > 0
        S{k} = txt2mat(cs(bid+1:eid), k);
        k = k + 1;
    end              
end
if ~exist('S', 'var'), S = []; end

return