##header.awk
  

#!/bin/sh  -x
echo "" 
echo "" 
echo "   Enter amino-acid sequence (1-letter code) filename:" 
echo -n ">> " 
read input 
echo "" 
echo "** Using file $input" 
echo "" 
echo "" 
echo "" 
nawk 'BEGIN { 
       r_lngth=8 
       n=1 
       } 
{ 
       printf "#\n" 
       printf "# The original sequence entered was:\n" 
       printf "# %s\n",$1
       printf "#\n"
       printf "\n"
       printf "\n"
       printf "# Expressed in NMR-STAR, this sequence is:\n"
       printf "\n"
       printf "_Mol_residue_sequence\n"
       printf ";\n"
       len=r_lngth/20
       len++
       for (i=1 ; i<=len ; i++)
       {
          printf "%s\n",substr($1,n,20)
          n=n+20
       }
       printf ";\n"
       printf "\n"
       printf "loop_\n"
       printf "        _Residue_seq_code\n"
       printf "        _Residue_author_seq_code\n"
       printf "        _Residue_label\n"
       printf "\n"
        n=1
       for (i=1 ; i<=r_lngth ; i++)
       {
          a=substr($1,n,1)
          if (a=="G") {aa[i]="GLY"}
          if (a=="A") {aa[i]="ALA"}
          if (a=="V") {aa[i]="VAL"}
          if (a=="L") {aa[i]="LEU"}
          if (a=="I") {aa[i]="ILE"}
          if (a=="M") {aa[i]="MET"}
          if (a=="P") {aa[i]="PRO"}
          if (a=="W") {aa[i]="TRP"}
          if (a=="F") {aa[i]="PHE"}
          if (a=="Y") {aa[i]="TYR"}
          if (a=="S") {aa[i]="SER"}
          if (a=="C") {aa[i]="CYS"}
          if (a=="T") {aa[i]="THR"}
          if (a=="Q") {aa[i]="GLN"}
          if (a=="N") {aa[i]="ASN"}
          if (a=="D") {aa[i]="ASP"}
          if (a=="E") {aa[i]="GLU"}
          if (a=="H") {aa[i]="HIS"}
          if (a=="R") {aa[i]="ARG"}
          if (a=="K") {aa[i]="LYS"}
          num[i]=n
          n=n+1
       }
       for (i=1 ; i<=r_lngth ; i++)
       {
printf "%1.0f   @   %3s 	%1.0f   @   %3s 	%1.0f   @   %3s 	%1.0f   @   %3s 	%1.0f   @   %-3s\n",num[i],aa[i],num[i+1],aa[i+1],num[i+2],aa[i+2],num[i+3],aa[i+3],num[i+4],aa[i+4] 
           i=i+4
       }
       printf "\n"
       printf "\n"
       printf "stop_\n"
       printf "\n"
       printf "###################################################################\n"
       printf "#      Chemical Shift Ambiguity Code Definitions                  #\n"
       printf "#                                                                 #\n"
       printf "#    Codes            Definition                                  #\n"
       printf "#                                                                 #\n"
       printf "#      1             Unique                                       #\n"
       printf "#      2             Ambiguity of geminal atoms or geminal methyl #\n"
       printf "#                         proton groups                           #\n"
       printf "#      3             Aromatic atoms on opposite sides of the ring #\n"
       printf "#                        (e.g. Tyr HE1 and HE2 protons)           #\n"
       printf "#      4             Intraresidue ambiguities (e.g. Lys HG and    #\n"
       printf "#                         HD protons)                             #\n"
       printf "#      5             Interresidue ambiguities (Lys 12 vs. Lys 27) #\n"
       printf "#      9             Ambiguous, specific ambiguity not defined    #\n"
       printf "#                                                                 #\n"
       printf "###################################################################\n"
       printf "\n"
       printf "\n"
       printf "# INSTRUCTIONS\n"
       printf "# 1) Replace the @-signs with appropriate values.\n"
       printf "# 2) Text comments concerning the assignments can be\n"
       printf "#    supplied in the full deposition.\n"
       printf "# 3) Feel free to add or delete rows to the table as needed.\n"
       printf "#    The row numbers (_Atom-shift_assign_ID values) will be\n"
       printf "#    re-assigned to sequential values by BMRB\n"
       printf "\n"
       printf "\n"
       printf "# The atom table chosen for this sequence is:\n"
       printf "\n"
       printf "loop_\n"
       printf "     _Atom-shift_assign_ID\n"
       printf "     _Residue_seq_code\n"
       printf "     _Residue_label\n"
       printf "     _Atom_name\n"
       printf "     _Atom_type\n"
       printf "     _Chem_shift_value\n" 
       printf "     _Chem_shift_value_error\n" 
       printf "     _Chem_shift_ambiguity_code\n" 
       printf "\n" 
       printf "#\n" 
       printf "#Atom   Residue\n" 
       printf "#shift  Seq     Residue Atom    Atom    Shift/  Error/  Ambiguity\n"
       printf "#assign code    Label   Name    Type    ppm     ppm     Code\n" 
       printf "#---------------------------------------------------------------\n" 
       printf "#\n" 
       printf "\n" 
       printf "\n" 
}' < $input > header 
