#include "cnmrlib.h"



main(argc,argv)
int argc;
char **argv;
{  FILE *fo; 
   static char col_t[50][6],delimiter='\t';
   static int maxnonothers,nress=0,col_n[50];

   fo=stdout;
   if( argc<=1 ) {
fprintf(fo,"\n___________________________________________________________(C) Victor Jaravine ");
fprintf(fo,"\n%s -     Utility to convert  BMRB file to  chem. shifts table ;\n",argv[0]);
fprintf(fo,"\nUSAGE:   %s bmrbfile > outfile \n\n",argv[0]);
fprintf(fo,"bmrbfile - file taken from BMRB \n");
fprintf(fo,"BMRB = BioMagResBank\n");
fprintf(fo,"\n\n");
fprintf(fo,"----------\n");
fprintf(fo,"This program is provided 'as is' and in principle is not supported.\n");
fprintf(fo,"However, bug reports and suggestions are generally wellcome. My address is\n");
fprintf(fo,"\n");
fprintf(fo,"Victor A. Jaravine, Dr\n");
fprintf(fo,"Dept. of Structural Biology, BIOZENTRUM, Basel university\n");
fprintf(fo,"Klingelbergstr. 70, BASEL CH-4056, Switzerland\n");
fprintf(fo,"tel: +41-61-2672106, fax: +41-61-2672109\n");
fprintf(fo,"email: Victor.Jaravine@unibas.ch\n");
fprintf(fo,"\n");
    exit(0);
                };
             

   init_cnmrlib();
   /*fo=Fopen("bmrb2tab.out","w");*/


  
  /***************** READ BMRB  ****************************************/
  if(argc>=2)
  {  FILE *f;
     int i,ns,start,ipB;

     
     f=Fopen( argv[1],"r");if( f==NULL) return(-1);
     pBc=&currentBMRBitem;
     start=0; ipB=0;

     /* get line from bmrb file */
     for(i=1; NULL!= fgets(line,MAXLINE,f); )
     { static char rname[6],word[512]; 
       if( line[0]=='#' ) {fprintf(errout,"%s",line);continue;};
       ns= sscanf(line,"%s",&word[0]);
   

       /* print some header information */
       if( start==12 || start==22 || start==32 ) printf("#%s",line);
       if( strstr(line,"_Citation_full")!=NULL || strstr(line,"_Entry_title")!=NULL) start=11;
       if( line[0]==';' && start==12 ) start=0;
       if( line[0]==';' && start==11 ) start=12;
       if( strstr(line,"_Data_value_count")!=NULL 
           || strstr(line,"_Data_type_number")!=NULL
           || strstr(line,"_Indirect_shift_ratio")!=NULL
           || strstr(line,"_Variable_value_units")!=NULL)  start=21;
       if( line[0]=='\n' && start==22 ) start=0;
       if( line[0]=='\n' && start==21 ) start=22;
       if( line[0]=='\n' && start==32 ) start=0;
       if( strstr(line,"_Name_common")  !=NULL || strstr(line,"_Name_variant") !=NULL || 
           strstr(line,"_Database_name")!=NULL  ) start=32,printf("#%s",line);

       /* get assignment data */  
       if(strcmp(word,"save_assigned_chemical_shifts_one")==0) start=100;
       if(strcmp(word,"stop_")==0) start=102; 


       if( start==101 ) 
        {     /*fprintf(errout,"%s",line);*/
              ns= sscanf(line,"%d%d%s%s%s%f%*s%d",
                  &pBc->i, &pBc->n, rname, pBc->aname, pBc->atype ,
                  &pBc->cs, /*&pBc->err,*/ &pBc->amb_code );
              if( ns < 5 ) continue;
              strncpy(pBc->rname3,strupper(rname),4);
              if(0)
              { fprintf(errout,"%-5d%-5d%-5s%-5s%-3s%9.3f%3d\n",
                pBc->i, pBc->n, pBc->rname3, pBc->aname, pBc->atype ,
                pBc->cs, /*pBc->err,*/ pBc->amb_code);
              };
              if( ns!=7 )  continue; /* take only data */
              pB=&bmrb_items[ipB++];
              memcpy( pB, pBc, sizeof(BMRB_ITEM)); 
        };
        if(strcmp(word,"_Chem_shift_ambiguity_code")==0) start=101; 
        i++;
     };
     fclose(f);
     nBMRBitems=ipB;
  };
  /*****************  end of READ BMRB  ****************************************/
  /*****************  PREPARE CS HEADER   ****************************************/
  /* prepare header line */
  {   int i,k,j,ic,iic;
      NAME_NUM_ITEM *p,*pn,tmpni;
      /* get statistics on anames */
      nstatnames=0;
      for(k=0;k<MAXSTATNAMES;k++)
      { p= &statnames[k]; p->i=0;
      };
      for(i=0; i<nBMRBitems; i++) 
      {   static int found;
          pB=&bmrb_items[i];
          /*if(pB->n==bmrb_items[1].n) continue;*/ /* skip first residue - maybe it's not typical */
          for(k=0,found=0;k<nstatnames;k++)
          {  p= &statnames[k];
             if(strncmp(p->name,pB->aname,4)==0) {found=1; p->i++; break;};
          };
          if(found==0) strncpy(statnames[ nstatnames++ ].name,pB->aname,4);
          if((i+1)<=nBMRBitems) if(bmrb_items[i].n!=bmrb_items[i+1].n) nress++;
      };
      /* sort statnames */
      for(k=0;k<nstatnames;k++)
      for(j=1;j<nstatnames;j++)
      { p = &statnames[j-1];
        pn= &statnames[j];
        if(pn->i > p->i) 
        { memcpy( &tmpni,  p, sizeof(NAME_NUM_ITEM)); 
          memcpy(      p, pn, sizeof(NAME_NUM_ITEM));
          memcpy( pn, &tmpni, sizeof(NAME_NUM_ITEM));
        };
      };
      for(k=0;k<nstatnames;k++)
      { p= &statnames[k];
        fprintf(errout,"#  [%s,%d]  \n",p->name,p->i+1);
      };
 
      /* prepare col_t */
      ic=0;
      for(k=0;k<nstatnames;k++)
      { static int found;
        p= &statnames[k];
        for(iic=0,found=0;iic<ic;iic++) 
        {    if(strncmp(p->name,col_t[iic],4)==0) 
             { found=1; col_n[iic]++; break; 
             };
        };
        if(found==0 && p->i>= nress/4 ) strncpy(col_t[ic++],p->name,4); 
      };
      maxnonothers=ic;
      /* sort col_t by col_n numbers - more to left */
      for(iic=1;iic<maxnonothers;iic++) 
      for(ic=1;ic<maxnonothers;ic++) 
      { {  static char c1,c2,tmps[32];
           static int i1,i2,tmpi;
           i1=col_n[ic]; i2=col_n[ic+1];
           if( i1<i2 )
           {  strcpy(tmps,col_t[ic]); strcpy(col_t[ic],col_t[ic+1]); strcpy(col_t[ic+1],tmps);
              tmpi=col_n[ic]; col_n[ic]=col_n[ic+1]; col_n[ic+1]=tmpi;
           };
      };};

      fprintf(fo,"ResNum%c",delimiter);
      for(ic=0;ic<maxnonothers;ic++) fprintf(fo,"%s%c",col_t[ic],delimiter);
      fprintf(fo,"Others\n");
  };
  /*****************  end of PREPARE CS HEADER   ****************************************/
  /*****************  print CS  ****************************************/
  {  int i,ns,nr,nr_next,ic,j,empty,ipB;
     char others_line[1024],tmpbuf[128],resnum[32];

      /* filling buf[j] according to col_t[ic]; or others_line */
      /* init bufs */for(j=0;j<maxnonothers;j++) buf[j][0]=0; 
      others_line[0]=0; resnum[0]=0; 

      for(ipB=0; ipB<nBMRBitems; ipB++)
      {  static int i3i,found;
         pB =&bmrb_items[ipB  ];   i3i=get_rname3i(pB->rname3);
         pBc=&bmrb_items[ipB+1];   
         if((ipB+1)==(nBMRBitems)) nr_next=0,pBc=NULL; else nr_next=pBc->n; 
         nr=pB->n; 
         { fprintf(errout,"%-5d%-5d%-5s%-5s%3d%-3s%9.3f%3d\n",
           pB->i, pB->n, pB->rname3, pB->aname, i3i, pB->atype ,
           pB->cs, /*pB->err,*/ pB->amb_code);
         };

         /* collect pB to bufs */
         prt25=&rtab25[ i3i ];
         if( pB->cs>13 ) sprintf(tmpbuf,"%.2f",pB->cs);
         else            sprintf(tmpbuf,"%.3f",pB->cs);
         /* get col_t for this atom */
         for(ic=0,found=0;ic<maxnonothers;ic++)  /* find col_t */
         {  if( strcmp(col_t[ic],pB->aname)==0 
                || (strncmp(pB->aname,"HA",2)==0 && strncmp(col_t[ic],pB->aname,2)==0) 
              ) 
              {found=1;break; };
         };
         if( found==1 ) 
         {  if(buf[ic][0]==0) empty=1; else empty=0;
            if(!empty) strcat(buf[ic],",");
            strcat(buf[ic],tmpbuf);
         } else 
         {  strcat(others_line,pB->aname);
            strcat(others_line,":");
            strcat(others_line,tmpbuf);
            strcat(others_line,";");
         };

         if( nr_next!= nr || pBc==NULL)  /* new res name appeared or last res */
         {   sprintf(resnum,"%1s%-3d",prt25->rname1,nr); 
             fprintf(fo,"%s%c",resnum,delimiter);
             for(j=0;j<maxnonothers;j++) 
             {   if(buf[j][0]!=0) fprintf(fo,"%s%c",buf[j],delimiter); 
                 else fprintf(fo,"-%c",delimiter);
             };
             fprintf(fo,"%s\n",others_line);
             /* init bufs for next res */
             for(j=0;j<maxnonothers;j++) buf[j][0]=0; others_line[0]=0; 
         };

      };/*ipB*/

  };
  /*****************  end of print CS  ****************************************/


   fclose(fo);
   close_cnmrlib();
   return(0);
}



#include "cnmrlib.c"


