/*
printf("----------\n");
printf("This program is provided 'as is' and in principle is not supported.\n");
printf("However, bug reports and suggestions are generally wellcome. My address is\n");
printf("\n");
printf("Victor A. Jaravine, Dr\n");
printf("Dept. of Structural Biology, BIOZENTRUM, Basel university\n");
printf("Klingelbergstr. 70, BASEL CH-4056, Switzerland\n");
printf("tel: +41-61-2672106, fax: +41-61-2672109\n");
printf("email: Victor.Jaravine@unibas.ch\n");
printf("\n");
*/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <ctype.h>
#define MAXN  5000
#define POW2(x)         ((x)*(x))
#define MODULE(x,y,z)   (sqrt((x)*(x)+(y)*(y)+(z)*(z)))
#define DISTANCE(x1,y1,z1,x2,y2,z2) (MODULE((x1)-(x2),(y1)-(y2),(z1)-(z2)))
char line[1024],option[512];
float num[MAXN];
#define NPOS    12   
#define SIZEPOS 32 
char *buf[NPOS];

main(argc,argv)
int argc;
char **argv;
{ int j; 
  for(j=0; j<NPOS; j++) buf[j]= (char*)malloc(SIZEPOS);


 option[1]=0;
 if(argc>1) strcpy(option,argv[1]); 
 switch( option[1] )
 { 
     default:printf("\n___________________________________________________________(C) Victor Jaravine ");
	     printf("\ncalc        -        Utility to calc something\n");
             printf("\nUsage: calc what \n");
             printf("\nWhat: ");
	     printf("\n average infile [pos skip]              # aver. stdev. min.max. (pos starting with 0)");
             printf("\n power     PowerOld PulseOld PulseNew   # PowerNew ");
             printf("\n pulse     PulseOld PowerOld PowerNew   # PulseNew ");
             printf("\n h2o       temp                         # chem.shift.h2o ");
             printf("\n phi       CChncah                      # coupl.constant HNCAH");
             printf("\n CAR       sfo1 sfo2 sfo3 HCAR          # CAR for N15 C13 from CAR H1");
             printf("\n\n\n");
     break;
   case 'A': 
             {/* calc N15 CAR  */
	      double sfo3,sfo2,sfo1,sfo30,sfo20,NCAR,HCAR,CCAR,Cg,Ng;
              Cg=(double)0.251449530;
              Ng=(double)0.101329118;
	      sfo1=(double)atof(argv[2]);
	      sfo2=(double)atof(argv[3]);
	      sfo3=(double)atof(argv[4]);
	      HCAR=(double)atof(argv[5]);
	      sfo20=(sfo1-HCAR*sfo1*(1.0e-6))*Ng;
	      sfo30=(sfo1-HCAR*sfo1*(1.0e-6))*Cg;
	      NCAR=(sfo2-sfo20)*(1.0e6)/sfo20;
	      CCAR=(sfo3-sfo30)*(1.0e6)/sfo30;
	      printf(" N15_CAR=%8.3f C13_CAR=%8.3f H1_CAR=%6.3f # SFO20=%10.6f SFO30=%10.6f \n",
                        NCAR,CCAR,HCAR,sfo20,sfo30);
             /* printf("\n N15_CAR=%8.3f C13_CAR=%8.3f H1_CAR=%6.3f # SFO20=%10.6f SFO30=%10.6f # sfo1=%10.6f sfo2=%10.6f sfo3=%10.6f \n", NCAR,CCAR,HCAR,sfo20,sfo30,sfo1,sfo2,sfo3);  */
	     };
     break;
  case 'h':{/* calc PHI from CC HncaH */ 
	      static float a=6.51,b=(-1.76),c=1.60,J,phi1,phi2,p,D;
	      J=atof(argv[2]);
              p=b/(2.0*a);  D=p*p - (c-J)/a; if(D<0) {printf("\nCChnha= %6.2f nD< 0 0 0 0 0 ",J);exit(-1);};
              /* this setup gives two solutions : for phi range [-115:60] */
              phi2=60.0 -  (180.0/3.14159)* acos( (-p) - sqrt(D) );
              /* phi2   [-115:-20]  is more usefull  */
              phi1=60.0 -  (180.0/3.14159)* acos( (-p) + sqrt(D) );
              /* phi1   [-20: 60]    */
	      printf("\nCChnha= %6.2f  PHI1=%10.3f  PHI2=%10.3f ",J,phi1,phi2);
	     };
     break;
   case '2':{/* calc H2O chem.shift  */
	      float cs,temp;
	      temp=atof(argv[2])+273.0;
	      cs=7.83 - (temp/96.9); 
	      printf("\n H2O Chem.shift, T=%-6.1f K\n %10.3f \n",temp,cs);
	     };
     break;
   case 'u':{/* calc pulse length */
	     float PowerOld,PulseOld,PulseNew,PowerNew;
	      PulseOld=atof(argv[2]);
	      PowerOld=atof(argv[3]);
	      PowerNew=atof(argv[4]);
	      PulseNew=PulseOld*pow(10.0, (PowerNew-PowerOld)/20.0 );
	      printf("\n Pulse: \n%-8.3f %8.2f(dB)    \t\t old: %-8.2f %8.2f(dB) \n",
	       PulseNew,PowerNew,PulseOld,PowerOld);
	    };
     break;
   case 'o':{/* calc power level */
	     float PowerOld,PulseOld,PulseNew,PowerNew;
	      PowerOld=atof(argv[2]);
	      PulseOld=atof(argv[3]);
	      PulseNew=atof(argv[4]);
	      PowerNew=PowerOld + 20.0*log10(PulseNew/PulseOld);
	      printf("\n Power: \n%8.3f(dB) %-8.2f    \t\t old: %8.2f(dB) %-8.2f \n",
	       PowerNew,PulseNew,PowerOld,PulseOld);
	    };
     break;
   case 'v':{/* calc average */
	     FILE *f;   int i,j,ns,nn; float sum,sum2,mean,dev;
             float max,min; int pos,skip;
	     f=fopen(argv[2],"r"); if( f==NULL ) {printf("file %s not found\n",argv[2]); abort();};
	     pos=0; skip=0;
	     if(argc>3) pos=atoi(argv[3]);
	     if(argc>4) skip=atoi(argv[4]);
/* printf("argc=%d pos=%d skip=%d \n",argc,pos,skip);
*/
             for(i=0,j=0; NULL!=fgets(line,1024,f); i++ )
             {  /*if(line[0]=='#') continue;*/
                if( i<skip) continue;
		ns=sscanf(line,"%s%s%s%s%s%s%s%s%s%s%s%s",
                buf[0],buf[1],buf[2],buf[3],buf[4],buf[5],buf[6],buf[7],buf[8],buf[9],buf[10],buf[11]); 
                if( !(pos<ns)         ) continue;
	        num[j]=atof(buf[pos]);
/*printf("num[j]=%E buf[pos]=%s ns=%d buf[pos][0]=%c  #%s ",num[j],buf[pos],ns,buf[pos][0],line);
   printf("pos=%d ns=%d buf=%s  line=%s",pos,ns,buf[pos],line);
*/
                j++;
             };
             nn=j;
             for(sum=0.0,max=-1.0e20,min=1.0e20,j=0;j<nn;j++)
             { sum+=num[j];
               if( num[j]>=max ) max=num[j];
               if( num[j]<=min ) min=num[j];
             };
             mean=sum/(float)nn;
             for(sum2=0.0,j=0;j<nn;j++)
             { sum2+=POW2( mean-num[j] );
             };
             dev= sqrt( sum2/(float)nn );
             printf(" %12.3e  %12.3e	 #mean+stdev_and_#min=%g max=%g N=(%d)\n",mean,dev,min,max,nn);
             fclose(f);
	    };
     break;
 };
 return(0);
}

