#define MAIN
#define _SEQ1_ 201
#define _SEQ3_ 202
#define _ALLno_ 203

#include "cnmrlib.h"

int printatomshift();
int read_seq();

static float pH=7.0;
static int numcs=0;
static int pos=-1;
static int flagcorr=1;
static int flagheader=1;
float sum,average;



main(argc,argv)
int argc;
char **argv;
{  FILE *ft,*fx,*fa;  int i;
   char satomtype[8]; int atomtype;

   if( argc<=1 ) {
printf("\n___________________________________________________________(C) Victor Jaravine ");
printf("\n%s -     Utility to calc random coil chem. shifts ;",argv[0]);
printf("\n Ref: D.S.Wishart, et al. 1H,13C and 15N random coil NMR chemical shifts of the common amino acids. ");
printf(" I.Investigation of nearest-neighbor effects. J.Biomol.NMR, 5 (1995) 67-81. ");
printf("\n Sequence correction made using shifts of GGx_A : 'x'  amino acid when followed by Ala  ");            
printf("\n Ref: Braun D,Wider G,Wutrich K. Sequence-corrected 15N \"random coil\" chemical shifts. J.A.Chem.Soc.1994,116,8466-8469.");
printf("\nThe shifts are referenced to: 1H,13C - internal DSS ; 15N - external NH3 at t=25C pH=5.0 ");

printf("\n\n\nUSAGE:   %s  seqfile  [atom|ALL|seq1|seq3]  [pos] [pH]\n\n",argv[0]);
printf("seqfile  - file with sequence. Residue names must be in one colomn, ");
printf("number after the name for any line is read, the numbers for next lines are incremented if missing\n");
printf("example:\n");
printf("LYS 2\n");
printf("MET\n");
printf("Also a line of 1 letter res code can be read, e.g.:\n");
printf("MKKVIATKVLGTVKWFNVRNGYGFINRNDTKEDVFVHQTAIKKNNPRKYLRSVGDGETVEFDVVEGEKGAEAANVTGPG\n");
printf("\n");
printf("Parameters is square brackets [] are optional (no brackets needed if they are present).\n");
printf("atom|ALL|ALLnocorr - default is ALL; atom is one from the list: N,HN,HA,HB2,HB3,CO,CA,CB  \n");
printf("ALLnocorr  make no sequence correction, just r.c. from the table. \n");
printf("using lower 'all' or 'allnocorr' prints no header (ok?). \n");
printf("\n");
printf("seq1 or seq3  -  print sequence in 1 or 3 letter code.\n");
printf("pos - print also a number 'pos' colomn from 'seqfile' and difference to it (used for chemical shift comparison).\n");
printf("pH - value [7.0 default] - not implemented yet\n");
printf("If there is a need to shift some predicted values by constants  \n");
printf("it can be done by editing file calc_cs.rc in your work directory.\n");
printf("\n\n");
printf("----------\n");
printf("This program is provided 'as is' and in principle is not supported.\n");
printf("However, bug reports and suggestions are generally wellcome. My address is\n");
printf("\n");
printf("Victor A. Jaravine, Dr\n");
printf("Dept. of Structural Biology, BIOZENTRUM, Basel university\n");
printf("Klingelbergstr. 70, BASEL CH-4056, Switzerland\n");
printf("tel: +41-61-2672106, fax: +41-61-2672109\n");
printf("email: Victor.Jaravine@unibas.ch\n");
printf("\n");
                exit(0);
                };
             
  init_cnmrlib();

  /***************** READ pH & SEQ ****************************************/
  atomtype=_ALL_;
  if(argc>=3) 
  {     if( strncmp("all",argv[2],3)==0 ) flagheader=-1; 
        strcpy(satomtype,strupper(argv[2])); 
        if( strcmp(satomtype,"ALL")==0 ) atomtype=_ALL_;
        if( strncmp(satomtype,"ALLNO",4)==0 ) atomtype=_ALLno_,flagcorr=0;
        if( strcmp(satomtype,"N")==0   ) atomtype=_N_;
        if( strcmp(satomtype,"HN" )==0 ) atomtype=_Hn_;
        if( strcmp(satomtype,"HA" )==0 ) atomtype=_Ha_;
        if( strcmp(satomtype,"HB2")==0 ) atomtype=_Hb2_;
        if( strcmp(satomtype,"HB3")==0 ) atomtype=_Hb3_;
        if( strcmp(satomtype,"CO" )==0 ) atomtype=_CO_;
        if( strcmp(satomtype,"CA" )==0 ) atomtype=_Ca_;
        if( strcmp(satomtype,"CB" )==0 ) atomtype=_Cb_;
        if( strcmp(satomtype,"AAVAL")==0 ) atomtype=_AAVAL_;
        if( strcmp(satomtype,"SEQ1")==0 ) atomtype=_SEQ1_;
        if( strcmp(satomtype,"SEQ3")==0 ) atomtype=_SEQ3_;
  };
  if(argc>=4) pos=atoi(argv[3]);
  if(argc>=5) pH =atof(argv[4]);


  /***************** OUTPUT CS ****************************************/
  if(argc>=2)
  {  int i; float sumaaval;
     
     if( read_seq(argv[1])==(-1) ) return(-1);

     if(flagheader == 1)
     switch(atomtype)
     { case _ALLno_: 
       case _ALL_:  
             for(i=0;i<=2;i++) printf("%s\n",comments[i]);
             printf("# '%s'  satom=%s %d pos=%d pH=%-4.1f \n",argv[1],satomtype,atomtype,pos,pH);
             printf("#%sres\tno\tN\tHN\tHA\tHB2\tHB3\tCO\tCA\tCB\n",cs_ref_line);
	    break;
       case _AAVAL_: printf("#res %3s \n",satomtype);
	    break;
       case _SEQ1_: 
            printf("\n");
	    break;
       case _SEQ3_: printf("#res %3s \n",satomtype);
	    break;
       default: 
           for(i=0;i<=2;i++) printf("%s\n",comments[i]);
           printf("# '%s'  satom=%s %d pos=%d pH=%-4.1f \n",argv[1],satomtype,atomtype,pos,pH);
           printf("#res %3s CSpred\tCSact\tCSdiff\n",satomtype);
	    break;
     };
     /* i res */ 
     for(i=0,sum=0.0,sumaaval=0.0; i<nseq; i++)
     { RESLIB_TAB *p;					 
       p=get_restab_item(1,seq[i].rname1);
       switch(atomtype)
       { case _ALLno_: 
         case _ALL_:
            printf("%1s\t%d\t",seq[i].rname1,seq[i].n);
            printatomshift(i,_N_);
            printatomshift(i,_Hn_);
            printatomshift(i,_Ha_);
            printatomshift(i,_Hb2_);
            printatomshift(i,_Hb3_);
            printatomshift(i,_CO_);
            printatomshift(i,_Ca_);
            printatomshift(i,_Cb_);
            printf("\n");
	    break;
	 case _AAVAL_: 
            printf("%1s\t%d\t",seq[i].rname1,seq[i].n);
            printf("\t%#.2f",p->aaval); sumaaval+=p->aaval;
            printf("\n");
	    break;
	 case _SEQ1_: printf("%c",seq[i].rname1[0]);
	    break;
	 case _SEQ3_: 
            printf("%1s\t%d\t",seq[i].rname1,seq[i].n);
            printf("%s\t",seq[i].rname3);
            printf("\n");
	    break;
         default:
            printf("%1s\t%d\t",seq[i].rname1,seq[i].n);
	    printatomshift(i,atomtype); 
            printf("\n");
	    break;
       };

     };
     if(atomtype==_AAVAL_) printf("# Saaval= %.3f , Aaaval=%.3f \n",sumaaval,sumaaval/nseq);
  };
  /*****************  ****************************************/

  if(numcs!=0) average= sum/(float)numcs; else average=0.0;
  if(pos!=(-1)) printf("#%s: average delta_cs: %7.3f  \n",argv[1], average); 
  printf("\n");
   return(0);


}


int read_seq(file)  /* read sequence file  */
char *file;
{ FILE *f; 
  int i,resnum; char buf1[MAXLINE*4];
  RESLIB_TAB *p;

  f=Fopen( file,"r");if( f==NULL) return(-1);

  for(i=0,resnum=0; NULL!= fgets(line,MAXLINE,f); )
  { int j,k,ns,lens,len1,len2;
    if( line[0]=='#' ||  !isalpha(line[0]) || strlen(line)==0 ) continue; 

    for(j=0;j<=10;j++) buf[j][0]=0;
    ns=sscanf(line,"%s%s%s%s%s%s%s%s%s%s",buf[1],buf[2],buf[3],buf[4],buf[5],buf[6],buf[7],buf[8],buf[9],buf[10]); 
    strcpy(buf1,buf[1]);
    if( ns==0 ) continue; 
    /*
    printf("%3d %s %s %s %s %s %s %s %s %s %s\n",ns,buf[1],buf[2],buf[3],buf[4],buf[5],buf[6],buf[7],buf[8],buf[9],buf[10]); 
     */
    lens=strlen(line);
    len1=strlen(buf1);

    /* in colomn */
    if( len1>0 && len1<=7 )
    {  seq[i].i=i; 
       /* set res name */
       /* A*/  if( isalpha(buf1[0]) && !isalpha(buf1[1]) ) 
               {  strncpy( seq[i].rname1,strupper(buf1),1);
                  p=get_restab_item(1,strupper(buf1));
                  strncpy( seq[i].rname3,p->rname3,3);
               };
       /* AAA*/if( isalpha(buf1[0]) && isalpha(buf1[1]) && isalpha(buf1[2])  )
               {  strncpy( seq[i].rname3,strupper(buf1),3);
                  p=get_restab_item(3,strupper(buf1));
                  strncpy( seq[i].rname1,p->rname1,1);
               };
       /* set res number  */  strcat(buf1,buf[2]);
       /* position to digit */ 
       for(k=0;k<(len2=strlen(buf1));k++) if(isdigit(buf1[k])) break;
       if( k<len2 ) seq[i].n=atof( &buf1[k] ); else seq[i].n= seq[i-1].n+1;

       /* pos */
       if(pos>=2 && pos<=10 && pos<=ns ) strncpy( seq[i].string,buf[pos],16);
       i++;
    };
    /* one letters string in line */
    if( len1>7 )
    {  for(j=0;j<len1;j++) 
       {  seq[i].i=i; 
          strncpy( seq[i].rname1,strupper(&buf1[j]),1); 
	  if(i!=0) seq[i].n= seq[i-1].n+1; else seq[i].n=1;
          p=get_restab_item(1,seq[i].rname1);
	  strncpy( seq[i].rname3,p->rname3,3);
          i++;
       };
    };
  };
  nseq=i;
  fclose(f);
  /*printf("read seq finished : '%d' lines stored \n",nseq);*/
  return(i);
}




int printatomshift(i,atomtype)
int i;
int atomtype;
{
     float delta,value,cscorr; 
     float cs,dcs;
     X_ALA_TAB *px_;
     XALA__TAB *pa_,*pr_;
       if(i!=0) pa_ =get_xala__item (3,seq[i-1].rname3); else pa_=NULL;
                px_ =get_x_ala_item (3,seq[i  ].rname3);
                pr_ =&cs_ref_shifts; dcs=0.0;
       switch(atomtype)
       { case _N_   :  cs=px_->N  ; dcs=(pa_!=NULL? pa_->dN   : 0.0); dcs+= pr_->dN  ; break;
         case _Hn_  :  cs=px_->Hn ; dcs=(pa_!=NULL? pa_->dHn  : 0.0); dcs+= pr_->dHn ; break;
         case _Ha_  :  cs=px_->Ha ; dcs=(pa_!=NULL? pa_->dHa  : 0.0); dcs+= pr_->dHa ; break;
         case _Hb2_ :  cs=px_->Hb2; dcs=(pa_!=NULL? pa_->dHb2 : 0.0); dcs+= pr_->dHb2; break;
         case _Hb3_ :  cs=px_->Hb3; dcs=(pa_!=NULL? pa_->dHb3 : 0.0); dcs+= pr_->dHb3; break;
         case _CO_  :  cs=px_->CO ; dcs=(pa_!=NULL? pa_->dCO  : 0.0); dcs+= pr_->dCO ; break;
         case _Ca_  :  cs=px_->Ca ; dcs=(pa_!=NULL? pa_->dCa  : 0.0); dcs+= pr_->dCa ; break;
         case _Cb_  :  cs=px_->Cb ; dcs=(pa_!=NULL? pa_->dCb  : 0.0); dcs+= pr_->dCb ; break;
         default: cs=999.99; dcs=0.0; break;
       };
       if( fabs(cs)> 0.0) 
       {  cscorr=cs + dcs*flagcorr; 
          if( cscorr>9.99 ) printf("%#.1f\t",cscorr);
          else              printf("%#.2f\t",cscorr);
          if( pos!= 0 && isdigit(seq[i].string[0]) ) 
          {  numcs++; value=atof(seq[i].string); delta=cscorr-value;  sum+=delta;
             if( cscorr>9.99 ) printf("%#.1f\t%#.1f\t",value,delta);   
             else              printf("%#.2f\t%#.2f\t",value,delta);
          };
       } else printf("-1\t");
 return(0);
}



#include "cnmrlib.c"

/* EOF calc_cs.c */
