/*** cnmrlib.c    */





int init_cnmrlib()
{ int i;
  
  /* init basic files */
  errout=fopen("errout.tmp","w");

  /***************** INIT BUFFERS  ****************************************/
  for(i=0; i<NBUFS; i++)
  {  buf[i]= (char*)malloc(512);
     tab[i]= (char*)malloc(200);
     tax[i]= (char*)malloc(200);
     col[i]= (char*)malloc(64);
  };
  for(i=0; i<NCOMMENTS; i++)
  {  comments[i]= (char*)malloc(512);
  };


  /***************** READ RESLIB_TAB ****************************************/
  {  int j,i,ns,ntab; RESLIB_TAB *p;
     j=0;
     strcpy(tab[j++],"#Nam 1   pKR   Type RQatom Afree Natom AAval");
     strcpy(tab[j++],"ALA  A   *     H0   ****   120.71  5   0.52  ");
     strcpy(tab[j++],"ARG  R  12.48  P+   _CZ_   247.53 11   0.61  ");
     strcpy(tab[j++],"ASN  N   *     P0   ****   167.53  8   0.79  ");
     strcpy(tab[j++],"ASP  D   3.86  P-   _CG_   151.52  8   0.77  ");
     strcpy(tab[j++],"CYS  C  10.78  P0   ****   139.68  8   1.12  ");
     strcpy(tab[j++],"GLN  Q   *     P0   ****   181.93  9   0.86  ");
     strcpy(tab[j++],"GLU  E   4.25  P-   _CD_   171.02  9   0.76  ");
     strcpy(tab[j++],"GLY  G   *     P0   ****    79.11  4   0.56  ");
     strcpy(tab[j++],"HIS  H   6.00  P+   _NE2   202.82 10   0.94  ");
     strcpy(tab[j++],"ILE  I   *     H0   ****   182.62  8   0.65  ");
     strcpy(tab[j++],"LEU  L   *     H0   ****   199.81  8   0.58  ");
     strcpy(tab[j++],"LYS  K  10.53  P+   _NZ_   225.26  9   0.81  ");
     strcpy(tab[j++],"MET  M   *     H0   ****   197.40  8   1.25  ");
     strcpy(tab[j++],"PHE  F   *     H0   ****   219.36 11   0.86  ");
     strcpy(tab[j++],"PRO  P   *     H0   ****   125.02  7   0.60  ");
     strcpy(tab[j++],"SER  S   *     P0   ****   134.86  7   0.64  ");
     strcpy(tab[j++],"THR  T   *     P0   ****   135.84  7   0.55  ");
     strcpy(tab[j++],"TRP  W   *     H0   ****   241.16 14   1.82  ");
     strcpy(tab[j++],"TYR  Y  10.07  P0   ****   216.11 12   0.98  ");
     strcpy(tab[j++],"VAL  V   *     H0   ****   182.90  7   0.54  ");
     strcpy(tab[j++],"NTR  +   6.50  P+   _N__     *     *   *   ");
     strcpy(tab[j++],"CTR  -   3.00  P-   _C__     *     *   *   ");
     strcpy(tab[j++],"HOH  0   *     P0   ****   100.00  1   *   ");
     strcpy(tab[j++],"ACE  1   *     *    ****     *     3   *   ");
     strcpy(tab[j++],"N-M  2   *     *    ****     *     *   *   ");
     strcpy(tab[j++],"PMS  X   *     *    ****     *     *   *   ");
     ntab=j;
     /*printf("%d ntab items\n",ntab);*/
     for(j=0,i=1; j<ntab; j++)
     {  strcpy(str,tab[j]);
	if( str[0]=='#' ) continue;
 
        
        ns=sscanf(str,"%s%s%s%s%s%s%s%s%s%s%s",buf[0],buf[1],buf[2],buf[3],buf[4],buf[5],buf[6],buf[7],buf[8],buf[9],buf[10]);
        if(ns < 2 )continue;
        p=&rtab[i];
        strcpy(p->rname3, strupper(buf[0]));
        strcpy(p->rname1, strupper(buf[1]));  p->i=(int)p->rname1 - (int)'A';
        if( isdigit(      buf[2][0]) ) p->pKR   =atof(buf[2]);  else p->pKR=0.0;
        strcpy(p->Type,   buf[3]);
        strcpy(p->RQatom, buf[4]);
        if( isdigit(      buf[5][0]) ) p->Afree =atof(buf[5]);  else p->Afree=0.0;
        if( isdigit(      buf[6][0]) ) p->Natoms=atoi(buf[6]);  else p->Natoms=0;
        if( isdigit(      buf[7][0]) ) p->aaval=atof(buf[7]);  else p->aaval=0.0;
        if( ns!= RESLIB_TAB_N ) fprintf(errout,"\nMISMATCH %d-%d  line: %s",ns,RESLIB_TAB_N,str);
	i++;
     };
     nrtab=i;
  };


  /***************** SET RESLIB_TAB25  ****************************************/
  {   int i; RESLIB_TAB25 *p;
      for(i=0;i<MAXRTAB25;i++) rtab25[i].anames[0]=0;
      p=rtab25;
      strcpy( p[_ALA_].anames,"H HA HB C CA CB N");
      strcpy( p[_ARG_].anames,"H HA HB2 HB3 HG2 HG3 HD2 HD3 HE HH11 HH12 HH21 HH22 C CA CB CG CD CZ N NE NH1 NH2");
      strcpy( p[_ASN_].anames,"H HA HB2 HB3 HD21 HD22 C CA CB CG N ND2");
      strcpy( p[_ASP_].anames,"H HA HB2 HB3 C CA CB CG N");
      strcpy( p[_CYS_].anames,"H HA HB2 HB3 HG C CA CB N");
      strcpy( p[_GLN_].anames,"H HA HB2 HB3 HG2 HG3 HE21 HE22 C CA CB CG CD N NE2");
      strcpy( p[_GLU_].anames,"H HA HB2 HB3 HG2 HG3 C CA CB CG CD N");
      strcpy( p[_GLY_].anames,"H HA2 HA3 C CA N");
      strcpy( p[_HIS_].anames,"H HA HB2 HB3 HD1 HD2 HE1 HE2 C CA CB CG CD2 CE1 N ND1 NE2");
      strcpy( p[_ILE_].anames,"H HA HB HG12 HG13 HG2 HD1 C CA CB CG1 CG2 CD1 N");
      strcpy( p[_LEU_].anames,"H HA HB2 HB3 HG HD1 HD2 C CA CB CG CD1 CD2 N");
      strcpy( p[_LYS_].anames,"H HA HB2 HB3 HG2 HG3 HD2 HD3 HE2 HE3 HZ C CA CB CG CD CE N NZ");
      strcpy( p[_MET_].anames,"H HA HB2 HB3 HG2 HG3 HE C CA CB CG CE N");
      strcpy( p[_PHE_].anames,"H HA HB2 HB3 HD1 HD2 HE1 HE2 HZ C CA CB CG CD1 CD2 CE1 CE2 CZ N");
      strcpy( p[_PRO_].anames,"HA HB2 HB3 HG2 HG3 HD2 HD3 C CA CB CG CD N");
      strcpy( p[_SER_].anames,"H HA HB2 HB3 HG C CA CB N");
      strcpy( p[_THR_].anames,"H HA HB HG2 HG1 C CA CB CG2 N");
      strcpy( p[_TRP_].anames,"H HA HB2 HB3 HD1 HE1 HE3 HZ2 HZ3 HH2 C CA CB CG CD1 CD2 CE2 CE3 CZ2 CZ3 N NE1");
      strcpy( p[_TYR_].anames,"H HA HB2 HB3 HD1 HD2 HE1 HE2 HH C CA CB CG CD1 CD2 CE1 CE2 CZ N");
      strcpy( p[_VAL_].anames,"H HA HB HG1 HG2 C CA CB CG1 CG2 N");
      for(i=0;i<MAXRTAB25;i++) if(p[i].anames[0]!=0) fprintf(errout,"%s\n",strlower(p[i].anames));
      
      /* Chemical shift values are taken from D.S.Wishart, J.Biomol.NMR, 5 (1995) 67-81) */
      /* nomenclature names for atoms are taken as for BMRB (BioMagResBank) */
      /* 1H, 13C chem. shifts are refenced to internal DSS at 25C, pH 5.0 */
      /* 15N     chem. shifts are refenced to external NH3 at 25C, pH 5.0 */
      for(i=0;i<MAXRTAB25;i++) rtab25[i].acs[0]=0;
      strcpy(p[_ALA_].acs,"H 8.24 HA 4.32 HB 1.39 "\
                          "C 177.8 CA 52.5 CB 19.1 N 123.8 ");
      strcpy(p[_ARG_].acs,"H 8.23 HA 4.34 HB2 1.86 HB3 1.76 HG2 1.63 HG3 1.63 HD2 3.20 HD3 3.20 HE 8.07 HH11 - HH12 - HH21 - HH22 - "\
                          "C 176.3 CA 56.0 CB 30.9 CG 27.1 CD 43.3 CZ 159.5 N 120.5 NE - NH1 - NH2 - ");
      strcpy(p[_ASN_].acs,"H 8.40 HA 4.74 HB2 2.83 HB3 2.75 HD21 7.59 HD22 6.91 "\
                          "C 175.2 CA 53.1 CB 38.9 CG 177.2 N 118.7 ND2 112.7 ");
      strcpy(p[_ASP_].acs,"H 8.34 HA 4.64 HB2 2.72 HB3 2.65 "\
                          "C 176.3 CA 54.2 CB 41.1 CG 180.0 N 120.4 ");
      strcpy(p[_CYS_].acs,"H 8.32 HA 4.55 HB2 2.93 HB3 2.93 HG - "\
                          "C 174.6 CA 58.2 CB 28.0 N 118.8 "); /* reduced */
      strcpy(p[_GLN_].acs,"H 8.32 HA 4.34 HB2 2.12 HB3 1.99 HG2 2.36 HG3 2.36 HE21 7.52 HE22 6.85 "\
                          "C 176.0 CA 55.7 CB 29.4 CG 33.7 CD 180.5 N 119.8 NE2 112.1 ");
      strcpy(p[_GLU_].acs,"H 8.42 HA 4.35 HB2 2.06 HB3 1.96 HG2 2.31 HG3 2.31 "\
                          "C 176.6 CA 56.6 CB 29.9 CG 35.6 CD 183.4 N 120.2 ");
      strcpy(p[_GLY_].acs,"H 8.33 HA2 3.96 HA3 3.96 "\
                          "C 174.9 CA 45.1 N 108.8 ");
      strcpy(p[_HIS_].acs,"H 8.42 HA 4.73 HB2 3.29 HB3 3.16 HD1 - HD2 7.29 HE1 8.58 HE2 - "\
                          "C 174.1 CA 55.0 CB 29.0 CG 131.1 CD2 120.1 CE1 136.2 N 118.2 ND1 - NE2 - ");
      strcpy(p[_ILE_].acs,"H 8.00 HA 4.17 HB 1.87 HG12 1.45 HG13 1.16 HG2 0.91 HD1 0.86 "\
                          "C 176.4 CA 61.1 CB 38.8 CG1 27.2 CG2 17.4 CD1 12.9 N 119.9 ");
      strcpy(p[_LEU_].acs,"H 8.16 HA 4.34 HB2 1.62 HB3 1.62 HG 1.59 HD1 0.92 HD2 0.87 "\
                          "C 177.6 CA 55.1 CB 42.4 CG 26.9 CD1 24.9 CD2 23.9 N 121.8 ");
      strcpy(p[_LYS_].acs,"H 8.29 HA 4.32 HB2 1.84 HB3 1.75 HG2 1.44 HG3 1.44 HD2 1.68 HD3 1.68 HE2 2.99 HE3 2.99 HZ 7.81 "\
                          "C 176.6 CA 56.2 CB 33.1 CG 24.7 CD 29.0 CE 41.9 N 120.4 NZ 125.9 ");
      strcpy(p[_MET_].acs,"H 8.28 HA 4.48 HB2 2.11 HB3 2.01 HG2 2.60 HG3 2.54 HE 2.10 "\
                          "C 176.3 CA 55.4 CB 32.9 CG 32.0 CE 16.9 N 119.6 ");
      strcpy(p[_PHE_].acs,"H 8.30 HA 4.62 HB2 3.14 HB3 3.04 HD1 7.28 HD2 7.28 HE1 7.38 HE2 7.38 HZ 7.32 "\
                          "C 175.8 CA 57.7 CB 39.6 CG 138.9 CD1 131.9 CD2 131.9 CE1 131.5 CE2 131.5 CZ 129.9 N 120.3 ");
      strcpy(p[_PRO_].acs,"  HA 4.42 HB2 2.29 HB3 1.94 HG2 2.02 HG3 2.02 HD2 3.63 HD3 3.63 "\
                          "C 177.3 CA 63.3 CB 32.1 CG 27.2 CD 49.8 N -");
      strcpy(p[_SER_].acs,"H 8.31 HA 4.47 HB2 3.89 HB3 3.87 HG - "\
                          "C 174.6 CA 58.3 CB 63.8 N 115.7 ");
      strcpy(p[_THR_].acs,"H 8.15 HA 4.35 HB 4.24 HG2 1.21 HG1 - "\
                          "C 174.7 CA 61.8 CB 69.8 CG2 21.5 N 113.6 ");
      strcpy(p[_TRP_].acs,"H 8.25 HA 4.66 HB2 3.29 HB3 3.27 HD1 7.27 HE1 10.22 HE3 7.65 HZ2 7.50 HZ3 7.18 HH2 7.25 "\
                          "C 176.1 CA 57.5 CB 29.6 CG 111.2 CD1 127.4 CD2 129.5 CE2 138.7 CE3 122.2 CZ2 114.7 CZ3 124.8 N 121.3 NE1 - ");
      strcpy(p[_TYR_].acs,"H 8.12 HA 4.55 HB2 3.03 HB3 2.98 HD1 7.14 HD2 7.14 HE1 6.84 HE2 6.84 HH - "\
                          "C 175.9 CA 57.9 CB 38.8 CG 130.6 CD1 133.3 CD2 133.3 CE1 118.2 CE2 118.2 CZ 157.3 N 120.3 ");
      strcpy(p[_VAL_].acs,"H 8.03 HA 4.12 HB 2.08 HG1 0.94 HG2 0.93 "\
                          "C 176.3 CA 62.2 CB 32.9 CG1 21.1 CG2 20.3 N 119.2 ");

     for(i=0;i<MAXRTAB25;i++) if(p[i].acs[0]!=0) fprintf(errout,"%s\n",strlower(p[i].acs));
     fprintf(errout,"RESLIB_TAB25 : set\n");

      /* rtab25n set to same as before only CA,CB changed to new values given by Stephan */
      for(i=0;i<MAXRTAB25;i++) rtab25n[i].acs[0]=0;
      p=rtab25n;
      strcpy(p[_ALA_].acs,"H 8.24 HA 4.32 HB 1.39 "\
                          "C 177.8 CA 52.3 CB 19.0 N 123.8 ");
      strcpy(p[_ARG_].acs,"H 8.23 HA 4.34 HB2 1.86 HB3 1.76 HG2 1.63 HG3 1.63 HD2 3.20 HD3 3.20 HE 8.07 HH11 - HH12 - HH21 - HH22 - "\
                          "C 176.3 CA 56.1 CB 30.3 CG 27.1 CD 43.3 CZ 159.5 N 120.5 NE - NH1 - NH2 - ");
      strcpy(p[_ASN_].acs,"H 8.40 HA 4.74 HB2 2.83 HB3 2.75 HD21 7.59 HD22 6.91 "\
                          "C 175.2 CA 52.8 CB 37.9 CG 177.2 N 118.7 ND2 112.7 ");
      strcpy(p[_ASP_].acs,"H 8.34 HA 4.64 HB2 2.72 HB3 2.65 "\
                          "C 176.3 CA 54.0 CB 40.8 CG 180.0 N 120.4 ");
      strcpy(p[_CYS_].acs,"H 8.32 HA 4.55 HB2 2.93 HB3 2.93 HG - "\
                          "C 174.6 CA 56.9 CB 28.9 N 118.8 "); /* reduced */
      strcpy(p[_GLN_].acs,"H 8.32 HA 4.34 HB2 2.12 HB3 1.99 HG2 2.36 HG3 2.36 HE21 7.52 HE22 6.85 "\
                          "C 176.0 CA 56.1 CB 28.4 CG 33.7 CD 180.5 N 119.8 NE2 112.1 ");
      strcpy(p[_GLU_].acs,"H 8.42 HA 4.35 HB2 2.06 HB3 1.96 HG2 2.31 HG3 2.31 "\
                          "C 176.6 CA 56.4 CB 29.7 CG 35.6 CD 183.4 N 120.2 ");
      strcpy(p[_GLY_].acs,"H 8.33 HA2 3.96 HA3 3.96 "\
                          "C 174.9 CA 45.1 N 108.8 ");
      strcpy(p[_HIS_].acs,"H 8.42 HA 4.73 HB2 3.29 HB3 3.16 HD1 - HD2 7.29 HE1 8.58 HE2 - "\
                          "C 174.1 CA 55.0 CB 29.0 CG 131.1 CD2 120.1 CE1 136.2 N 118.2 ND1 - NE2 - ");
      strcpy(p[_ILE_].acs,"H 8.00 HA 4.17 HB 1.87 HG12 1.45 HG13 1.16 HG2 0.91 HD1 0.86 "\
                          "C 176.4 CA 61.3 CB 38.0 CG1 27.2 CG2 17.4 CD1 12.9 N 119.9 ");
      strcpy(p[_LEU_].acs,"H 8.16 HA 4.34 HB2 1.62 HB3 1.62 HG 1.59 HD1 0.92 HD2 0.87 "\
                          "C 177.6 CA 55.1 CB 42.3 CG 26.9 CD1 24.9 CD2 23.9 N 121.8 ");
      strcpy(p[_LYS_].acs,"H 8.29 HA 4.32 HB2 1.84 HB3 1.75 HG2 1.44 HG3 1.44 HD2 1.68 HD3 1.68 HE2 2.99 HE3 2.99 HZ 7.81 "\
                          "C 176.6 CA 56.5 CB 32.5 CG 24.7 CD 29.0 CE 41.9 N 120.4 NZ 125.9 ");
      strcpy(p[_MET_].acs,"H 8.28 HA 4.48 HB2 2.11 HB3 2.01 HG2 2.60 HG3 2.54 HE 2.10 "\
                          "C 176.3 CA 55.3 CB 32.6 CG 32.0 CE 16.9 N 119.6 ");
      strcpy(p[_PHE_].acs,"H 8.30 HA 4.62 HB2 3.14 HB3 3.04 HD1 7.28 HD2 7.28 HE1 7.38 HE2 7.38 HZ 7.32 "\
                          "C 175.8 CA 58.0 CB 39.0 CG 138.9 CD1 131.9 CD2 131.9 CE1 131.5 CE2 131.5 CZ 129.9 N 120.3 ");
      strcpy(p[_PRO_].acs,"  HA 4.42 HB2 2.29 HB3 1.94 HG2 2.02 HG3 2.02 HD2 3.63 HD3 3.63 "\
                          "C 177.3 CA 63.1 CB 31.7 CG 27.2 CD 49.8 N -");
      strcpy(p[_SER_].acs,"H 8.31 HA 4.47 HB2 3.89 HB3 3.87 HG - "\
                          "C 174.6 CA 58.2 CB 63.2 N 115.7 ");
      strcpy(p[_THR_].acs,"H 8.15 HA 4.35 HB 4.24 HG2 1.21 HG1 - "\
                          "C 174.7 CA 62.1 CB 69.2 CG2 21.5 N 113.6 ");
      strcpy(p[_TRP_].acs,"H 8.25 HA 4.66 HB2 3.29 HB3 3.27 HD1 7.27 HE1 10.22 HE3 7.65 HZ2 7.50 HZ3 7.18 HH2 7.25 "\
                          "C 176.1 CA 57.7 CB 30.3 CG 111.2 CD1 127.4 CD2 129.5 CE2 138.7 CE3 122.2 CZ2 114.7 CZ3 124.8 N 121.3 NE1 - ");
      strcpy(p[_TYR_].acs,"H 8.12 HA 4.55 HB2 3.03 HB3 2.98 HD1 7.14 HD2 7.14 HE1 6.84 HE2 6.84 HH - "\
                          "C 175.9 CA 58.1 CB 38.8 CG 130.6 CD1 133.3 CD2 133.3 CE1 118.2 CE2 118.2 CZ 157.3 N 120.3 ");
      strcpy(p[_VAL_].acs,"H 8.03 HA 4.12 HB 2.08 HG1 0.94 HG2 0.93 "\
                          "C 176.3 CA 62.3 CB 32.1 CG1 21.1 CG2 20.3 N 119.2 ");

  };


  /***************** READ X_ALA,XALA_  TAB  ****************************************/
  { 
     int i,j,nsx,nsa,ci,ntab,ntax;
     X_ALA_TAB *px_;
     XALA__TAB *pa_;
     RESLIB_TAB *prt;
     j=0;  /* fx=Fopen(X_ALA_TAB_NAME,"r"); */
     strcpy(tax[j++],"# random coil ch.shifts (ref: D.S.Wishart, J.Biomol.NMR, 5 (1995) 67-81)  ");
     strcpy(tax[j++],"# 1H,13C  ref. internal DSS ; 15N ref. external NH3 at  t=25C pH=5.0      ");
     strcpy(tax[j++],"# corrected for GGx_A : 'x'  amino acid when followed by Ala              ");
     strcpy(tax[j++],"#res type  N      Hn    Ha   Hb1  Hb2   CO     Ca    Cb    Hg12 Hg13 Hg2  Hd1  Hd2   He1  He2  Hz1  Hz2  Hh  ");
     strcpy(tax[j++],"Ala  ----  123.8  8.24  4.32 1.39 -     177.8  52.5  19.1  -    -    -    -    -     -    -    -    -    -   ");
     strcpy(tax[j++],"Cys  red.  118.8  8.32  4.55 2.93 2.93  174.6  58.2  28.0  -    -    -    -    -     -    -    -    -    -   ");
     strcpy(tax[j++],"Cys  ox.   118.6  8.43  4.71 3.25 2.99  174.6  55.4  41.1  -    -    -    -    -     -    -    -    -    -   ");
     strcpy(tax[j++],"Asp  ----  120.4  8.34  4.64 2.72 2.65  176.3  54.2  41.1  -    -    -    -    -     -    -    -    -    -   ");
     strcpy(tax[j++],"Glu  ----  120.2  8.42  4.35 2.06 1.96  176.6  56.6  29.9  2.31 2.31 -    -    -     -    -    -    -    -   ");
     strcpy(tax[j++],"Phe  ----  120.3  8.30  4.62 3.14 3.04  175.8  57.7  39.6  -    -    -    7.28 7.28  7.38 7.38 7.32 -    -   ");
     strcpy(tax[j++],"Gly  ----  108.8  8.33  3.96 -    -     174.9  45.1   -    -    -    -    -    -     -    -    -    -    -   ");
     strcpy(tax[j++],"His  ----  118.2  8.42  4.73 3.29 3.16  174.1  55.0  29.0  -    -    -    -    7.29  8.58 -    -    -    -   ");
     strcpy(tax[j++],"Ile  ----  119.9  8.00  4.17 1.87 -     176.4  61.1  38.8  1.45 1.16 0.91 0.86 -     -    -    -    -    -   ");
     strcpy(tax[j++],"Lys  ----  120.4  8.29  4.32 1.84 1.75  176.6  56.2  33.1  1.44 1.44 -    1.68 1.68  2.99 2.99 7.81 -    -   ");
     strcpy(tax[j++],"Leu  ----  121.8  8.16  4.34 1.62 1.62  177.6  55.1  42.4  1.59 -    -    0.92 0.87  -    -    -    -    -   ");
     strcpy(tax[j++],"Met  ----  119.6  8.28  4.48 2.11 2.01  176.3  55.4  32.9  2.60 2.54 -    -    -     2.10 -    -    -    -   ");
     strcpy(tax[j++],"Asn  ----  118.7  8.40  4.74 2.83 2.75  175.2  53.1  38.9  -    -    -    7.59 6.91  -    -    -    -    -   ");
     strcpy(tax[j++],"Pro  ----  -      -     4.42 2.29 1.94  177.3  63.3  32.1  2.02 2.02 -    3.63 3.63  -    -    -    -    -   ");
     strcpy(tax[j++],"Gln  ----  119.8  8.32  4.34 2.12 1.99  176.0  55.7  29.4  2.36 2.36 -    -    -     7.52 6.85 -    -    -   ");
     strcpy(tax[j++],"Arg  ----  120.5  8.23  4.34 1.86 1.76  176.3  56.0  30.9  1.63 1.63 -    3.20 3.20  8.07 -    -    -    -   ");
     strcpy(tax[j++],"Ser  ----  115.7  8.31  4.47 3.89 3.87  174.6  58.3  63.8  -    -    -    -    -     -    -    -    -    -   ");
     strcpy(tax[j++],"Thr  ----  113.6  8.15  4.35 4.24 -     174.7  61.8  69.8  -    -    1.21 -    -     -    -    -    -    -   ");
     strcpy(tax[j++],"Val  ----  119.2  8.03  4.12 2.08 -     176.3  62.2  32.9  0.94 0.93 -    -    -     -    -    -    -    -   ");
     strcpy(tax[j++],"Trp  ----  121.3  8.25  4.66 3.29 3.27  176.1  57.5  29.6  -    -    -    7.27 -    10.22 7.63 7.50 7.18 7.25");
     strcpy(tax[j++],"Tyr  ----  120.3  8.12  4.55 3.03 2.98  175.9  57.9  38.8  -    -    -    7.14 7.14  6.84 6.84 -    -    -   ");
     ntax=j;
     j=0;  /* fa=Fopen(XALA__TAB_NAME,"r"); */
     strcpy(tab[j++],"# random coil ch.shifts (ref: D.S.Wishart, J.Biomol.NMR, 5 (1995) 67-81) ");
     strcpy(tab[j++],"# 1H,13C  ref. internal DSS ; 15N ref. external NH3 at  t=25C pH=5.0     ");
     strcpy(tab[j++],"# corrected for GGxA_ : 'Ala'  when preceded by  x amino acid  (Hb1  Hb2  Cb - average) ");
     strcpy(tab[j++],"#res type  N      Hn    Ha    Hb2  Hb3   CO     Ca    Cb   ");
     strcpy(tab[j++],"Ala  ----  123.2  8.34  4.33  1.39 1.39  178.5  52.6  19.1 ");
     strcpy(tab[j++],"Cys  red.  126.7  8.51  4.35  1.39 1.39  178.3  52.8  19.1 ");
     strcpy(tab[j++],"Cys  ox.   126.1  8.50  4.35  1.39 1.39  178.2  52.9  19.1 ");
     strcpy(tab[j++],"Asp  ----  124.8  8.38  4.33  1.39 1.39  178.5  52.9  19.1 ");
     strcpy(tab[j++],"Glu  ----  125.2  8.44  4.34  1.39 1.39  178.5  52.7  19.1 ");
     strcpy(tab[j++],"Phe  ----  126.4  8.38  4.31  1.39 1.39  178.0  52.5  19.1 ");
     strcpy(tab[j++],"Gly  ----  124.0  8.30  4.35  1.39 1.39  178.5  52.7  19.1 ");
     strcpy(tab[j++],"His  ----  125.8  8.47  4.37  1.39 1.39  178.2  52.7  19.1 ");
     strcpy(tab[j++],"Ile  ----  128.2  8.47  4.34  1.39 1.39  178.3  52.7  19.1 ");
     strcpy(tab[j++],"Lys  ----  125.6  8.42  4.34  1.39 1.39  178.3  52.6  19.1 ");
     strcpy(tab[j++],"Leu  ----  125.0  8.36  4.32  1.39 1.39  178.4  52.7  19.1 ");
     strcpy(tab[j++],"Met  ----  125.1  8.40  4.34  1.39 1.39  178.3  52.7  19.1 ");
     strcpy(tab[j++],"Asn  ----  124.7  8.38  4.34  1.39 1.39  178.3  52.8  19.1 ");
     strcpy(tab[j++],"Pro  ----  124.4  8.50  4.33  1.39 1.39  178.6  52.7  19.1 ");
     strcpy(tab[j++],"Gln  ----  125.3  8.44  4.34  1.39 1.39  178.4  52.7  19.1 ");
     strcpy(tab[j++],"Arg  ----  125.4  8.44  4.35  1.39 1.39  178.3  52.6  19.1 ");
     strcpy(tab[j++],"Ser  ----  125.9  8.42  4.37  1.39 1.39  178.3  52.7  19.1 ");
     strcpy(tab[j++],"Thr  ----  126.4  8.43  4.36  1.39 1.39  178.3  52.7  19.1 ");
     strcpy(tab[j++],"Val  ----  127.9  8.48  4.34  1.39 1.39  178.4  52.7  19.1 ");
     strcpy(tab[j++],"Trp  ----  126.8  8.26  4.23  1.39 1.39  179.0  52.3  19.1 ");
     strcpy(tab[j++],"Tyr  ----  126.8  8.35  4.31  1.39 1.39  177.9  52.4  19.1 ");
     ntab=j;

     for(ci=0,i=0,j=0; j<ntab && j<ntax; j++ )
     {  strcpy(strx,tax[j]); strcpy(stra,tab[j]);
	if( strx[0]=='#' || stra[0]=='#' ) { if(ci>=0 && ci<=3) strcpy(comments[ci],strx); ci++; continue; };
        px_=&x_ala[i]; px_->i=i;
        pa_=&xala_[i]; pa_->i=i;
        nsx=sscanf(strx,"%s%s%s%s%s%s%s%s%s%s %s%s%s%s%s%s%s%s%s%s",
                                              buf[0],buf[1],buf[2],buf[3],buf[4],buf[5],buf[6],buf[7],buf[8],buf[9],
                                              buf[10],buf[11],buf[12],buf[13],buf[14],buf[15],buf[16],buf[17],buf[18],buf[19]);
        strcpy(px_->rname3, strupper(buf[0]));
        prt = get_restab_item(3,px_->rname3);  strncpy(px_->rname1,prt->rname1,1);
        strcpy(px_->type,buf[ 1]);
        px_->N   =  atof(buf[ 2]);
        px_->Hn  =  atof(buf[ 3]);
        px_->Ha  =  atof(buf[ 4]);
        px_->Hb2 =  atof(buf[ 5]);
        px_->Hb3 =  atof(buf[ 6]);
        px_->CO  =  atof(buf[ 7]);
        px_->Ca  =  atof(buf[ 8]);
        px_->Cb  =  atof(buf[ 9]);
        px_->Hg12=  atof(buf[10]);
        px_->Hg13=  atof(buf[11]);
        px_->Hg2 =  atof(buf[12]);
        px_->Hd1 =  atof(buf[13]);
        px_->Hd2 =  atof(buf[14]);
        px_->He1 =  atof(buf[15]);
        px_->He2 =  atof(buf[16]);
        px_->Hz1 =  atof(buf[17]);
        px_->Hz2 =  atof(buf[18]);
        px_->Hh  =  atof(buf[19]);
        nsa=sscanf(stra,"%s%s%s%s%s%s%s%s%s%s",buf[0],buf[1],buf[2],buf[3],buf[4],buf[5],buf[6],buf[7],buf[8],buf[9]);
        strcpy(pa_->rname3, strupper(buf[0]));
        prt = get_restab_item(3,pa_->rname3);  strncpy(pa_->rname1,prt->rname1,1);
        prt25=&rtab25[ (int)prt->rname1[0]-(int)'A']; 
        strncpy(prt25->rname3,prt->rname3,3); 
        strncpy(prt25->rname1,prt->rname1,1); 
        strcpy(pa_->type  , buf[ 1]);
        pa_->N   =  atof(buf[ 2]);
        pa_->Hn  =  atof(buf[ 3]);
        pa_->Ha  =  atof(buf[ 4]);
        pa_->Hb2 =  atof(buf[ 5]);
        pa_->Hb3 =  atof(buf[ 6]);
        pa_->CO  =  atof(buf[ 7]);
        pa_->Ca  =  atof(buf[ 8]);
        pa_->Cb  =  atof(buf[ 9]);
        i++;
     };
     nx_ala=nxala_=i;
  };


  /***************** CALC  dN   & dHn  (GGyA-GGGA) to  XALA__TAB  ****************************************/
  {  int i;
     XALA__TAB *pa_;
     XALA__TAB *pg_;
     pg_=&xala_[GLYPOSTAB];
     for(i=0; i<nx_ala; i++)
     {   pa_=&xala_[i];
         pa_->dN  = pa_->N   - pg_->N  ;
         pa_->dHn = pa_->Hn  - pg_->Hn ;
         pa_->dHa = pa_->Ha  - pg_->Ha ;
         pa_->dHb2= pa_->Hb2 - pg_->Hb2;
         pa_->dHb3= pa_->Hb3 - pg_->Hb3;
         pa_->dCO = pa_->CO  - pg_->CO ;
         pa_->dCa = pa_->Ca  - pg_->Ca ;
         pa_->dCb = pa_->Cb  - pg_->Cb ;
     };
  };

  /***************** READ cs reference shifts from CS_REF_NAME ****************************************/
  {  int nsr; FILE *fr;
     XALA__TAB *p;
      if( NULL==(fr=fopen(CS_REF_NAME,"r")) ) 
      {  fr=fopen(CS_REF_NAME,"w");
	 fprintf(fr,"#atom N15  Hn    Ha    Hb2   Hb3   CO    Ca    Cb   \n");
	 fprintf(fr,"rc    0.00 0.00  0.00  0.00  0.00  0.00  0.00  0.00 \n");
	 fprintf(fr,"exper 0.00 0.00  0.00  0.00  0.00  0.00  0.00  0.00 \n");
	 fprintf(fr,"err   0.05 0.01  0.03  0.03  0.03  0.20  0.20  0.20 ");
	 fclose(fr);
         fr=fopen(CS_REF_NAME,"r");
      };
      fgets(line,1024,fr);

      p=&cs_ref_shifts; fgets(line,1024,fr); strcpy(cs_ref_line,line);
      nsr=sscanf(cs_ref_line,"%s%f%f%f%f%f%f%f%f",buf[0],&p->dN  , &p->dHn, &p->dHa, &p->dHb2, &p->dHb3, &p->dCO, &p->dCa, &p->dCb);
      if( nsr<9 ) fprintf(errout,"# something is wrong with the file '%s' \n#on line '%s' no 9 float items\n",CS_REF_NAME,cs_ref_line);

      p=&cs_exper_shifts; fgets(line,1024,fr);
      nsr=sscanf(line,"%s%f%f%f%f%f%f%f%f",buf[0],&p->dN  , &p->dHn, &p->dHa, &p->dHb2, &p->dHb3, &p->dCO, &p->dCa, &p->dCb);

      p=&cs_error_shifts; fgets(line,1024,fr);
      nsr=sscanf(line,"%s%f%f%f%f%f%f%f%f",buf[0],&p->dN  , &p->dHn, &p->dHa, &p->dHb2, &p->dHb3, &p->dCO, &p->dCa, &p->dCb);

      fclose(fr);
      fprintf(errout,"%s : read\n",CS_REF_NAME);
  };

  /** **/



  fprintf(errout,"end of  init_cnmrlib()\n");
  return(0);
}



int close_cnmrlib()
{ fclose(errout);
   return(0);
/* end of close_cnmrlib() */
}





#define NATOMTYPES 2
char *get_better_aname(name)
char *name;
{ static char col_p[NATOMTYPES][4]={ "HN","CO"};
  static char col_t[NATOMTYPES][4]={ "H" ,"C" };
  static int i; 
  for(i=0;i<NATOMTYPES; i++) 
     if(strncmp(name,&col_p[i][0],strlen(&col_p[i][0]))==0) return(&col_t[i][0]);
  /*fprintf(errout,"not found colomn name '%s'\n",name);*/
  return(name);
}

#define NABBRATOMTYPES 2
char *get_abbrev_aname(name)
char *name;
{ static int i;  
  static char abbrname[128];
 for(i=0; isalpha(name[i]); i++) abbrname[i]=name[i]; abbrname[i]=0;
 /*fprintf(errout,"name=%s abbr=%s \n",name,abbrname);*/
 return(abbrname);
}



float get_atom_shift(coltype,a)
int coltype;
char a;
{ static float val;
  static XALA__TAB *p;
  switch(a)
  { default: 
    case CS_REF_SHIFTS:   p =&cs_ref_shifts; break;
    case CS_EXPER_SHIFTS: p =&cs_exper_shifts; break;
    case CS_ERROR_SHIFTS: p =&cs_error_shifts; break;
  };
  switch(coltype)
  { case _N_   :  val = p->dN  ; break;
    case _Hn_  :  val = p->dHn ; break;
    case _Ha_  :  
    case _Hb_ :  
    case _Hg_  :  
    case _Hd_  :  
    case _He_  :  
    case _Hz_  :  
    case _Hh_  :  
                  val = p->dHa ; break;
    case _CO_  :  val = p->dCO ; break;
    case _Ca_  :  
    case _Cb_  :  
    case _Cg_  :  
    case _Cd_  :  
    case _Ce_  :  
    case _Cz_  :  
                  val = p->dCa ; break;
    default:      val = 0.0;     break;
  };
  return(val);
}


int get_abbr_aname_i(name,rname1)
char *name;
char *rname1;
{  static char aname[32];
   static int  atype;
        strcpy(aname,strupper(name)); atype=0;
        if( strncmp(aname,"HA",2)==0 ) atype=_Ha_;
        if( strncmp(aname,"HB",2)==0 ) atype=_Hb_;
        if( strncmp(aname,"HG",2)==0 ) atype=_Hg_;
        if( strncmp(aname,"HD",2)==0 ) atype=_Hd_;
        if( strncmp(aname,"HE",2)==0 ) atype=_He_;
        if( strncmp(aname,"HZ",2)==0 ) atype=_Hz_;
        if( strncmp(aname,"HH",2)==0 ) atype=_Hh_;
        if( strncmp(aname,"CA",2)==0 ) atype=_Ca_;
        if( strncmp(aname,"CB",2)==0 ) atype=_Cb_;
        if( strncmp(aname,"CG",2)==0 ) atype=_Cg_;
        if( strncmp(aname,"CD",2)==0 ) atype=_Cd_;
        if( strncmp(aname,"CE",2)==0 ) atype=_Ce_;
        if( strncmp(aname,"CZ",2)==0 ) atype=_Cz_;
        if( strncmp(aname,"CO",2)==0 ) atype=_CO_;
        if( strncmp(aname,"C",1)==0 )  atype=_CO_;
        if( strncmp(aname,"N", 1)==0 ) atype=_N_;
        if( strncmp(aname,"H" ,1)==0 ) atype=_Hn_;
 return(atype);
}

int printBMRBitem(out,p)
FILE *out;
BMRB_ITEM *p;
{
   fprintf(out ,"%10d%5d%6s  %-4s  %-1s",p->i,p->n,p->rname3,p->aname,p->atype);
   if(p->cs==0.0 && p->amb_code==0) fprintf(out ,"    @       @      @ \n");
   else 
   {  if(pB->atype[0]=='C') fprintf(out ,"%9.3f %7.3f  %-1d  \n",p->cs,p->err,p->amb_code);
      else                  fprintf(out ,"%9.3f %7.3f  %-1d  \n",p->cs,p->err,p->amb_code);
   };
 return(0);
}



/*** get random coil value for residue 'rname1' atom 'aname' from reslib_tab25 */
/*** note that 'aname' is a full BMRB atom name */

float get_rcoil_val25(rname1,aname)
char *rname1;
char *aname;
{ static char *pat,saname[64],scs[64]; 
  static int ns;
  static RESLIB_TAB25 *p25;
  static XALA__TAB *pr;
  pr =&cs_exper_shifts; 
  p25=&rtab25[ toupper(rname1[0])-(int)'A'];
  pat=strstr(&p25->acs[0],aname);    if(pat==NULL) return(0.0); /* unknown atom */
  ns=sscanf(pat,"%s%s",saname,scs);  if(ns < 2)    return(0.0); /* unknown atom */
  if(strcmp(aname,saname)!=0 ) fprintf(errout,"#? mismatch in atomnames '%s' '%s' \n",aname,saname);
  return( atof(scs) );
}



int get_ambiguity_code(r,ir)
RES_LINE_ITEM *r;
int ir;
{ fprintf(errout,"%s %s %d\n",r->rname3,r->aname[ir],r->d[ir]);
 /* general ambiguity follows */ /* r->d=0 if no similar present; r->d!=0 if similar present */
 
 if( strcmp(  r->aname[ir],"H"   )==0 ) return(1);
 if( strncmp( r->aname[ir],"N", 1)==0 ) return(1);
 if( strncmp( r->aname[ir],"C", 1)==0 ) return(1);

 if( strncmp( r->aname[ir],"HA",2)==0 )
 {  if( strncmp( r->rname3,"GLY",3)==0 && r->d[ir]==0 ) return(2); else  return(1);
 };

 if( strncmp( r->aname[ir],"HB",2)==0 )
 {  if( strncmp( r->rname3,"ALA",3)==0 || 
        strncmp( r->rname3,"ILE",3)==0 ||
        strncmp( r->rname3,"THR",3)==0 ||
        strncmp( r->rname3,"VAL",3)==0 ) return(1);
        if( r->d[ir]==0 ) return(2); else  return(1);
 };

 if( strncmp( r->aname[ir],"HG",2)==0 )
 {  if( strncmp( r->rname3,"CYS",3)==0 ||
        strncmp( r->rname3,"LEU",3)==0 ||
        strncmp( r->rname3,"THR",3)==0 ||
        strncmp( r->rname3,"SER",3)==0 ) return(1);
    if( r->d[ir]==0 ) return(2); else  return(1);
 };

 if( strncmp( r->aname[ir],"HD",2)==0 )
 {  if( strncmp( r->rname3,"ILE",3)==0 ||
        strncmp( r->rname3,"TRP",3)==0 ) return(1);
    if( r->d[ir]==0 ) return(2); else  return(1);
 };

 if( strncmp( r->aname[ir],"HE",2)==0 )
 {  if( strncmp( r->rname3,"ARG",3)==0 ||
        strncmp( r->rname3,"MET",3)==0 ) return(1);
    if( strncmp( r->rname3,"TYR",3)==0 ) return(3);
    if( r->d[ir]==0 ) return(2); else  return(1);
 };

 if( strncmp( r->aname[ir],"HZ",2)==0 )
 {  if( r->d[ir]==0 ) return(2); else  return(1);
 };

 if( strncmp( r->aname[ir],"HH",2)==0 )
 {  if( r->d[ir]==0 ) return(2); else  return(1);
 };

 return(9);
/*
#      Chemical Shift Ambiguity Index Value Definitions  (from BMRB )
#   Index Value            Definition                             
#      1             Unique                                       
#      2             Ambiguity of geminal atoms or geminal methyl proton groups                           
#      3             Aromatic atoms on opposite sides of the ring (e.g. Tyr HE1 and HE2 protons)           
#      4             Intraresidue ambiguities (e.g. Lys HG and HD protons)                             
#      5             Interresidue ambiguities (Lys 12 vs. Lys 27) 
#      9             Ambiguous, specific ambiguity not defined    
#      p             Pseudoatom nomenclature used (Please use the nomenclature defined in the detailed instructions.)                 
*/
}



X_ALA_TAB *get_x_ala_item(n,name)
int n;
char *name;
{ static int i;
  static X_ALA_TAB *p;

  for(i=0; i<nx_ala; i++)
  {  p=&x_ala[i];
     switch(n)
     { case 1: default: if( strncmp(p->rname1,name,1)==0 ) return(p); break;
       case 3:          if( strncmp(p->rname3,name,3)==0 ) return(p); break;
     };
  };
  fprintf(errout,"\n not found entry for '%s' \n",name);
  abort();
  return(NULL);
}

XALA__TAB *get_xala__item(n,name)
int n;
char *name;
{ static int i;
  static XALA__TAB *p;

  for(i=0; i<nxala_; i++)
  {  p=&xala_[i];
     switch(n)
     { case 1: default: if( strncmp(p->rname1,name,1)==0 ) return(p); break;
       case 3:          if( strncmp(p->rname3,name,3)==0 ) return(p); break;
     };
  };
  fprintf(errout,"\n not found entry for '%s' \n",name);
  abort();
  return(NULL);
}


RESLIB_TAB *get_restab_item(n,name)
int n;
char *name;
{ static int i;
  static RESLIB_TAB *p;

  for(i=0; i<nrtab; i++)
  {  p=&rtab[i];
     switch(n)
     { case 1: default: if( strncmp(p->rname1,name,1)==0 ) return(p); break;
       case 3:          if( strncmp(p->rname3,name,3)==0 ) return(p); break;
     };
  };
  fprintf(errout,"\n not found entry for '%s' \n",name );
  abort();
  return(NULL);
}







FILE* Fopen(name,mode)
char *name;
char *mode;
{ static FILE *f;
  f=fopen(name,mode);
  if( f == NULL )
  { fprintf(errout,"\n(error) no file '%s' '%s'\n",name,mode); return(NULL);
  } else return(f);
}


char *strlower(s)
char *s;
{ static int i,l;
  static char u[512];
  l=strlen(s);
  for(i=0; i<=l; i++) u[i]= tolower( s[i] );
  return( &u[0] );
}


char *strupper(s)
char *s;
{ static int i,l;
  static char u[512];
  l=strlen(s);
  for(i=0; i<=l; i++) u[i]= toupper( s[i] );
  return( &u[0] );
}

int get_rname1i(rname1)
char *rname1;
{  static char rname[8];
   strcpy(rname,strupper(rname1));
   return( (int)rname[0]-(int)'A' );
}

int get_rname3i(rname3)
char *rname3;
{  static char rname[8];
   strncpy(rname,strupper(rname3),4);
   if(strncmp(rname,"ALA",3)==0) return(_ALA_);
   if(strncmp(rname,"ARG",3)==0) return(_ARG_);
   if(strncmp(rname,"ASN",3)==0) return(_ASN_);
   if(strncmp(rname,"ASP",3)==0) return(_ASP_);
   if(strncmp(rname,"CYS",3)==0) return(_CYS_);
   if(strncmp(rname,"GLN",3)==0) return(_GLN_);
   if(strncmp(rname,"GLU",3)==0) return(_GLU_);
   if(strncmp(rname,"GLY",3)==0) return(_GLY_);
   if(strncmp(rname,"HIS",3)==0) return(_HIS_);
   if(strncmp(rname,"ILE",3)==0) return(_ILE_);
   if(strncmp(rname,"LEU",3)==0) return(_LEU_);
   if(strncmp(rname,"LYS",3)==0) return(_LYS_);
   if(strncmp(rname,"MET",3)==0) return(_MET_);
   if(strncmp(rname,"PHE",3)==0) return(_PHE_);
   if(strncmp(rname,"PRO",3)==0) return(_PRO_);
   if(strncmp(rname,"SER",3)==0) return(_SER_);
   if(strncmp(rname,"THR",3)==0) return(_THR_);
   if(strncmp(rname,"TRP",3)==0) return(_TRP_);
   if(strncmp(rname,"TYR",3)==0) return(_TYR_);
   if(strncmp(rname,"VAL",3)==0) return(_VAL_);
   fprintf(errout,"#!! unknown 3rname: '%s' \n",rname3);
   return(0);
}


/* EOF  cnmrlib.c    */
